/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.ProgramHeader;
import com.uqm.crashsight.symtabtool.common.Section;
import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.dwarf.DwarfInfoBean;
import com.uqm.crashsight.symtabtool.dwarf.DwarfParser;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import com.uqm.crashsight.symtabtool.elf.ElfArmAttrParser;
import com.uqm.crashsight.symtabtool.elf.ElfHeaderParser;
import com.uqm.crashsight.symtabtool.elf.ElfProgramHeaderParser;
import com.uqm.crashsight.symtabtool.elf.ElfSectionParser;
import com.uqm.crashsight.symtabtool.elf.ElfStringParser;
import com.uqm.crashsight.symtabtool.elf.ElfSymtabParser;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import com.uqm.crashsight.symtabtool.symtab.SymtabMerger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public class ElfParser {
    public static final long FILE_FORMAT_INVALID = 0L;
    public static final long FILE_FORMAT_32 = 32L;
    public static final long FILE_FORMAT_64 = 64L;
    public static final int SHF_COMPRESSED = 2048;
    public static final String TEXT_SECTION = ".text";
    public static final String SYMTAB_SECTION = ".symtab";
    public static final String STRTAB_SECTION = ".strtab";
    public static final String DYN_SYMTAB_SECTION = ".dynsym";
    public static final String DYN_STRTAB_SECTION = ".dynstr";
    public static final String ARM_ATTR_SECTION = ".ARM.attributes";
    public static final String GNU_BUILD_ID_SECTION = ".note.gnu.build-id";
    public static final String CRASHSIGHT_VERSION_SECTION = ".crashSight_version";
    public static final String DEBUG_INFO_SECTION = ".debug_info";
    public static final String DEBUG_ABBREV_SECTION = ".debug_abbrev";
    public static final String DEBUG_LINE_SECTION = ".debug_line";
    public static final String DEBUG_RANGES_SECTION = ".debug_ranges";
    public static final String DEBUG_STR_SECTION = ".debug_str";
    public static final String DEBUG_PUBNAMES_SECTION = ".debug_pubnames";
    public static final String DEBUG_STR_OFFSETS_SECTION = ".debug_str_offsets";
    public static final String DEBUG_LINE_STR_SECTION = ".debug_line_str";
    public static final String DEBUG_RNGLISTS_SECTION = ".debug_rnglists";
    public static final String DEBUG_ADDR_SECTION = ".debug_addr";
    private static final long GNU_NOTE_TYPE_BUILD_ID = 3L;
    private static final int UUID_MAX_LENGTH = 16;
    private static final int FULL_UUID_MAX_LENGTH = 128;
    public String breakpadArch = null;
    private String fileName = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private String uuid = null;
    private String fullUuid = null;
    private String breakpadDebugId = null;
    private String breakpadCodeId = null;
    private String arch = null;
    private String soVersion = null;
    private HashMap<String, Section> sectionTable = null;
    private Vector<String> sectionNameTable = null;
    private Vector<Subroutine> subroutineTable = null;
    private SymbolTable symbolTable = null;
    private Vector<ProgramHeader> programHeaderTable = null;
    private ElfHeaderParser headerParser = null;
    private boolean needTruncate;

    private ElfParser(String string) {
        this.setFileName(string);
    }

    private ElfParser(String string, boolean bl) {
        this.setFileName(string);
        this.needTruncate = bl;
    }

    public static String getUuid(String string, boolean bl) {
        ElfParser elfParser = new ElfParser(string, bl);
        ElfHeaderParser elfHeaderParser = elfParser.parseHeaderInfo();
        if (null == elfHeaderParser) {
            Log.error("Failed to parse elf header", new Object[0]);
            return null;
        }
        if (!elfParser.parseSectionTable(elfHeaderParser)) {
            Log.error("Failed to parse section table", new Object[0]);
            return null;
        }
        if (!elfParser.parseUuid()) {
            Log.error("Failed to parse UUID of ELF file", new Object[0]);
        }
        return elfParser.uuid;
    }

    public static String getBreakpadDebugId(String string) {
        ElfParser elfParser = new ElfParser(string);
        ElfHeaderParser elfHeaderParser = elfParser.parseHeaderInfo();
        if (null == elfHeaderParser) {
            Log.error("Failed to parse elf header", new Object[0]);
            return null;
        }
        if (!elfParser.parseSectionTable(elfHeaderParser)) {
            Log.error("Failed to parse section table", new Object[0]);
            return null;
        }
        if (!elfParser.parseBreakpadDebugId()) {
            Log.error("Failed to parse Breakpad DebugId of ELF file", new Object[0]);
        }
        return elfParser.breakpadDebugId;
    }

    public static String getBreakpadCodeId(String string) {
        ElfParser elfParser = new ElfParser(string);
        ElfHeaderParser elfHeaderParser = elfParser.parseHeaderInfo();
        if (null == elfHeaderParser) {
            Log.error("Failed to parse elf header", new Object[0]);
            return null;
        }
        if (!elfParser.parseSectionTable(elfHeaderParser)) {
            Log.error("Failed to parse section table", new Object[0]);
            return null;
        }
        if (!elfParser.parseBreakpadCodeId()) {
            Log.error("Failed to parse Breakpad CodeId of ELF file", new Object[0]);
        }
        return elfParser.breakpadCodeId;
    }

    public static String getArch(String string) {
        ElfParser elfParser = new ElfParser(string);
        ElfHeaderParser elfHeaderParser = elfParser.parseHeaderInfo();
        if (null == elfHeaderParser) {
            Log.error("Failed to parse elf header", new Object[0]);
            return null;
        }
        String string2 = elfHeaderParser.getArchName();
        if (!string2.equals("armeabi")) {
            return string2;
        }
        if (!elfParser.parseSectionTable(elfHeaderParser)) {
            Log.error("Failed to parse section table", new Object[0]);
            return string2;
        }
        Section section = elfParser.sectionTable.get(ARM_ATTR_SECTION);
        if (null == section) {
            Log.error("No .ARM.attributes section in the elf file", new Object[0]);
            return string2;
        }
        return ElfArmAttrParser.getArch(string, elfParser.endian, section.getOffset());
    }

    public static boolean isElf(String string) {
        return ElfHeaderParser.isElf(string);
    }

    public static boolean isDebugElf(String string) {
        ElfParser elfParser = new ElfParser(string);
        ElfHeaderParser elfHeaderParser = elfParser.parseHeaderInfo();
        if (null == elfHeaderParser) {
            Log.error("Failed to parse elf header", new Object[0]);
            return false;
        }
        if (!elfParser.parseSectionTable(elfHeaderParser)) {
            Log.error("Failed to parse section table", new Object[0]);
            return false;
        }
        return elfParser.getDwarfInfoBean() != null;
    }

    public static ElfParser create(String string) {
        ElfParser elfParser = new ElfParser(string);
        if (!elfParser.parse()) {
            return null;
        }
        return elfParser;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setFileName(String string) {
        this.fileName = string;
    }

    public ElfHeaderParser getHeaderParser() {
        return this.headerParser;
    }

    public long getFileFormat() {
        return this.fileFormat;
    }

    private void setFileFormat(long l) {
        this.fileFormat = l;
    }

    public long getEndian() {
        return this.endian;
    }

    private void setEndian(long l) {
        this.endian = l;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getFullUuid() {
        return this.fullUuid;
    }

    public boolean setUuid(String string) {
        if (string != null) {
            this.uuid = string;
            return true;
        }
        return false;
    }

    public String getBreakpadDebugId() {
        return this.breakpadDebugId;
    }

    public String getBreakpadCodeId() {
        return this.breakpadCodeId;
    }

    public String getArch() {
        return this.arch;
    }

    public String getSoVersion() {
        return this.soVersion;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    private void setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public HashMap<String, Section> getSectionTable() {
        return this.sectionTable;
    }

    public Vector<Long> getProgramVaddr() {
        Vector<Long> vector = new Vector<Long>();
        for (ProgramHeader programHeader : this.programHeaderTable) {
            if (programHeader.getP_flags() % 2L == 0L) continue;
            vector.add(programHeader.getP_vaddr());
        }
        return vector;
    }

    public Vector<Long> getProgramOffset() {
        Vector<Long> vector = new Vector<Long>();
        for (ProgramHeader programHeader : this.programHeaderTable) {
            if (programHeader.getP_flags() % 2L == 0L) continue;
            vector.add(programHeader.getP_offset());
        }
        return vector;
    }

    public Vector<Long> getProgramAlign() {
        Vector<Long> vector = new Vector<Long>();
        for (ProgramHeader programHeader : this.programHeaderTable) {
            if (programHeader.getP_flags() % 2L == 0L) continue;
            vector.add(programHeader.getP_align());
        }
        return vector;
    }

    public long getModuleBase() {
        long l = 0L;
        for (ProgramHeader programHeader : this.programHeaderTable) {
            if (programHeader.getP_offset() != 0L) continue;
            l = programHeader.getP_vaddr();
            return l;
        }
        return l;
    }

    private ElfHeaderParser parseHeaderInfo() {
        ElfHeaderParser elfHeaderParser = ElfHeaderParser.create(this.fileName);
        if (null == elfHeaderParser) {
            return null;
        }
        this.setFileFormat(elfHeaderParser.getFileFormat());
        this.setEndian(elfHeaderParser.getEndian());
        return elfHeaderParser;
    }

    private boolean parseSectionTable(ElfHeaderParser elfHeaderParser) {
        ElfSectionParser elfSectionParser = new ElfSectionParser(this.fileName, this.fileFormat, this.endian);
        this.sectionTable = elfSectionParser.getSectionInfoTable(elfHeaderParser.getSectionHeaderTableOffset(), elfHeaderParser.getSectionNumber(), elfHeaderParser.getStringTableHeaderIndex());
        if (null == this.sectionTable) {
            return false;
        }
        this.sectionNameTable = elfSectionParser.getSectionNameTable();
        return true;
    }

    public ParseBuffer getSectionData(Section section) {
        ElfSectionParser elfSectionParser = new ElfSectionParser(this.fileName, this.fileFormat, this.endian);
        return elfSectionParser.getSectionData(section);
    }

    private boolean parseProgramHeaderTable(ElfHeaderParser elfHeaderParser) {
        ElfProgramHeaderParser elfProgramHeaderParser = new ElfProgramHeaderParser(this.fileName, this.fileFormat, this.endian);
        this.programHeaderTable = elfProgramHeaderParser.getProgramHeaderInfoTable(elfHeaderParser.getProgramHeaderTableOffset(), elfHeaderParser.getProgramNumber());
        return null != this.programHeaderTable;
    }

    private ElfStringParser getStringSectionParser() {
        Section section = this.sectionTable.get(STRTAB_SECTION);
        if (null == section && null == (section = this.sectionTable.get(DYN_STRTAB_SECTION))) {
            Log.error("No string section in the elf file", new Object[0]);
            return null;
        }
        return new ElfStringParser(this.fileName, section.getOffset(), section.getSize());
    }

    private boolean parseSubroutineTable(ElfStringParser elfStringParser) {
        ElfSymtabParser elfSymtabParser = new ElfSymtabParser(this.fileName, this.fileFormat, this.endian);
        Section section = this.sectionTable.get(SYMTAB_SECTION);
        if (null == section && null == (section = this.sectionTable.get(DYN_SYMTAB_SECTION))) {
            Log.error("No symtab section in the elf file", new Object[0]);
            return false;
        }
        long l = section.getSize() / section.getEntrySize();
        this.subroutineTable = elfSymtabParser.getSubroutineTable(section.getOffset(), l, elfStringParser, this.sectionNameTable);
        if (null == this.subroutineTable) {
            return false;
        }
        elfStringParser.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseSoVersion() {
        Section section = this.sectionTable.get(CRASHSIGHT_VERSION_SECTION);
        if (null == section) {
            Log.warn("No %s section in the elf file", CRASHSIGHT_VERSION_SECTION);
            return false;
        }
        try (BinaryFileReader binaryFileReader = null;){
            binaryFileReader = new BinaryFileReader(this.fileName);
            binaryFileReader.skip(section.getOffset());
            byte[] byArray = new byte[(int)section.getSize()];
            if (!binaryFileReader.readByteArray(byArray)) {
                boolean bl = false;
                return bl;
            }
            this.soVersion = new String(byArray, "utf-8").trim();
            boolean bl = true;
            return bl;
        }
    }

    private boolean parseArch(ElfHeaderParser elfHeaderParser) {
        this.arch = elfHeaderParser.getArchName();
        if (!this.arch.equals("armeabi")) {
            return true;
        }
        Section section = this.sectionTable.get(ARM_ATTR_SECTION);
        if (null == section) {
            Log.warn("No .ARM.attributes section in the elf file", new Object[0]);
            return true;
        }
        String string = ElfArmAttrParser.getArch(this.fileName, this.endian, section.getOffset());
        if (null != string) {
            this.arch = string;
        }
        return true;
    }

    private boolean parse() {
        ElfStringParser elfStringParser;
        Log.info("Begin to parse file: %s", this.fileName);
        ElfHeaderParser elfHeaderParser = this.parseHeaderInfo();
        if (null == elfHeaderParser) {
            Log.error("Failed to parse elf header", new Object[0]);
            return false;
        }
        this.headerParser = elfHeaderParser;
        if (!this.parseSectionTable(elfHeaderParser)) {
            Log.error("Failed to parse section table", new Object[0]);
            return false;
        }
        if (!this.parseProgramHeaderTable(elfHeaderParser)) {
            Log.error("Failed to parse programHeader table", new Object[0]);
            return false;
        }
        if (!this.parseUuid()) {
            Log.error("Failed to parse SHA-1", new Object[0]);
            return false;
        }
        try {
            if (!this.parseFullUuid()) {
                Log.error("Failed to parse SHA-1", new Object[0]);
                return false;
            }
        }
        catch (Exception exception) {
            Log.error("Failed to parse full uuid", new Object[0]);
        }
        this.parseSoVersion();
        if (!this.parseArch(elfHeaderParser)) {
            Log.warn("Failed to parse arch", new Object[0]);
        }
        if (null == (elfStringParser = this.getStringSectionParser())) {
            Log.warn("Please check whether it is a debug SO file", new Object[0]);
            return false;
        }
        if (!this.parseSubroutineTable(elfStringParser)) {
            Log.error("Failed to extract subroutine table", new Object[0]);
            return false;
        }
        Log.info("Successfully parsed the file!", new Object[0]);
        Log.info("Begin to extract symbol table...", new Object[0]);
        DwarfInfoBean dwarfInfoBean = this.getDwarfInfoBean();
        SymbolTable symbolTable = null;
        if (null == dwarfInfoBean) {
            Log.warn("Failed to get DWARF info!", new Object[0]);
            symbolTable = SymtabMerger.getSymtabTable(this.subroutineTable);
            symbolTable.setHasDwarfInfo(false);
        } else {
            long l = System.currentTimeMillis();
            symbolTable = DwarfParser.getSymbolTable(this.subroutineTable, dwarfInfoBean);
            Log.info("[Time]DwarfParser.getSymbolTable cost %d[ms]", System.currentTimeMillis() - l);
            if (null == symbolTable) {
                Log.error("Failed to extract symbol table from DWARF section!", new Object[0]);
                return false;
            }
            symbolTable.setHasDwarfInfo(true);
        }
        this.setSymbolTable(symbolTable);
        Log.info("Successfully extracted symbol table!", new Object[0]);
        return true;
    }

    private DwarfInfoBean getDwarfInfoBean() {
        Section section;
        Section section2;
        Section section3;
        Section section4;
        DwarfInfoBean dwarfInfoBean = new DwarfInfoBean();
        dwarfInfoBean.setFileName(this.fileName);
        dwarfInfoBean.set32bitElf(this.fileFormat == 32L);
        dwarfInfoBean.setLittleEndian(this.endian == BinaryFileReader.LITTLE_ENDIAN);
        Section section5 = this.sectionTable.get(DEBUG_ABBREV_SECTION);
        if (null == section5) {
            Log.warn("No debug_abbrev section in the elf file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugAbbrevOffset(section5.getOffset());
        dwarfInfoBean.setDebugAbbrevSize(section5.getSize());
        dwarfInfoBean.setDebugAbbrevCompressed(this.isCompressed(section5.getFlags()));
        Section section6 = this.sectionTable.get(DEBUG_INFO_SECTION);
        if (null == section6) {
            Log.warn("No debug_info section in the file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugInfoOffset(section6.getOffset());
        dwarfInfoBean.setDebugInfoSize(section6.getSize());
        dwarfInfoBean.setDebugInfoCompressed(this.isCompressed(section6.getFlags()));
        Section section7 = this.sectionTable.get(DEBUG_LINE_SECTION);
        if (null == section7) {
            Log.warn("No debug_line section in the file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugLineOffset(section7.getOffset());
        dwarfInfoBean.setDebugLineSize(section7.getSize());
        dwarfInfoBean.setDebugLineCompressed(this.isCompressed(section7.getFlags()));
        Section section8 = this.sectionTable.get(DEBUG_RANGES_SECTION);
        if (null != section8) {
            dwarfInfoBean.setDebugRangesOffset(section8.getOffset());
            dwarfInfoBean.setDebugRangesSize(section8.getSize());
            dwarfInfoBean.setDebugRangesCompressed(this.isCompressed(section8.getFlags()));
        }
        if (null == (section4 = this.sectionTable.get(DEBUG_STR_SECTION))) {
            Log.warn("No debug_str section in the file.", new Object[0]);
        } else {
            dwarfInfoBean.setDebugStrOffset(section4.getOffset());
            dwarfInfoBean.setDebugStrSize(section4.getSize());
            dwarfInfoBean.setDebugStrCompressed(this.isCompressed(section4.getFlags()));
        }
        Section section9 = this.sectionTable.get(DEBUG_PUBNAMES_SECTION);
        if (null == section9) {
            Log.warn("No %s section in the file.", DEBUG_PUBNAMES_SECTION);
        } else {
            dwarfInfoBean.setDebugPubnamesOffset(section9.getOffset());
            dwarfInfoBean.setDebugPubnamesSize(section9.getSize());
            dwarfInfoBean.setDebugPubnamesCompressed(this.isCompressed(section9.getFlags()));
        }
        Section section10 = this.sectionTable.get(DEBUG_STR_OFFSETS_SECTION);
        if (section10 != null) {
            dwarfInfoBean.setDebugStrOffsetsOffset(section10.getOffset());
            dwarfInfoBean.setDebugStrOffsetsSize(section10.getSize());
            dwarfInfoBean.setDebugStrOffsetCompressed(this.isCompressed(section10.getFlags()));
        }
        if ((section3 = this.sectionTable.get(DEBUG_LINE_STR_SECTION)) != null) {
            dwarfInfoBean.setDebugLineStrOffset(section3.getOffset());
            dwarfInfoBean.setDebugLineStrSize(section3.getSize());
            dwarfInfoBean.setDebugLineStrCompressed(this.isCompressed(section3.getFlags()));
        }
        if ((section2 = this.sectionTable.get(DEBUG_RNGLISTS_SECTION)) != null) {
            dwarfInfoBean.setDebugRngListOffset(section2.getOffset());
            dwarfInfoBean.setDebugRngListSize(section2.getSize());
            dwarfInfoBean.setDebugRngListCompressed(this.isCompressed(section2.getFlags()));
        }
        if ((section = this.sectionTable.get(DEBUG_ADDR_SECTION)) != null) {
            dwarfInfoBean.setDebugAddrOffset(section.getOffset());
            dwarfInfoBean.setDebugAddrSize(section.getSize());
            dwarfInfoBean.setDebugAddrCompressed(this.isCompressed(section.getFlags()));
        }
        return dwarfInfoBean;
    }

    private boolean isCompressed(int n) {
        return (n & 0x800) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseUuid() {
        this.parseBreakpadDebugId();
        if (this.sectionTable == null) {
            return false;
        }
        try (BinaryFileReader binaryFileReader = null;){
            binaryFileReader = new BinaryFileReader(this.fileName);
            byte[] byArray = new byte[16];
            byte[] byArray2 = null;
            Section section = this.sectionTable.get(GNU_BUILD_ID_SECTION);
            if (null == section) {
                Section section2 = this.sectionTable.get(TEXT_SECTION);
                if (section2 == null) {
                    boolean bl = false;
                    return bl;
                }
                long l = section2.getSize() <= 4096L ? section2.getSize() : 4096L;
                binaryFileReader.skip(section2.getOffset());
                int n = 0;
                while ((long)n < l) {
                    int n2 = 0;
                    while (n2 < 16) {
                        int n3 = n2++;
                        byArray[n3] = (byte)(byArray[n3] ^ binaryFileReader.readByte());
                    }
                    n += 16;
                }
            } else {
                binaryFileReader.skip(section.getOffset());
                long l = binaryFileReader.readUInt();
                long l2 = binaryFileReader.readUInt();
                long l3 = binaryFileReader.readUInt();
                if (3L != l3) {
                    Log.warn("GNU note type is not GNU_NOTE_TYPE_BUILD_ID(3).", new Object[0]);
                    boolean bl = false;
                    return bl;
                }
                long l4 = l + 3L & 0xFFFFFFFFFFFFFFFCL;
                binaryFileReader.skip(l4);
                if (this.needTruncate) {
                    byArray = new byte[(int)l2];
                } else if (l2 > 16L) {
                    binaryFileReader.skip(l2 - 16L);
                }
                if (!binaryFileReader.readByteArray(byArray)) {
                    boolean bl = false;
                    return bl;
                }
                if (l2 < 16L) {
                    Arrays.fill(byArray, (int)l2, 16, (byte)0);
                }
            }
            this.uuid = Utils.byteArrayToHexString(byArray);
            this.fullUuid = byArray2 == null ? this.uuid : Utils.byteArrayToHexString(byArray2);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseFullUuid() {
        this.parseBreakpadDebugId();
        if (this.sectionTable == null) {
            return false;
        }
        try (BinaryFileReader binaryFileReader = null;){
            binaryFileReader = new BinaryFileReader(this.fileName);
            byte[] byArray = null;
            Section section = this.sectionTable.get(GNU_BUILD_ID_SECTION);
            if (null == section) {
                byArray = new byte[16];
                Section section2 = this.sectionTable.get(TEXT_SECTION);
                if (section2 == null) {
                    boolean bl = false;
                    return bl;
                }
                long l = section2.getSize() <= 4096L ? section2.getSize() : 4096L;
                binaryFileReader.skip(section2.getOffset());
                int n = 0;
                while ((long)n < l) {
                    int n2 = 0;
                    while (n2 < 16) {
                        int n3 = n2++;
                        byArray[n3] = (byte)(byArray[n3] ^ binaryFileReader.readByte());
                    }
                    n += 16;
                }
            } else {
                binaryFileReader.skip(section.getOffset());
                long l = binaryFileReader.readUInt();
                long l2 = binaryFileReader.readUInt();
                long l3 = binaryFileReader.readUInt();
                byArray = l2 > 128L ? new byte[128] : new byte[(int)l2];
                if (3L != l3) {
                    Log.warn("GNU note type is not GNU_NOTE_TYPE_BUILD_ID(3).", new Object[0]);
                    boolean bl = false;
                    return bl;
                }
                long l4 = l + 3L & 0xFFFFFFFFFFFFFFFCL;
                binaryFileReader.skip(l4);
                if (l2 > 128L) {
                    binaryFileReader.skip(l2 - 128L);
                }
                if (!binaryFileReader.readByteArray(byArray)) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.fullUuid = Utils.byteArrayToHexString(byArray);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] findBuildId() {
        try (BinaryFileReader binaryFileReader = null;){
            binaryFileReader = new BinaryFileReader(this.fileName);
            Section section = this.sectionTable.get(GNU_BUILD_ID_SECTION);
            if (null != section) {
                binaryFileReader.skip(section.getOffset());
                long l = binaryFileReader.readUInt();
                long l2 = binaryFileReader.readUInt();
                long l3 = binaryFileReader.readUInt();
                if (3L != l3) {
                    Log.warn("GNU note type is not GNU_NOTE_TYPE_BUILD_ID(3).", new Object[0]);
                    byte[] byArray = null;
                    return byArray;
                }
                long l4 = l + 3L & 0xFFFFFFFFFFFFFFFCL;
                binaryFileReader.skip(l4);
                byte[] byArray = new byte[(int)l2];
                binaryFileReader.readByteArray(byArray);
                byte[] byArray2 = byArray;
                return byArray2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseBreakpadDebugId() {
        if (this.sectionTable == null) {
            return false;
        }
        byte[] byArray = this.findBuildId();
        if (byArray != null) {
            byte[] byArray2 = Arrays.copyOf(byArray, 16);
            if (this.endian == BinaryFileReader.LITTLE_ENDIAN) {
                Utils.reverseByteArray(byArray2, 0, 4);
                Utils.reverseByteArray(byArray2, 4, 6);
                Utils.reverseByteArray(byArray2, 6, 8);
            }
            this.breakpadDebugId = Utils.byteArrayToHexString(byArray2).toUpperCase(Locale.ROOT) + "0";
            return true;
        }
        try (BinaryFileReader binaryFileReader = null;){
            binaryFileReader = new BinaryFileReader(this.fileName);
            byte[] byArray3 = new byte[16];
            Section section = this.sectionTable.get(TEXT_SECTION);
            if (section == null) {
                boolean bl = false;
                return bl;
            }
            long l = section.getSize() <= 4096L ? section.getSize() : 4096L;
            binaryFileReader.skip(section.getOffset());
            int n = 0;
            while ((long)n < l) {
                int n2 = 0;
                while (n2 < 16) {
                    int n3 = n2++;
                    byArray3[n3] = (byte)(byArray3[n3] ^ binaryFileReader.readByte());
                }
                n += 16;
            }
            if (this.endian == BinaryFileReader.LITTLE_ENDIAN) {
                Utils.reverseByteArray(byArray3, 0, 4);
                Utils.reverseByteArray(byArray3, 4, 6);
                Utils.reverseByteArray(byArray3, 6, 8);
            }
            this.breakpadDebugId = Utils.byteArrayToHexString(byArray3).toUpperCase(Locale.ROOT) + "0";
            boolean bl = true;
            return bl;
        }
        return false;
    }

    public boolean parseBreakpadCodeId() {
        byte[] byArray = this.findBuildId();
        if (byArray == null) {
            return false;
        }
        this.breakpadCodeId = Utils.byteArrayToHexString(byArray).toUpperCase(Locale.ROOT);
        return true;
    }
}

