/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.dwarf.Augmentation;
import com.uqm.crashsight.symtabtool.dwarf.AugmentationData;
import com.uqm.crashsight.symtabtool.dwarf.BaseAddresses;
import com.uqm.crashsight.symtabtool.dwarf.CallFrameInstructionIter;
import com.uqm.crashsight.symtabtool.dwarf.CommonInformationEntry;
import com.uqm.crashsight.symtabtool.dwarf.DwEhPe;
import com.uqm.crashsight.symtabtool.dwarf.Format;
import com.uqm.crashsight.symtabtool.dwarf.Pointer;
import com.uqm.crashsight.symtabtool.dwarf.PointerEncodingParameters;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf.UninitializedUnwindContext;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSection;
import com.uqm.crashsight.symtabtool.dwarf.UnwindTable;
import com.uqm.crashsight.symtabtool.dwarf._UnwindSectionPrivate;
import java.util.Map;

class FrameDescriptionEntry {
    Long offset;
    Long length;
    Format format;
    CommonInformationEntry cie;
    Long initialSegment;
    Long initialAddress;
    Long addressRange;
    AugmentationData augmentation;
    Reader instructions;

    public FrameDescriptionEntry(Long l, Long l2, Format format, CommonInformationEntry commonInformationEntry, Long l3, Long l4, Long l5, AugmentationData augmentationData, Reader reader) {
        this.offset = l;
        this.length = l2;
        this.format = format;
        this.cie = commonInformationEntry;
        this.initialSegment = l3;
        this.initialAddress = l4;
        this.addressRange = l5;
        this.augmentation = augmentationData;
        this.instructions = reader;
    }

    public static FrameDescriptionEntry parseRest(Long l, Long l2, Format format, Long l3, Reader reader, _UnwindSectionPrivate _UnwindSectionPrivate2, BaseAddresses baseAddresses, Map<Long, CommonInformationEntry> map) {
        CommonInformationEntry commonInformationEntry = map.get(l3);
        if (commonInformationEntry == null) {
            return null;
        }
        long l4 = 0L;
        if (commonInformationEntry.segmentSize > 0) {
            l4 = reader.readAddress(commonInformationEntry.segmentSize);
        }
        PointerEncodingParameters pointerEncodingParameters = new PointerEncodingParameters(baseAddresses.ehFrame, null, commonInformationEntry.addressSize, _UnwindSectionPrivate2.section());
        Pair<Long, Long> pair = FrameDescriptionEntry.parseAddress(reader, commonInformationEntry, pointerEncodingParameters);
        long l5 = pair.getKey();
        long l6 = pair.getValue();
        AugmentationData augmentationData = null;
        if (commonInformationEntry.augmentation != null) {
            augmentationData = AugmentationData.parse(commonInformationEntry.augmentation, pointerEncodingParameters, reader);
        }
        return new FrameDescriptionEntry(l, l2, format, commonInformationEntry, l4, l5, l6, augmentationData, reader);
    }

    public static Pair<Long, Long> parseAddress(Reader reader, CommonInformationEntry commonInformationEntry, PointerEncodingParameters pointerEncodingParameters) {
        DwEhPe dwEhPe = null;
        if (commonInformationEntry.augmentation != null) {
            dwEhPe = commonInformationEntry.augmentation.fdeAddressEncoding;
        }
        if (dwEhPe != null) {
            Pointer pointer = Augmentation.parseEncodedPointer(dwEhPe, pointerEncodingParameters, reader);
            assert (pointer != null);
            long l = pointer.into();
            Pointer pointer2 = Augmentation.parseEncodedPointer(dwEhPe.format(), pointerEncodingParameters, reader);
            assert (pointer2 != null);
            long l2 = pointer2.into();
            return new Pair<Long, Long>(l, l2);
        }
        return new Pair<Long, Long>(reader.readAddress(commonInformationEntry.addressSize), reader.readAddress(commonInformationEntry.addressSize));
    }

    public CallFrameInstructionIter instructions(UnwindSection unwindSection, BaseAddresses baseAddresses) {
        DwEhPe dwEhPe = null;
        if (this.cie.augmentation != null) {
            dwEhPe = this.cie.augmentation.fdeAddressEncoding;
        }
        return new CallFrameInstructionIter(this.instructions, dwEhPe, new PointerEncodingParameters(baseAddresses.ehFrame, null, this.cie.addressSize, unwindSection.section()));
    }

    public UnwindTable rows(UnwindSection unwindSection, BaseAddresses baseAddresses, UninitializedUnwindContext uninitializedUnwindContext) {
        return UnwindTable._new(unwindSection, baseAddresses, uninitializedUnwindContext, this);
    }

    public long len() {
        return this.addressRange;
    }
}

