/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Section;
import com.uqm.crashsight.symtabtool.dwarf.Arch;
import com.uqm.crashsight.symtabtool.dwarf.Dwarf;
import com.uqm.crashsight.symtabtool.dwarf.DwarfSection;
import com.uqm.crashsight.symtabtool.dwarf.Elf;
import com.uqm.crashsight.symtabtool.dwarf.ObjectLike;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import com.uqm.crashsight.symtabtool.dwarf.RunTimeEndian;
import com.uqm.crashsight.symtabtool.elf.ElfHeaderParser;
import com.uqm.crashsight.symtabtool.elf.ElfParser;

class ElfObject
implements Dwarf,
ObjectLike {
    ElfHeaderParser elfHeaderParser;
    ElfParser elfParser;
    Elf elf;
    ParseBuffer data;

    public ElfObject(ElfHeaderParser elfHeaderParser, ElfParser elfParser) {
        this.elfHeaderParser = elfHeaderParser;
        this.elfParser = elfParser;
    }

    public DwarfSection findSection(String string) {
        Section section = this.elfParser.getSectionTable().get(string);
        if (section == null) {
            return null;
        }
        ParseBuffer parseBuffer = this.elfParser.getSectionData(section);
        return new DwarfSection(section.getAddress(), section.getOffset(), section.getAddrAlign(), parseBuffer);
    }

    @Override
    public Arch arch() {
        int n = (int)this.elfHeaderParser.getArch();
        switch (n) {
            case 3: {
                return Arch.X86;
            }
            case 62: {
                return Arch.Amd64;
            }
            case 183: {
                return Arch.Arm64;
            }
            case 40: {
                return Arch.Arm;
            }
            case 20: {
                return Arch.Ppc;
            }
            case 21: {
                return Arch.Ppc64;
            }
            case 10: {
                if ((this.elfHeaderParser.getProcessorSpecificFlags() & 0x6000L) != 0L) {
                    return Arch.Mips64;
                }
                return Arch.Mips;
            }
        }
        return Arch.Unknown;
    }

    @Override
    public long loadAddress() {
        return this.elfParser.getModuleBase();
    }

    @Override
    public RunTimeEndian endianity() {
        if (this.elfHeaderParser.getEndian() == 1L) {
            return RunTimeEndian.Little;
        }
        return RunTimeEndian.Big;
    }

    @Override
    public DwarfSection rawSection(String string) {
        return this.findSection(string);
    }
}

