/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.SectionReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.SectionParseBuffer;
import java.io.IOException;
import java.util.Vector;

public class DebugRangesParser {
    private static final long RESERVED_LOW_PC = 0L;
    private static final long RESERVED_HIGH_PC = 0L;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    private SectionReader binaryFileReader = null;
    private long addrBits = 0L;
    boolean isLittleEndian;
    SectionParseBuffer parseBuffer = null;

    public void setAddrBits(long l) {
        switch ((int)l) {
            case 4: 
            case 32: {
                this.addrBits = 32L;
                break;
            }
            case 8: 
            case 64: {
                this.addrBits = 64L;
                break;
            }
            default: {
                this.addrBits = 32L;
                Log.warn("Address bits error, default to 32", new Object[0]);
            }
        }
    }

    public DebugRangesParser(String string, long l, long l2, boolean bl) {
        this.fileName = string;
        this.sectionOffset = l;
        this.sectionSize = l2;
        this.isLittleEndian = bl;
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (this.binaryFileReader.isUseParseBuffer()) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (this.binaryFileReader != null && this.binaryFileReader.isUseParseBuffer()) {
            this.binaryFileReader.resetParseBuffer();
            return true;
        }
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new SectionReader(this.fileName, this.sectionOffset, this.sectionSize, this.isLittleEndian);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    public Vector<DebugRangeEntry> getRangesTable(long l) {
        if (l < 0L || l >= this.sectionSize) {
            return null;
        }
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(l)) {
            this.close();
            return null;
        }
        Vector<DebugRangeEntry> vector = this.parseRangesTable();
        this.close();
        return vector;
    }

    private Vector<DebugRangeEntry> parseRangesTable() {
        Vector<DebugRangeEntry> vector = new Vector<DebugRangeEntry>();
        long l = 0L;
        long l2 = 0L;
        try {
            while (true) {
                if (32L == this.addrBits) {
                    l = this.binaryFileReader.readUInt();
                    l2 = this.binaryFileReader.readUInt();
                } else if (64L == this.addrBits) {
                    l = this.binaryFileReader.readULong();
                    l2 = this.binaryFileReader.readULong();
                } else {
                    Log.warn("Address bits error", new Object[0]);
                    return null;
                }
                if (0L != l || 0L != l2) {
                    DebugRangeEntry debugRangeEntry = new DebugRangeEntry();
                    debugRangeEntry.setLowPc(l);
                    debugRangeEntry.setHighPc(l2);
                    vector.add(debugRangeEntry);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return vector;
    }

    private Vector<DebugRangeEntry> parseRangesTableFromBuffer(long l) {
        this.parseBuffer.pos(l);
        Vector<DebugRangeEntry> vector = new Vector<DebugRangeEntry>();
        long l2 = 0L;
        long l3 = 0L;
        while (true) {
            if (32L == this.addrBits) {
                l2 = this.parseBuffer.readU32();
                l3 = this.parseBuffer.readU32();
            } else if (64L == this.addrBits) {
                l2 = this.parseBuffer.readI64();
                l3 = this.parseBuffer.readI64();
            } else {
                Log.warn("Address bits error", new Object[0]);
                return null;
            }
            if (0L == l2 && 0L == l3) break;
            DebugRangeEntry debugRangeEntry = new DebugRangeEntry();
            debugRangeEntry.setLowPc(l2);
            debugRangeEntry.setHighPc(l3);
            vector.add(debugRangeEntry);
        }
        return vector;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public SectionReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public long getAddrBits() {
        return this.addrBits;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public SectionParseBuffer getParseBuffer() {
        return this.parseBuffer;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setBinaryFileReader(SectionReader sectionReader) {
        this.binaryFileReader = sectionReader;
    }

    public void setLittleEndian(boolean bl) {
        this.isLittleEndian = bl;
    }

    public void setParseBuffer(SectionParseBuffer sectionParseBuffer) {
        this.parseBuffer = sectionParseBuffer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DebugRangesParser)) {
            return false;
        }
        DebugRangesParser debugRangesParser = (DebugRangesParser)object;
        if (!debugRangesParser.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != debugRangesParser.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != debugRangesParser.getSectionSize()) {
            return false;
        }
        if (this.getAddrBits() != debugRangesParser.getAddrBits()) {
            return false;
        }
        if (this.isLittleEndian() != debugRangesParser.isLittleEndian()) {
            return false;
        }
        String string = this.getFileName();
        String string2 = debugRangesParser.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        SectionReader sectionReader = this.getBinaryFileReader();
        SectionReader sectionReader2 = debugRangesParser.getBinaryFileReader();
        if (sectionReader == null ? sectionReader2 != null : !((Object)sectionReader).equals(sectionReader2)) {
            return false;
        }
        SectionParseBuffer sectionParseBuffer = this.getParseBuffer();
        SectionParseBuffer sectionParseBuffer2 = debugRangesParser.getParseBuffer();
        return !(sectionParseBuffer == null ? sectionParseBuffer2 != null : !((Object)sectionParseBuffer).equals(sectionParseBuffer2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DebugRangesParser;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getSectionSize();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getAddrBits();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        n2 = n2 * 59 + (this.isLittleEndian() ? 79 : 97);
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        SectionReader sectionReader = this.getBinaryFileReader();
        n2 = n2 * 59 + (sectionReader == null ? 43 : ((Object)sectionReader).hashCode());
        SectionParseBuffer sectionParseBuffer = this.getParseBuffer();
        n2 = n2 * 59 + (sectionParseBuffer == null ? 43 : ((Object)sectionParseBuffer).hashCode());
        return n2;
    }

    public String toString() {
        return "DebugRangesParser(fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", binaryFileReader=" + this.getBinaryFileReader() + ", addrBits=" + this.getAddrBits() + ", isLittleEndian=" + this.isLittleEndian() + ", parseBuffer=" + this.getParseBuffer() + ")";
    }

    public static class DebugRangeEntry {
        private long lowPc = -1L;
        private long highPc = -1L;

        public void setLowPc(long l) {
            this.lowPc = l;
        }

        public void setHighPc(long l) {
            this.highPc = l;
        }

        public long getLowPc() {
            return this.lowPc;
        }

        public long getHighPc() {
            return this.highPc;
        }
    }
}

