/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.file.SectionReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.DebugAbbrevParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugPubnamesParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugStrOffsetsParser;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class DebugInfoPasrser {
    public static final long DW_TAG_COMPILE_UNIT = 17L;
    public static final long DW_TAG_SUBPROGRAM = 46L;
    public static final long DW_TAG_INLINED_SUBROUTINE = 29L;
    public static final long DW_TAG_PARTIAL_UNIT = 46L;
    public static final long DW_TAG_formal_parameter = 5L;
    public static final long DW_TAG_variable = 52L;
    public static final long DW_TAG_label = 10L;
    public static final long DW_AT_MIPS_LINKAGE_NAME = 8199L;
    public static final long DW_AT_LINKAGE_NAME = 110L;
    public static final long DW_AT_NAME = 3L;
    public static final long DW_AT_STMT_LIST = 16L;
    public static final long DW_AT_LOW_PC = 17L;
    public static final long DW_AT_HIGH_PC = 18L;
    public static final long DW_AT_language = 19L;
    public static final long DW_AT_ABSTRACT_ORIGIN = 49L;
    public static final long DW_AT_SPECIFICATION = 71L;
    public static final long DW_AT_ENTRY_PC = 82L;
    public static final long DW_AT_RANGES = 85L;
    public static final long DW_AT_CALL_FILE = 88L;
    public static final long DW_AT_CALL_LINE = 89L;
    public static final long DW_AT_SLIBLING = 1L;
    public static final long DW_AT_location = 2L;
    public static final long DW_AT_byte_size = 11L;
    public static final long DW_AT_type = 73L;
    public static final long DW_AT_com_dir = 27L;
    public static final long DW_AT_str_offsets_base = 114L;
    public static final long DW_AT_addr_base = 115L;
    public static final long DW_AT_rnglists_base = 116L;
    public static final String DW_AT_location_prefix = "block_";
    public static final int DW_OP_addr = 3;
    public static final int DW_OP_deref = 6;
    public static final int DW_OP_const1u = 8;
    public static final int DW_OP_const1s = 9;
    public static final int DW_OP_const2u = 10;
    public static final int DW_OP_const2s = 11;
    public static final int DW_OP_const4u = 12;
    public static final int DW_OP_const4s = 13;
    public static final int DW_OP_const8u = 14;
    public static final int DW_OP_const8s = 15;
    public static final int DW_OP_constu = 16;
    public static final int DW_OP_consts = 17;
    public static final int DW_OP_dup = 18;
    public static final int DW_OP_drop = 19;
    public static final int DW_OP_over = 20;
    public static final int DW_OP_pick = 21;
    public static final int DW_OP_swap = 22;
    public static final int DW_OP_rot = 23;
    public static final int DW_OP_xderef = 24;
    public static final int DW_OP_abs = 25;
    public static final int DW_OP_and = 26;
    public static final int DW_OP_div = 27;
    public static final int DW_OP_minus = 28;
    public static final int DW_OP_mod = 29;
    public static final int DW_OP_mul = 30;
    public static final int DW_OP_neg = 31;
    public static final int DW_OP_not = 32;
    public static final int DW_OP_or = 33;
    public static final int DW_OP_plus = 34;
    public static final int DW_OP_plus_uconst = 35;
    public static final int DW_OP_shl = 36;
    public static final int DW_OP_shr = 37;
    public static final int DW_OP_shra = 38;
    public static final int DW_OP_xor = 39;
    public static final int DW_OP_skip = 47;
    public static final int DW_OP_bra = 40;
    public static final int DW_OP_eq = 41;
    public static final int DW_OP_ge = 42;
    public static final int DW_OP_gt = 43;
    public static final int DW_OP_le = 44;
    public static final int DW_OP_lt = 45;
    public static final int DW_OP_ne = 46;
    public static final int DW_OP_lit0 = 48;
    public static final int DW_OP_lit1 = 49;
    public static final int DW_OP_lit31 = 79;
    public static final int DW_OP_reg0 = 80;
    public static final int DW_OP_reg1 = 81;
    public static final int DW_OP_reg31 = 111;
    public static final int DW_OP_breg0 = 112;
    public static final int DW_OP_breg1 = 113;
    public static final int DW_OP_breg31 = 143;
    public static final int DW_OP_regx = 144;
    public static final int DW_OP_fbreg = 145;
    public static final int DW_OP_bregx = 146;
    public static final int DW_OP_piece = 147;
    public static final int DW_OP_deref_size = 148;
    public static final int DW_OP_xderef_size = 149;
    public static final int DW_OP_nop = 150;
    public static final int DW_OP_push_object_address = 151;
    public static final int DW_OP_call2 = 152;
    public static final int DW_OP_call4 = 153;
    public static final int DW_OP_call_ref = 154;
    public static final int DW_OP_from_tls_address = 155;
    public static final int DW_OP_tls_cfa = 156;
    public static final int DW_OP_bit_piece = 157;
    public static final int DW_OP_implicit_value = 158;
    public static final int DW_OP_stack_value = 159;
    public static final int DW_OP_lo_user = 224;
    public static final int DW_OP_hi_user = 155;
    public static final long RESERVED_ABBREV_CODE = 0L;
    private static final long DW_CHILDREN_NO = 0L;
    private static final long DW_CHILDREN_YES = 1L;
    public static final byte DW_FORM_ADDR = 1;
    private static final byte DW_FORM_BLOCK2 = 3;
    private static final byte DW_FORM_BLOCK4 = 4;
    private static final byte DW_FORM_DATA2 = 5;
    private static final byte DW_FORM_DATA4 = 6;
    private static final byte DW_FORM_DATA8 = 7;
    public static final byte DW_FORM_STRING = 8;
    private static final byte DW_FORM_BLOCK = 9;
    private static final byte DW_FORM_BLOCK1 = 10;
    private static final byte DW_FORM_DATA1 = 11;
    private static final byte DW_FORM_FLAG = 12;
    private static final byte DW_FORM_SDATA = 13;
    public static final byte DW_FORM_STRP = 14;
    private static final byte DW_FORM_UDATA = 15;
    public static final byte DW_FORM_REF_ADDR = 16;
    private static final byte DW_FORM_REF1 = 17;
    private static final byte DW_FORM_REF2 = 18;
    private static final byte DW_FORM_REF4 = 19;
    private static final byte DW_FORM_REF8 = 20;
    private static final byte DW_FORM_REF_UDATA = 21;
    private static final byte DW_FORM_INDIRECT = 22;
    public static final byte DW_FORM_SEC_OFFSET = 23;
    private static final byte DW_FORM_EXPRLOC = 24;
    private static final byte DW_FORM_FLAG_PRESENT = 25;
    public static final byte DW_FORM_REF_SIG8 = 32;
    public static final byte DW_FORM_STRX = 26;
    public static final byte DW_FORM_ADDRX = 27;
    private static final byte DW_FORM_REF_SUP4 = 28;
    private static final byte DW_FORM_STRP_SUP = 29;
    private static final byte DW_FORM_DATA16 = 30;
    public static final byte DW_FORM_LINE_STRP = 31;
    public static final byte DW_FORM_IMPLICIT_CONST = 33;
    private static final byte DW_FORM_LOCLISTX = 34;
    public static final byte DW_FORM_RNGLISTX = 35;
    private static final byte DW_FORM_REF_SUP8 = 36;
    public static final byte DW_FORM_STRX1 = 37;
    public static final byte DW_FORM_STRX2 = 38;
    public static final byte DW_FORM_STRX3 = 39;
    public static final byte DW_FORM_STRX4 = 40;
    public static final byte DW_FORM_ADDRX1 = 41;
    public static final byte DW_FORM_ADDRX2 = 42;
    public static final byte DW_FORM_ADDRX3 = 43;
    public static final byte DW_FORM_ADDRX4 = 44;
    public static final int DW_LANG_C89 = 1;
    public static final int DW_LANG_C = 2;
    public static final int DW_LANG_Ada83 = 3;
    public static final int DW_LANG_C_plus_plus = 4;
    public static final int DW_LANG_Cobol74 = 5;
    public static final int DW_LANG_Cobol85 = 6;
    public static final int DW_LANG_Fortran77 = 7;
    public static final int DW_LANG_Fortran90 = 8;
    public static final int DW_LANG_Pascal83 = 9;
    public static final int DW_LANG_Modula2 = 10;
    public static final int DW_LANG_Java = 11;
    public static final int DW_LANG_C99 = 12;
    public static final int DW_LANG_Ada95 = 13;
    public static final int DW_LANG_Fortran95 = 14;
    public static final int DW_LANG_PLI = 15;
    public static final int DW_LANG_ObjC = 16;
    public static final int DW_LANG_ObjC_plus_plus = 17;
    public static final int DW_LANG_UPC = 18;
    public static final int DW_LANG_D = 19;
    public static final int DW_LANG_Python = 20;
    public static final int DW_LANG_Go = 22;
    public static final int DW_LANG_C_plus_plus_03 = 25;
    public static final int DW_LANG_C_plus_plus_11 = 26;
    public static final int DW_LANG_Rust = 28;
    public static final int DW_LANG_C11 = 29;
    public static final int DW_LANG_C_plus_plus_14 = 33;
    public static final int DW_LANG_Fortran03 = 34;
    public static final int DW_LANG_Fortran08 = 35;
    public static final int DW_LANG_C_plus_plus_17 = 42;
    public static final int DW_LANG_C_plus_plus_20 = 43;
    public static final int DW_LANG_C17 = 44;
    public static final int DW_LANG_Fortran18 = 45;
    public static final int DW_LANG_Ada2005 = 46;
    public static final int DW_LANG_Ada2012 = 47;
    public static final int DW_LANG_HIP = 48;
    public static final int DW_LANG_Assembly = 49;
    public static final int DW_LANG_C_sharp = 50;
    public static final int DW_LANG_Mojo = 51;
    public static final int DW_LANG_GLSL = 52;
    public static final int DW_LANG_GLSL_ES = 53;
    public static final int DW_LANG_HLSL = 54;
    public static final int DW_LANG_OpenCL_CPP = 55;
    public static final int DW_LANG_CPP_for_OpenCL = 56;
    public static final int DW_LANG_SYCL = 57;
    public static final int DW_LANG_C_plus_plus_23 = 58;
    public static final int DW_LANG_Odin = 59;
    public static final int DW_LANG_P4 = 60;
    public static final int DW_LANG_Metal = 61;
    public static final int DW_LANG_C23 = 62;
    public static final int DW_LANG_Fortran23 = 63;
    public static final int DW_LANG_Ruby = 64;
    public static final int DW_LANG_Move = 65;
    public static final int DW_LANG_Hylo = 66;
    public static final int DW_LANG_lo_user = 32768;
    public static final int DW_LANG_hi_user = 65535;
    public static final int DW_LANG_Mips_Assembler = 32769;
    public static final int DW_LANG_Upc = 34661;
    public static final int DW_LANG_HP_Bliss = 32771;
    public static final int DW_LANG_HP_Basic91 = 32772;
    public static final int DW_LANG_HP_Pascal91 = 32773;
    public static final int DW_LANG_HP_IMacro = 32774;
    public static final int DW_LANG_HP_Assembler = 32775;
    public static final int DW_LANG_Rust_old = 36864;
    public static final int DMGL_JAVA = 4;
    public static final int DMGL_AUTO = 256;
    public static final int DMGL_GNU_V3 = 16384;
    public static final int DMGL_GNAT = 32768;
    public static final int DMGL_DLANG = 65536;
    public static final int DMGL_RUST = 131072;
    private static final long[] parse_context = new long[]{17L, 46L, 29L, 46L};
    public static long countInx = 0L;
    public long sectionOffset = 0L;
    boolean isCompressed;
    boolean is32bitElf;
    boolean isLittleEndian;
    public LinkedHashMap<Long, Long> dieParentMap = null;
    public long cuOffsetInSection = 0L;
    Map<Long, Long> m = new HashMap<Long, Long>();
    private String fileName = null;
    private long sectionSize = 0L;
    private long addrBits = 0L;
    private long dwarfFormat = 0L;
    public SectionReader binaryFileReader = null;
    public CompilationUnitHeader header = null;
    public LinkedHashMap<Long, DebugInfoEntry> debugInfoTable = null;
    public DebugInfoEntry cu = null;
    public String cuDir = null;
    private Stack<Long> dieParentStack = null;
    private long cuDieOffset = 0L;
    private long timeCost = 0L;
    public Vector<Long> cuOffsetInSections = new Vector();
    List<CompilationUnitHeader> cuHeaders;
    DebugStrOffsetsParser debugStrOffsetsParser;
    DebugPubnamesParser debugPubnamesParser;

    public DebugInfoPasrser(String string, long l, long l2, boolean bl, boolean bl2, boolean bl3) {
        this.fileName = string;
        this.sectionOffset = l;
        this.sectionSize = l2;
        this.isCompressed = bl;
        this.is32bitElf = bl2;
        this.isLittleEndian = bl3;
    }

    public DebugInfoPasrser copy() throws Exception {
        DebugInfoPasrser debugInfoPasrser = new DebugInfoPasrser(this.fileName, this.sectionOffset, this.sectionSize, this.isCompressed, this.is32bitElf, this.isLittleEndian);
        debugInfoPasrser.cuHeaders = this.cuHeaders;
        debugInfoPasrser.debugStrOffsetsParser = this.debugStrOffsetsParser;
        debugInfoPasrser.debugPubnamesParser = this.debugPubnamesParser;
        debugInfoPasrser.debugInfoTable = this.debugInfoTable;
        debugInfoPasrser.binaryFileReader = this.binaryFileReader != null && this.binaryFileReader.isUseParseBuffer() ? this.binaryFileReader : null;
        return debugInfoPasrser;
    }

    public boolean setAddrBits(long l) {
        switch ((int)l) {
            case 4: 
            case 32: {
                this.addrBits = 32L;
                break;
            }
            case 8: 
            case 64: {
                this.addrBits = 64L;
                break;
            }
            default: {
                Log.warn("Address bits error: %d", l);
                return false;
            }
        }
        return true;
    }

    public boolean setDwarfFormat(long l) {
        switch ((int)l) {
            case 4: 
            case 32: {
                this.dwarfFormat = 32L;
                break;
            }
            case 8: 
            case 64: {
                this.dwarfFormat = 64L;
                break;
            }
            default: {
                Log.error("File format error: %d", l);
                return false;
            }
        }
        return true;
    }

    private void clearEnv() {
        this.header = null;
        this.debugInfoTable = null;
        this.dieParentMap = null;
        this.cuDir = null;
        this.cu = null;
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (this.binaryFileReader.isUseParseBuffer()) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            Log.error("Failed to close file: %s", this.fileName);
            return;
        }
        this.binaryFileReader = null;
    }

    public boolean openFile() {
        if (this.binaryFileReader != null && this.binaryFileReader.isUseParseBuffer()) {
            this.binaryFileReader.resetParseBuffer();
            return true;
        }
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new SectionReader(this.fileName, this.sectionOffset, this.sectionSize, this.isLittleEndian);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    public SectionReader.Context getParseBufferContext() {
        if (null == this.binaryFileReader) {
            return null;
        }
        return this.binaryFileReader.getParseBufferContext();
    }

    public void loadParseBufferContext(SectionReader.Context context) {
        if (null == this.binaryFileReader) {
            return;
        }
        this.binaryFileReader.loadParseBufferContext(context);
    }

    private long getOffsetInCompilationUnit() {
        return this.binaryFileReader.getOffset() - this.cuOffsetInSection;
    }

    public long getOffsetInDebugInfo() {
        return this.binaryFileReader.getOffset();
    }

    public long getSectionRestLength() {
        if (this.binaryFileReader.isUseParseBuffer()) {
            return this.binaryFileReader.getParseBuffer().len();
        }
        long l = this.binaryFileReader.getOffset();
        return this.sectionSize - l;
    }

    private long getUnitRestLength() {
        return this.header.getUnitLength() - this.binaryFileReader.getReadBytesNum();
    }

    public LinkedHashMap<Long, DebugInfoEntry> getDebugInfoTable(DebugAbbrevParser debugAbbrevParser, long l) {
        if (l < 0L || l >= this.sectionSize) {
            return null;
        }
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(l)) {
            this.close();
            return null;
        }
        return this.next(debugAbbrevParser);
    }

    public LinkedHashMap<Long, DebugInfoEntry> next(DebugAbbrevParser debugAbbrevParser) {
        long l = System.currentTimeMillis();
        if (null == this.binaryFileReader && !this.openFile()) {
            return null;
        }
        if (this.getSectionRestLength() <= 0L) {
            return null;
        }
        this.clearEnv();
        this.cuOffsetInSection = this.binaryFileReader.getOffset();
        this.cuOffsetInSections.add(this.cuOffsetInSection);
        this.debugInfoTable = new LinkedHashMap();
        this.cu = null;
        this.dieParentStack = new Stack();
        this.dieParentMap = new LinkedHashMap();
        this.header = new CompilationUnitHeader(this.binaryFileReader);
        if (!this.header.parse()) {
            return null;
        }
        if (!this.setDwarfFormat(this.header.getDwarfFormat())) {
            return null;
        }
        if (!this.setAddrBits(this.header.getAddressSize())) {
            return null;
        }
        if (!this.parseDebugInfoTable(debugAbbrevParser)) {
            Log.error("Failed to parse debug info table", new Object[0]);
            return null;
        }
        this.timeCost += System.currentTimeMillis() - l;
        return this.debugInfoTable;
    }

    public List<CompilationUnitHeader> findAllCuHeader() {
        CompilationUnitHeader compilationUnitHeader;
        long l = System.currentTimeMillis();
        ArrayList<CompilationUnitHeader> arrayList = new ArrayList<CompilationUnitHeader>();
        if (!this.openFile()) {
            this.close();
            return null;
        }
        while (this.getSectionRestLength() > 0L && (compilationUnitHeader = new CompilationUnitHeader(this.binaryFileReader)).parse()) {
            arrayList.add(compilationUnitHeader);
            this.binaryFileReader.skip(compilationUnitHeader.nextOffsetInSection - this.binaryFileReader.getOffset());
        }
        this.close();
        Log.info("findAllCuHeader cost " + (System.currentTimeMillis() - l), new Object[0]);
        return arrayList;
    }

    private boolean parseDebugInfoTable(DebugAbbrevParser debugAbbrevParser) {
        this.cuDieOffset = this.getOffsetInCompilationUnit();
        long l = this.header.getDebugAbbrevOffset();
        HashMap<Long, DebugAbbrevParser.DebugAbbrevEntry> hashMap = debugAbbrevParser.getAbbrevTable(l);
        int n = 0;
        this.dieParentStack.push(0L);
        DebugInfoEntry debugInfoEntry = null;
        try {
            while (this.getUnitRestLength() > 0L) {
                long l2 = this.getOffsetInCompilationUnit();
                long l3 = this.getOffsetInDebugInfo();
                long l4 = 0L;
                l4 = this.binaryFileReader.parseULeb128();
                if (0L == l4) {
                    if (--n < 0) continue;
                    this.dieParentStack.pop();
                    continue;
                }
                this.dieParentMap.put(l2, this.dieParentStack.peek());
                DebugAbbrevParser.DebugAbbrevEntry debugAbbrevEntry = hashMap.get(l4);
                if (null == debugAbbrevEntry) {
                    Log.error("Failed to get abbrev entry, abbrev code\uff1a%d", l4);
                    return false;
                }
                DebugInfoEntry debugInfoEntry2 = this.parseDebugInfoEntry(debugAbbrevEntry);
                if (null == debugInfoEntry2) {
                    Log.error("Failed to parse debug info entry", new Object[0]);
                    return false;
                }
                debugInfoEntry2.setLevel(n);
                debugInfoEntry2.setParent(this.debugInfoTable.getOrDefault(this.dieParentStack.peek(), null));
                debugInfoEntry2.offsetInCu = l2;
                debugInfoEntry2.offsetInSection = l3;
                if (debugInfoEntry2.getTag() == 17L) {
                    debugInfoEntry = debugInfoEntry2;
                    this.cu = debugInfoEntry2;
                } else {
                    debugInfoEntry2.setCompileUnit(debugInfoEntry);
                }
                if (1L == (long)debugAbbrevEntry.getHasChild()) {
                    ++n;
                    this.dieParentStack.push(l2);
                }
                this.debugInfoTable.put(l2, debugInfoEntry2);
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
        return true;
    }

    public DebugInfoEntry parseDebugInfoEntry(DebugAbbrevParser.DebugAbbrevEntry debugAbbrevEntry) {
        DebugInfoEntry debugInfoEntry = new DebugInfoEntry();
        debugInfoEntry.setTag(debugAbbrevEntry.getTag());
        Vector<DebugAbbrevParser.DebugAbbrevAttribute> vector = debugAbbrevEntry.getAttributeTable();
        for (DebugAbbrevParser.DebugAbbrevAttribute debugAbbrevAttribute : vector) {
            String string = this.parseAttribute(debugAbbrevAttribute);
            if (null == string) {
                Log.error("Fail to parse attribute of debug info entry", new Object[0]);
                return null;
            }
            if (string.isEmpty()) continue;
            debugInfoEntry.addAttribute(debugAbbrevAttribute.getAttribute(), string);
            debugInfoEntry.addAttributeForm(debugAbbrevAttribute.getAttribute(), debugAbbrevAttribute.getForm());
        }
        return debugInfoEntry;
    }

    private String parseAddress() {
        long l;
        block4: {
            l = 0L;
            try {
                if (32L == this.addrBits) {
                    l = this.binaryFileReader.readUInt();
                    break block4;
                }
                if (64L == this.addrBits) {
                    l = this.binaryFileReader.readULong();
                    break block4;
                }
                Log.error("Address bits error", new Object[0]);
                return null;
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
        }
        return Long.toHexString(l);
    }

    private String parseBlock(long l) {
        long l2 = 0L;
        try {
            switch ((int)l) {
                case 10: {
                    l2 = this.binaryFileReader.readUByte();
                    break;
                }
                case 3: {
                    l2 = this.binaryFileReader.readUShort();
                    break;
                }
                case 4: {
                    l2 = this.binaryFileReader.readUInt();
                    break;
                }
                case 9: 
                case 24: {
                    l2 = this.binaryFileReader.parseULeb128();
                    break;
                }
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        byte[] byArray = new byte[(int)l2];
        if (!this.binaryFileReader.readByteArray(byArray)) {
            return null;
        }
        return DW_AT_location_prefix + Base64.getEncoder().encodeToString(byArray);
    }

    private String parseConstant(long l) {
        long l2 = 0L;
        try {
            switch ((int)l) {
                case 11: 
                case 37: {
                    l2 = this.binaryFileReader.readUByte();
                    break;
                }
                case 5: 
                case 38: {
                    l2 = this.binaryFileReader.readUShort();
                    break;
                }
                case 6: 
                case 40: {
                    l2 = this.binaryFileReader.readUInt();
                    break;
                }
                case 7: {
                    l2 = this.binaryFileReader.readULong();
                    break;
                }
                case 13: {
                    l2 = this.binaryFileReader.parseSLeb128();
                    break;
                }
                case 15: 
                case 26: {
                    l2 = this.binaryFileReader.parseULeb128();
                    break;
                }
                case 30: {
                    byte[] byArray = new byte[16];
                    this.binaryFileReader.readByteArray(byArray);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return Long.toHexString(l2);
    }

    private String parseString() {
        StringBuilder stringBuilder = new StringBuilder();
        byte by = 0;
        try {
            while (0 != (by = this.binaryFileReader.readByte())) {
                stringBuilder.append((char)by);
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return stringBuilder.toString();
    }

    private String parseStringPointer() {
        long l = 0L;
        try {
            if (32L == this.dwarfFormat) {
                l = this.binaryFileReader.readUInt();
            } else if (64L == this.dwarfFormat) {
                l = this.binaryFileReader.readULong();
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return Long.toHexString(l);
    }

    private String parseFlag() {
        long l = 0L;
        try {
            l = this.binaryFileReader.readUByte();
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return Long.toHexString(l);
    }

    private String parseReference(long l) {
        long l2 = 0L;
        try {
            switch ((int)l) {
                case 17: {
                    l2 = this.binaryFileReader.readUByte();
                    break;
                }
                case 18: {
                    l2 = this.binaryFileReader.readUShort();
                    break;
                }
                case 19: 
                case 28: {
                    l2 = this.binaryFileReader.readUInt();
                    break;
                }
                case 20: 
                case 32: 
                case 36: {
                    l2 = this.binaryFileReader.readULong();
                    break;
                }
                case 21: {
                    l2 = this.binaryFileReader.parseULeb128();
                    break;
                }
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return Long.toHexString(l2);
    }

    private String parseSectionOffset() {
        long l = 0L;
        try {
            if (32L == this.dwarfFormat) {
                l = this.binaryFileReader.readUInt();
            } else if (64L == this.dwarfFormat) {
                l = this.binaryFileReader.readULong();
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return Long.toHexString(l);
    }

    private String parseDebugStrOffset(long l) {
        long l2 = 0L;
        try {
            switch ((int)l) {
                case 37: {
                    l2 = this.binaryFileReader.readUByte();
                    break;
                }
                case 38: {
                    l2 = this.binaryFileReader.readUShort();
                    break;
                }
                case 39: {
                    byte[] byArray = new byte[3];
                    this.binaryFileReader.readByteArray(byArray);
                    break;
                }
                case 40: {
                    l2 = this.binaryFileReader.readUInt();
                    break;
                }
                case 26: {
                    l2 = this.binaryFileReader.parseULeb128();
                    break;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return Long.toHexString(l2);
    }

    private String parseDebugAddrOffset(long l) {
        long l2 = 0L;
        try {
            switch ((int)l) {
                case 41: {
                    l2 = this.binaryFileReader.readUByte();
                    break;
                }
                case 42: {
                    l2 = this.binaryFileReader.readUShort();
                    break;
                }
                case 43: {
                    byte[] byArray = new byte[3];
                    this.binaryFileReader.readByteArray(byArray);
                    break;
                }
                case 44: {
                    l2 = this.binaryFileReader.readUInt();
                    break;
                }
                case 27: {
                    l2 = this.binaryFileReader.parseULeb128();
                    break;
                }
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return Long.toHexString(l2);
    }

    private String parseLoclist(long l) {
        long l2 = 0L;
        try {
            switch ((int)l) {
                case 34: {
                    l2 = this.binaryFileReader.parseULeb128();
                    break;
                }
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return Long.toHexString(l2);
    }

    private String parseRnglist(long l) {
        long l2 = 0L;
        try {
            switch ((int)l) {
                case 35: {
                    l2 = this.binaryFileReader.parseULeb128();
                    break;
                }
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return Long.toHexString(l2);
    }

    private String parseIndirect() {
        long l = 0L;
        try {
            l = this.binaryFileReader.parseULeb128();
            return this.parseForm2((int)l);
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
    }

    private String parseReferenceAddress() {
        long l;
        block7: {
            l = 0L;
            try {
                if (2L == this.header.getVersion()) {
                    if (32L == this.addrBits) {
                        l = this.binaryFileReader.readUInt();
                        break block7;
                    }
                    if (64L == this.addrBits) {
                        l = this.binaryFileReader.readULong();
                        break block7;
                    }
                    Log.error("Address bits error", new Object[0]);
                    return null;
                }
                if (32L == this.dwarfFormat) {
                    l = this.binaryFileReader.readUInt();
                    break block7;
                }
                if (64L == this.dwarfFormat) {
                    l = this.binaryFileReader.readULong();
                    break block7;
                }
                Log.warn("Debug_info \u5730\u5740\u4f4d\u6570\uff08%d\u4f4d\uff09\u9519\u8bef", this.addrBits);
                return null;
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
        }
        return Long.toHexString(l);
    }

    private String parseAttribute(DebugAbbrevParser.DebugAbbrevAttribute debugAbbrevAttribute) {
        long l = debugAbbrevAttribute.getForm();
        String string = null;
        switch ((int)l) {
            case 1: {
                string = this.parseAddress();
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 24: {
                string = this.parseBlock(l);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 30: {
                string = this.parseConstant(l);
                break;
            }
            case 8: {
                string = this.parseString();
                break;
            }
            case 14: 
            case 29: 
            case 31: {
                string = this.parseStringPointer();
                break;
            }
            case 12: {
                string = this.parseFlag();
                break;
            }
            case 25: {
                string = new String();
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 32: 
            case 36: {
                string = this.parseReference(l);
                break;
            }
            case 16: {
                string = this.parseReferenceAddress();
                break;
            }
            case 22: {
                string = this.parseIndirect();
                break;
            }
            case 23: {
                string = this.parseSectionOffset();
                break;
            }
            case 26: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string = this.parseDebugStrOffset(l);
                break;
            }
            case 27: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                string = this.parseDebugAddrOffset(l);
                break;
            }
            case 33: {
                string = "";
                break;
            }
            case 34: {
                string = this.parseLoclist(l);
                break;
            }
            case 35: {
                string = this.parseRnglist(l);
                break;
            }
            default: {
                Log.error("Form of attribute value error\uff1a0x%x", l);
                return null;
            }
        }
        if (debugAbbrevAttribute.getAttribute() == 2L && string != null && string.equals("0") && !this.m.containsKey(l)) {
            Log.error("DW_AT_location Form:" + debugAbbrevAttribute.getForm(), new Object[0]);
            this.m.put(l, 1L);
        }
        return string;
    }

    private String parseForm2(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = this.parseAddress();
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 24: {
                string = this.parseBlock(n);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 30: {
                string = this.parseConstant(n);
                break;
            }
            case 8: {
                string = this.parseString();
                break;
            }
            case 14: 
            case 29: 
            case 31: {
                string = this.parseStringPointer();
                break;
            }
            case 12: {
                string = this.parseFlag();
                break;
            }
            case 25: {
                string = new String();
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 32: 
            case 36: {
                string = this.parseReference(n);
                break;
            }
            case 16: {
                string = this.parseReferenceAddress();
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                string = this.parseSectionOffset();
                break;
            }
            case 26: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string = this.parseDebugStrOffset(n);
                break;
            }
            case 27: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                string = this.parseDebugAddrOffset(n);
                break;
            }
            case 33: {
                string = "";
                break;
            }
            case 34: {
                string = this.parseLoclist(n);
                break;
            }
            case 35: {
                string = this.parseRnglist(n);
                break;
            }
            default: {
                Log.error("Form of attribute value error\uff1a0x%x", n);
                return null;
            }
        }
        return string;
    }

    public String parseLocation(byte[] byArray) {
        String string = "";
        ParseBuffer parseBuffer = new ParseBuffer(byArray, ByteOrder.LITTLE_ENDIAN);
        short s2 = parseBuffer.readU8();
        if (s2 >= 80 && s2 <= 111) {
            string = "DW_OP_reg" + (s2 - 80);
            return string;
        }
        if (s2 >= 112 && s2 <= 143) {
            string = "DW_OP_breg" + (s2 - 112) + ": " + parseBuffer.parseSLeb128();
            return string;
        }
        switch (s2) {
            case 3: {
                string = "DW_OP_addr: " + parseBuffer.parseAddress(this.addrBits);
                break;
            }
            case 144: {
                string = "DW_OP_regx: " + parseBuffer.parseULeb128();
                break;
            }
            case 145: {
                string = "DW_OP_fbreg: " + parseBuffer.parseSLeb128();
            }
        }
        return string;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public boolean is32bitElf() {
        return this.is32bitElf;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public LinkedHashMap<Long, Long> getDieParentMap() {
        return this.dieParentMap;
    }

    public long getCuOffsetInSection() {
        return this.cuOffsetInSection;
    }

    public Map<Long, Long> getM() {
        return this.m;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public long getDwarfFormat() {
        return this.dwarfFormat;
    }

    public SectionReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public CompilationUnitHeader getHeader() {
        return this.header;
    }

    public LinkedHashMap<Long, DebugInfoEntry> getDebugInfoTable() {
        return this.debugInfoTable;
    }

    public DebugInfoEntry getCu() {
        return this.cu;
    }

    public String getCuDir() {
        return this.cuDir;
    }

    public Stack<Long> getDieParentStack() {
        return this.dieParentStack;
    }

    public long getCuDieOffset() {
        return this.cuDieOffset;
    }

    public long getTimeCost() {
        return this.timeCost;
    }

    public Vector<Long> getCuOffsetInSections() {
        return this.cuOffsetInSections;
    }

    public List<CompilationUnitHeader> getCuHeaders() {
        return this.cuHeaders;
    }

    public DebugStrOffsetsParser getDebugStrOffsetsParser() {
        return this.debugStrOffsetsParser;
    }

    public DebugPubnamesParser getDebugPubnamesParser() {
        return this.debugPubnamesParser;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setCompressed(boolean bl) {
        this.isCompressed = bl;
    }

    public void set32bitElf(boolean bl) {
        this.is32bitElf = bl;
    }

    public void setLittleEndian(boolean bl) {
        this.isLittleEndian = bl;
    }

    public void setDieParentMap(LinkedHashMap<Long, Long> linkedHashMap) {
        this.dieParentMap = linkedHashMap;
    }

    public void setCuOffsetInSection(long l) {
        this.cuOffsetInSection = l;
    }

    public void setM(Map<Long, Long> map) {
        this.m = map;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setBinaryFileReader(SectionReader sectionReader) {
        this.binaryFileReader = sectionReader;
    }

    public void setHeader(CompilationUnitHeader compilationUnitHeader) {
        this.header = compilationUnitHeader;
    }

    public void setDebugInfoTable(LinkedHashMap<Long, DebugInfoEntry> linkedHashMap) {
        this.debugInfoTable = linkedHashMap;
    }

    public void setCu(DebugInfoEntry debugInfoEntry) {
        this.cu = debugInfoEntry;
    }

    public void setCuDir(String string) {
        this.cuDir = string;
    }

    public void setDieParentStack(Stack<Long> stack) {
        this.dieParentStack = stack;
    }

    public void setCuDieOffset(long l) {
        this.cuDieOffset = l;
    }

    public void setTimeCost(long l) {
        this.timeCost = l;
    }

    public void setCuOffsetInSections(Vector<Long> vector) {
        this.cuOffsetInSections = vector;
    }

    public void setCuHeaders(List<CompilationUnitHeader> list) {
        this.cuHeaders = list;
    }

    public void setDebugStrOffsetsParser(DebugStrOffsetsParser debugStrOffsetsParser) {
        this.debugStrOffsetsParser = debugStrOffsetsParser;
    }

    public void setDebugPubnamesParser(DebugPubnamesParser debugPubnamesParser) {
        this.debugPubnamesParser = debugPubnamesParser;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DebugInfoPasrser)) {
            return false;
        }
        DebugInfoPasrser debugInfoPasrser = (DebugInfoPasrser)object;
        if (!debugInfoPasrser.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != debugInfoPasrser.getSectionOffset()) {
            return false;
        }
        if (this.isCompressed() != debugInfoPasrser.isCompressed()) {
            return false;
        }
        if (this.is32bitElf() != debugInfoPasrser.is32bitElf()) {
            return false;
        }
        if (this.isLittleEndian() != debugInfoPasrser.isLittleEndian()) {
            return false;
        }
        if (this.getCuOffsetInSection() != debugInfoPasrser.getCuOffsetInSection()) {
            return false;
        }
        if (this.getSectionSize() != debugInfoPasrser.getSectionSize()) {
            return false;
        }
        if (this.getAddrBits() != debugInfoPasrser.getAddrBits()) {
            return false;
        }
        if (this.getDwarfFormat() != debugInfoPasrser.getDwarfFormat()) {
            return false;
        }
        if (this.getCuDieOffset() != debugInfoPasrser.getCuDieOffset()) {
            return false;
        }
        if (this.getTimeCost() != debugInfoPasrser.getTimeCost()) {
            return false;
        }
        LinkedHashMap<Long, Long> linkedHashMap = this.getDieParentMap();
        LinkedHashMap<Long, Long> linkedHashMap2 = debugInfoPasrser.getDieParentMap();
        if (linkedHashMap == null ? linkedHashMap2 != null : !((Object)linkedHashMap).equals(linkedHashMap2)) {
            return false;
        }
        Map<Long, Long> map = this.getM();
        Map<Long, Long> map2 = debugInfoPasrser.getM();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        String string = this.getFileName();
        String string2 = debugInfoPasrser.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        SectionReader sectionReader = this.getBinaryFileReader();
        SectionReader sectionReader2 = debugInfoPasrser.getBinaryFileReader();
        if (sectionReader == null ? sectionReader2 != null : !((Object)sectionReader).equals(sectionReader2)) {
            return false;
        }
        CompilationUnitHeader compilationUnitHeader = this.getHeader();
        CompilationUnitHeader compilationUnitHeader2 = debugInfoPasrser.getHeader();
        if (compilationUnitHeader == null ? compilationUnitHeader2 != null : !compilationUnitHeader.equals(compilationUnitHeader2)) {
            return false;
        }
        LinkedHashMap<Long, DebugInfoEntry> linkedHashMap3 = this.getDebugInfoTable();
        LinkedHashMap<Long, DebugInfoEntry> linkedHashMap4 = debugInfoPasrser.getDebugInfoTable();
        if (linkedHashMap3 == null ? linkedHashMap4 != null : !((Object)linkedHashMap3).equals(linkedHashMap4)) {
            return false;
        }
        DebugInfoEntry debugInfoEntry = this.getCu();
        DebugInfoEntry debugInfoEntry2 = debugInfoPasrser.getCu();
        if (debugInfoEntry == null ? debugInfoEntry2 != null : !debugInfoEntry.equals(debugInfoEntry2)) {
            return false;
        }
        String string3 = this.getCuDir();
        String string4 = debugInfoPasrser.getCuDir();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        Stack<Long> stack = this.getDieParentStack();
        Stack<Long> stack2 = debugInfoPasrser.getDieParentStack();
        if (stack == null ? stack2 != null : !((Object)stack).equals(stack2)) {
            return false;
        }
        Vector<Long> vector = this.getCuOffsetInSections();
        Vector<Long> vector2 = debugInfoPasrser.getCuOffsetInSections();
        if (vector == null ? vector2 != null : !((Object)vector).equals(vector2)) {
            return false;
        }
        List<CompilationUnitHeader> list = this.getCuHeaders();
        List<CompilationUnitHeader> list2 = debugInfoPasrser.getCuHeaders();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        DebugStrOffsetsParser debugStrOffsetsParser = this.getDebugStrOffsetsParser();
        DebugStrOffsetsParser debugStrOffsetsParser2 = debugInfoPasrser.getDebugStrOffsetsParser();
        if (debugStrOffsetsParser == null ? debugStrOffsetsParser2 != null : !((Object)debugStrOffsetsParser).equals(debugStrOffsetsParser2)) {
            return false;
        }
        DebugPubnamesParser debugPubnamesParser = this.getDebugPubnamesParser();
        DebugPubnamesParser debugPubnamesParser2 = debugInfoPasrser.getDebugPubnamesParser();
        return !(debugPubnamesParser == null ? debugPubnamesParser2 != null : !((Object)debugPubnamesParser).equals(debugPubnamesParser2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DebugInfoPasrser;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        n2 = n2 * 59 + (this.isCompressed() ? 79 : 97);
        n2 = n2 * 59 + (this.is32bitElf() ? 79 : 97);
        n2 = n2 * 59 + (this.isLittleEndian() ? 79 : 97);
        long l2 = this.getCuOffsetInSection();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getSectionSize();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getAddrBits();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = this.getDwarfFormat();
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        long l6 = this.getCuDieOffset();
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        long l7 = this.getTimeCost();
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        LinkedHashMap<Long, Long> linkedHashMap = this.getDieParentMap();
        n2 = n2 * 59 + (linkedHashMap == null ? 43 : ((Object)linkedHashMap).hashCode());
        Map<Long, Long> map = this.getM();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        SectionReader sectionReader = this.getBinaryFileReader();
        n2 = n2 * 59 + (sectionReader == null ? 43 : ((Object)sectionReader).hashCode());
        CompilationUnitHeader compilationUnitHeader = this.getHeader();
        n2 = n2 * 59 + (compilationUnitHeader == null ? 43 : compilationUnitHeader.hashCode());
        LinkedHashMap<Long, DebugInfoEntry> linkedHashMap2 = this.getDebugInfoTable();
        n2 = n2 * 59 + (linkedHashMap2 == null ? 43 : ((Object)linkedHashMap2).hashCode());
        DebugInfoEntry debugInfoEntry = this.getCu();
        n2 = n2 * 59 + (debugInfoEntry == null ? 43 : ((Object)debugInfoEntry).hashCode());
        String string2 = this.getCuDir();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        Stack<Long> stack = this.getDieParentStack();
        n2 = n2 * 59 + (stack == null ? 43 : ((Object)stack).hashCode());
        Vector<Long> vector = this.getCuOffsetInSections();
        n2 = n2 * 59 + (vector == null ? 43 : ((Object)vector).hashCode());
        List<CompilationUnitHeader> list = this.getCuHeaders();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        DebugStrOffsetsParser debugStrOffsetsParser = this.getDebugStrOffsetsParser();
        n2 = n2 * 59 + (debugStrOffsetsParser == null ? 43 : ((Object)debugStrOffsetsParser).hashCode());
        DebugPubnamesParser debugPubnamesParser = this.getDebugPubnamesParser();
        n2 = n2 * 59 + (debugPubnamesParser == null ? 43 : ((Object)debugPubnamesParser).hashCode());
        return n2;
    }

    public String toString() {
        return "DebugInfoPasrser(sectionOffset=" + this.getSectionOffset() + ", isCompressed=" + this.isCompressed() + ", is32bitElf=" + this.is32bitElf() + ", isLittleEndian=" + this.isLittleEndian() + ", dieParentMap=" + this.getDieParentMap() + ", cuOffsetInSection=" + this.getCuOffsetInSection() + ", m=" + this.getM() + ", fileName=" + this.getFileName() + ", sectionSize=" + this.getSectionSize() + ", addrBits=" + this.getAddrBits() + ", dwarfFormat=" + this.getDwarfFormat() + ", binaryFileReader=" + this.getBinaryFileReader() + ", header=" + this.getHeader() + ", debugInfoTable=" + this.getDebugInfoTable() + ", cu=" + this.getCu() + ", cuDir=" + this.getCuDir() + ", dieParentStack=" + this.getDieParentStack() + ", cuDieOffset=" + this.getCuDieOffset() + ", timeCost=" + this.getTimeCost() + ", cuOffsetInSections=" + this.getCuOffsetInSections() + ", cuHeaders=" + this.getCuHeaders() + ", debugStrOffsetsParser=" + this.getDebugStrOffsetsParser() + ", debugPubnamesParser=" + this.getDebugPubnamesParser() + ")";
    }

    public long getAddrBits() {
        return this.addrBits;
    }

    public static class CompilationUnitHeader {
        public static final int HEADER_LENGTH_32 = 11;
        public static final int HEADER_LENGTH_64 = 23;
        public static final long IDENTIFICATION_OF_64BIT = 0xFFFFFFFFL;
        public static final int ADDRESS_SIZE_4 = 4;
        public static final int ADDRESS_SIZE_8 = 8;
        private SectionReader binaryFileReader = null;
        private long dwarfFormat = 0L;
        private long unitLength = 0L;
        private long version = 0L;
        private long debugAbbrevOffset = 0L;
        private long addressSize = 0L;
        private long offsetInSection = 0L;
        private long nextOffsetInSection = 0L;

        public CompilationUnitHeader(SectionReader sectionReader) {
            this.setBinaryFileReader(sectionReader);
            this.offsetInSection = sectionReader.getOffset();
        }

        private boolean parseUnitLength() {
            try {
                this.unitLength = this.binaryFileReader.readUInt();
                if (0xFFFFFFFFL == this.unitLength) {
                    this.dwarfFormat = 64L;
                    this.unitLength = this.binaryFileReader.readULong();
                } else {
                    this.dwarfFormat = 32L;
                }
                this.binaryFileReader.resetReadBytes();
                this.nextOffsetInSection = this.binaryFileReader.getOffset() + this.unitLength;
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseVersion() {
            try {
                this.version = this.binaryFileReader.readUShort();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseUnitByte() {
            try {
                this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseDebugAbbrevOffset() {
            try {
                if (32L == this.dwarfFormat) {
                    this.debugAbbrevOffset = this.binaryFileReader.readUInt();
                } else if (64L == this.dwarfFormat) {
                    this.debugAbbrevOffset = this.binaryFileReader.readULong();
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseAddressSize() {
            try {
                this.addressSize = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            if (4L != this.addressSize && 8L != this.addressSize) {
                Log.error("Address size of debug info header error: %d", this.addressSize);
                return false;
            }
            return true;
        }

        private void setBinaryFileReader(SectionReader sectionReader) {
            this.binaryFileReader = sectionReader;
        }

        public boolean parse() {
            if (null == this.binaryFileReader) {
                return false;
            }
            if (!this.parseUnitLength()) {
                return false;
            }
            if (!this.parseVersion()) {
                return false;
            }
            if (this.version == 5L) {
                if (!this.parseUnitByte()) {
                    return false;
                }
                if (!this.parseAddressSize()) {
                    return false;
                }
                return this.parseDebugAbbrevOffset();
            }
            if (!this.parseDebugAbbrevOffset()) {
                return false;
            }
            return this.parseAddressSize();
        }

        public long getDwarfFormat() {
            return this.dwarfFormat;
        }

        public long getUnitLength() {
            return this.unitLength;
        }

        public long getVersion() {
            return this.version;
        }

        public long getDebugAbbrevOffset() {
            return this.debugAbbrevOffset;
        }

        public long getAddressSize() {
            return this.addressSize;
        }

        public long getOffsetInSection() {
            return this.offsetInSection;
        }

        public long getNextOffsetInSection() {
            return this.nextOffsetInSection;
        }
    }

    public static class DebugInfoEntry {
        public long offsetInCu = 0L;
        public long offsetInSection = 0L;
        public List<Subroutine> subroutines;
        private long tag = 0L;
        private int level = 0;
        public HashMap<Long, String> attributeTable = null;
        public HashMap<Long, Long> attributeForm = null;
        private DebugInfoEntry parent;
        private String name = null;
        private DebugInfoEntry CompileUnit = null;

        public DebugInfoEntry() {
            this.setTag(0L);
            this.attributeTable = new HashMap();
            this.attributeForm = new HashMap();
        }

        public void addAttribute(long l, String string) {
            this.attributeTable.put(l, string);
        }

        public void addAttributeForm(long l, long l2) {
            this.attributeForm.put(l, l2);
        }

        public String getAttribute(long l) {
            return this.attributeTable.get(l);
        }

        public long getForm(long l) {
            if (this.attributeForm == null) {
                return l;
            }
            return this.attributeForm.getOrDefault(l, l);
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public long getOffsetInCu() {
            return this.offsetInCu;
        }

        public long getOffsetInSection() {
            return this.offsetInSection;
        }

        public List<Subroutine> getSubroutines() {
            return this.subroutines;
        }

        public long getTag() {
            return this.tag;
        }

        public int getLevel() {
            return this.level;
        }

        public HashMap<Long, String> getAttributeTable() {
            return this.attributeTable;
        }

        public HashMap<Long, Long> getAttributeForm() {
            return this.attributeForm;
        }

        public DebugInfoEntry getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public DebugInfoEntry getCompileUnit() {
            return this.CompileUnit;
        }

        public void setOffsetInCu(long l) {
            this.offsetInCu = l;
        }

        public void setOffsetInSection(long l) {
            this.offsetInSection = l;
        }

        public void setSubroutines(List<Subroutine> list) {
            this.subroutines = list;
        }

        public void setTag(long l) {
            this.tag = l;
        }

        public void setLevel(int n) {
            this.level = n;
        }

        public void setAttributeTable(HashMap<Long, String> hashMap) {
            this.attributeTable = hashMap;
        }

        public void setAttributeForm(HashMap<Long, Long> hashMap) {
            this.attributeForm = hashMap;
        }

        public void setParent(DebugInfoEntry debugInfoEntry) {
            this.parent = debugInfoEntry;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setCompileUnit(DebugInfoEntry debugInfoEntry) {
            this.CompileUnit = debugInfoEntry;
        }

        public String toString() {
            return "DebugInfoPasrser.DebugInfoEntry(offsetInCu=" + this.getOffsetInCu() + ", offsetInSection=" + this.getOffsetInSection() + ", subroutines=" + this.getSubroutines() + ", tag=" + this.getTag() + ", level=" + this.getLevel() + ", attributeTable=" + this.getAttributeTable() + ", attributeForm=" + this.getAttributeForm() + ", parent=" + this.getParent() + ", name=" + this.getName() + ", CompileUnit=" + this.getCompileUnit() + ")";
        }
    }
}

