/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class DebugAddrParser {
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    BinaryFileReader binaryFileReader;
    TreeMap<Long, List<Long>> addrBaseToAddresses = null;

    public DebugAddrParser(String string, long l, long l2) {
        this.fileName = string;
        this.sectionOffset = l;
        this.sectionSize = l2;
        this.parseBaseAddrToAddresses();
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return this.binaryFileReader.skip(this.sectionOffset);
    }

    private void parseBaseAddrToAddresses() {
        if (this.addrBaseToAddresses != null) {
            return;
        }
        if (!this.openFile()) {
            return;
        }
        this.addrBaseToAddresses = new TreeMap();
        long l = this.sectionOffset;
        while (l < this.sectionOffset + this.sectionSize) {
            DebugAddrHeader debugAddrHeader = new DebugAddrHeader(this.fileName, l);
            if (!debugAddrHeader.parse()) {
                return;
            }
            l = debugAddrHeader.getNextHeaderFileOffset();
            this.addrBaseToAddresses.put(debugAddrHeader.getBaseAddrFileOffset() - this.sectionOffset, debugAddrHeader.getAddresses());
        }
        this.close();
    }

    public long getAddress(long l, int n) {
        try {
            List<Long> list = this.addrBaseToAddresses.get(l);
            return list.get(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0L;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public BinaryFileReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public TreeMap<Long, List<Long>> getAddrBaseToAddresses() {
        return this.addrBaseToAddresses;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    public void setAddrBaseToAddresses(TreeMap<Long, List<Long>> treeMap) {
        this.addrBaseToAddresses = treeMap;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DebugAddrParser)) {
            return false;
        }
        DebugAddrParser debugAddrParser = (DebugAddrParser)object;
        if (!debugAddrParser.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != debugAddrParser.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != debugAddrParser.getSectionSize()) {
            return false;
        }
        String string = this.getFileName();
        String string2 = debugAddrParser.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        BinaryFileReader binaryFileReader = this.getBinaryFileReader();
        BinaryFileReader binaryFileReader2 = debugAddrParser.getBinaryFileReader();
        if (binaryFileReader == null ? binaryFileReader2 != null : !binaryFileReader.equals(binaryFileReader2)) {
            return false;
        }
        TreeMap<Long, List<Long>> treeMap = this.getAddrBaseToAddresses();
        TreeMap<Long, List<Long>> treeMap2 = debugAddrParser.getAddrBaseToAddresses();
        return !(treeMap == null ? treeMap2 != null : !((Object)treeMap).equals(treeMap2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DebugAddrParser;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getSectionSize();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        BinaryFileReader binaryFileReader = this.getBinaryFileReader();
        n2 = n2 * 59 + (binaryFileReader == null ? 43 : binaryFileReader.hashCode());
        TreeMap<Long, List<Long>> treeMap = this.getAddrBaseToAddresses();
        n2 = n2 * 59 + (treeMap == null ? 43 : ((Object)treeMap).hashCode());
        return n2;
    }

    public String toString() {
        return "DebugAddrParser(fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", binaryFileReader=" + this.getBinaryFileReader() + ", addrBaseToAddresses=" + this.getAddrBaseToAddresses() + ")";
    }

    public static class DebugAddrHeader {
        String fileName;
        long fileOffset;
        BinaryFileReader binaryFileReader;
        private long dwarfFormat = 0L;
        private long unitLength = 0L;
        private long version = 0L;
        private long addressSize = 0L;
        private long segmentSelectorSize;
        long baseAddrFileOffset;
        long nextHeaderFileOffset;
        List<Long> addresses = new ArrayList<Long>();

        public DebugAddrHeader(String string, long l) {
            this.fileName = string;
            this.fileOffset = l;
        }

        private boolean checkInit() {
            return this.fileOffset >= 0L;
        }

        private void close() {
            if (null == this.binaryFileReader) {
                return;
            }
            if (!this.binaryFileReader.close()) {
                return;
            }
            this.binaryFileReader = null;
        }

        private boolean openFile() {
            if (!this.checkInit()) {
                return false;
            }
            if (null != this.binaryFileReader) {
                this.close();
            }
            try {
                this.binaryFileReader = new BinaryFileReader(this.fileName);
            }
            catch (Exception exception) {
                Log.error(exception);
                return false;
            }
            return this.binaryFileReader.skip(this.fileOffset);
        }

        public boolean parse() {
            if (!this.openFile()) {
                return false;
            }
            if (!this.parseUnitLength()) {
                return false;
            }
            this.nextHeaderFileOffset = this.binaryFileReader.getOffset() + this.unitLength;
            if (!this.parseVersion()) {
                return false;
            }
            if (!this.parseAddressSize()) {
                return false;
            }
            if (!this.parseSegmentSelectorSize()) {
                return false;
            }
            this.baseAddrFileOffset = this.binaryFileReader.getOffset();
            if (!this.parseAddresses()) {
                return false;
            }
            this.close();
            return true;
        }

        private boolean parseUnitLength() {
            try {
                this.unitLength = this.binaryFileReader.readUInt();
                if (0xFFFFFFFFL == this.unitLength) {
                    this.dwarfFormat = 64L;
                    this.unitLength = this.binaryFileReader.readULong();
                } else {
                    this.dwarfFormat = 32L;
                }
                this.binaryFileReader.resetReadBytes();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseVersion() {
            try {
                this.version = this.binaryFileReader.readUShort();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseAddressSize() {
            try {
                this.addressSize = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            if (4L != this.addressSize && 8L != this.addressSize) {
                Log.error("Address size of debug rnglists header error: %d", this.addressSize);
                return false;
            }
            return true;
        }

        private boolean parseSegmentSelectorSize() {
            try {
                this.segmentSelectorSize = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseAddresses() {
            while (this.binaryFileReader.getOffset() < this.nextHeaderFileOffset) {
                Long l = this.parseAddress();
                if (l == null) {
                    return false;
                }
                this.addresses.add(l);
            }
            return true;
        }

        private Long parseAddress() {
            try {
                if (this.segmentSelectorSize == 0L) {
                    return this.parseBySize((int)this.addressSize);
                }
                Long l = this.parseBySize((int)this.segmentSelectorSize);
                Long l2 = this.parseBySize((int)this.addressSize);
                if (l == null || l2 == null) {
                    return null;
                }
                return l + l2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        private Long parseBySize(int n) {
            try {
                switch (n) {
                    case 4: {
                        return this.binaryFileReader.readUInt();
                    }
                    case 8: {
                        return this.binaryFileReader.readULong();
                    }
                }
                Log.error("parseBySize invalid: size == %d", this.addressSize);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }

        public BinaryFileReader getBinaryFileReader() {
            return this.binaryFileReader;
        }

        public long getDwarfFormat() {
            return this.dwarfFormat;
        }

        public long getUnitLength() {
            return this.unitLength;
        }

        public long getVersion() {
            return this.version;
        }

        public long getAddressSize() {
            return this.addressSize;
        }

        public long getSegmentSelectorSize() {
            return this.segmentSelectorSize;
        }

        public long getBaseAddrFileOffset() {
            return this.baseAddrFileOffset;
        }

        public long getNextHeaderFileOffset() {
            return this.nextHeaderFileOffset;
        }

        public List<Long> getAddresses() {
            return this.addresses;
        }

        public void setFileName(String string) {
            this.fileName = string;
        }

        public void setFileOffset(long l) {
            this.fileOffset = l;
        }

        public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
            this.binaryFileReader = binaryFileReader;
        }

        public void setDwarfFormat(long l) {
            this.dwarfFormat = l;
        }

        public void setUnitLength(long l) {
            this.unitLength = l;
        }

        public void setVersion(long l) {
            this.version = l;
        }

        public void setAddressSize(long l) {
            this.addressSize = l;
        }

        public void setSegmentSelectorSize(long l) {
            this.segmentSelectorSize = l;
        }

        public void setBaseAddrFileOffset(long l) {
            this.baseAddrFileOffset = l;
        }

        public void setNextHeaderFileOffset(long l) {
            this.nextHeaderFileOffset = l;
        }

        public void setAddresses(List<Long> list) {
            this.addresses = list;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DebugAddrHeader)) {
                return false;
            }
            DebugAddrHeader debugAddrHeader = (DebugAddrHeader)object;
            if (!debugAddrHeader.canEqual(this)) {
                return false;
            }
            if (this.getFileOffset() != debugAddrHeader.getFileOffset()) {
                return false;
            }
            if (this.getDwarfFormat() != debugAddrHeader.getDwarfFormat()) {
                return false;
            }
            if (this.getUnitLength() != debugAddrHeader.getUnitLength()) {
                return false;
            }
            if (this.getVersion() != debugAddrHeader.getVersion()) {
                return false;
            }
            if (this.getAddressSize() != debugAddrHeader.getAddressSize()) {
                return false;
            }
            if (this.getSegmentSelectorSize() != debugAddrHeader.getSegmentSelectorSize()) {
                return false;
            }
            if (this.getBaseAddrFileOffset() != debugAddrHeader.getBaseAddrFileOffset()) {
                return false;
            }
            if (this.getNextHeaderFileOffset() != debugAddrHeader.getNextHeaderFileOffset()) {
                return false;
            }
            String string = this.getFileName();
            String string2 = debugAddrHeader.getFileName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            BinaryFileReader binaryFileReader = this.getBinaryFileReader();
            BinaryFileReader binaryFileReader2 = debugAddrHeader.getBinaryFileReader();
            if (binaryFileReader == null ? binaryFileReader2 != null : !binaryFileReader.equals(binaryFileReader2)) {
                return false;
            }
            List<Long> list = this.getAddresses();
            List<Long> list2 = debugAddrHeader.getAddresses();
            return !(list == null ? list2 != null : !((Object)list).equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DebugAddrHeader;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = this.getFileOffset();
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = this.getDwarfFormat();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = this.getUnitLength();
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            long l4 = this.getVersion();
            n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
            long l5 = this.getAddressSize();
            n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
            long l6 = this.getSegmentSelectorSize();
            n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
            long l7 = this.getBaseAddrFileOffset();
            n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
            long l8 = this.getNextHeaderFileOffset();
            n2 = n2 * 59 + (int)(l8 >>> 32 ^ l8);
            String string = this.getFileName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            BinaryFileReader binaryFileReader = this.getBinaryFileReader();
            n2 = n2 * 59 + (binaryFileReader == null ? 43 : binaryFileReader.hashCode());
            List<Long> list = this.getAddresses();
            n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n2;
        }

        public String toString() {
            return "DebugAddrParser.DebugAddrHeader(fileName=" + this.getFileName() + ", fileOffset=" + this.getFileOffset() + ", binaryFileReader=" + this.getBinaryFileReader() + ", dwarfFormat=" + this.getDwarfFormat() + ", unitLength=" + this.getUnitLength() + ", version=" + this.getVersion() + ", addressSize=" + this.getAddressSize() + ", segmentSelectorSize=" + this.getSegmentSelectorSize() + ", baseAddrFileOffset=" + this.getBaseAddrFileOffset() + ", nextHeaderFileOffset=" + this.getNextHeaderFileOffset() + ", addresses=" + this.getAddresses() + ")";
        }
    }
}

