/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.SectionReader;
import com.uqm.crashsight.symtabtool.common.utils.LRUCache;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class DebugAbbrevParser {
    private static final long RESERVED_CODE = 0L;
    private String fileName = null;
    public long sectionOffset = 0L;
    private long sectionSize = 0L;
    private SectionReader binaryFileReader = null;
    private boolean littleEndian;
    private LRUCache<Long, HashMap<Long, DebugAbbrevEntry>> abbrvCache = new LRUCache(5);

    public HashMap<Long, DebugAbbrevEntry> GetAbbrvByCache(long l) {
        if (!this.abbrvCache.containsKey(l)) {
            return null;
        }
        return this.abbrvCache.get(l);
    }

    public boolean PutAbbrvByCache(long l, HashMap<Long, DebugAbbrevEntry> hashMap) {
        this.abbrvCache.put(l, hashMap);
        return true;
    }

    public DebugAbbrevParser(String string, long l, long l2, boolean bl) {
        this.fileName = string;
        this.sectionOffset = l;
        this.sectionSize = l2;
        this.littleEndian = bl;
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (this.binaryFileReader.isUseParseBuffer()) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            Log.error("Failed to open file\uff1a%s", this.fileName);
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (this.binaryFileReader != null && this.binaryFileReader.isUseParseBuffer()) {
            this.binaryFileReader.resetParseBuffer();
            return true;
        }
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new SectionReader(this.fileName, this.sectionOffset, this.sectionSize, this.littleEndian);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    public long getSectionRestLength() {
        return this.binaryFileReader.getSectionRestLength();
    }

    private Vector<DebugAbbrevAttribute> parseAttributeTable() {
        Vector<DebugAbbrevAttribute> vector = new Vector<DebugAbbrevAttribute>();
        while (true) {
            long l = 0L;
            long l2 = 0L;
            try {
                l = this.binaryFileReader.parseULeb128();
                l2 = this.binaryFileReader.parseULeb128();
                if (33L == l2) {
                    this.binaryFileReader.parseULeb128();
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
            if (0L == l && 0L == l2) break;
            DebugAbbrevAttribute debugAbbrevAttribute = new DebugAbbrevAttribute();
            debugAbbrevAttribute.setAttribute(l);
            debugAbbrevAttribute.setForm(l2);
            vector.add(debugAbbrevAttribute);
        }
        return vector;
    }

    private DebugAbbrevEntry parseAbbrevEntry(long l) {
        long l2 = 0L;
        byte by = 0;
        try {
            l2 = this.binaryFileReader.parseULeb128();
            by = this.binaryFileReader.readByte();
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        Vector<DebugAbbrevAttribute> vector = this.parseAttributeTable();
        if (null == vector) {
            Log.error("Failed to parse attribute table of abbrev entry", new Object[0]);
            return null;
        }
        DebugAbbrevEntry debugAbbrevEntry = new DebugAbbrevEntry(l);
        debugAbbrevEntry.setTag(l2);
        debugAbbrevEntry.setHasChild(by);
        debugAbbrevEntry.setAttributeTable(vector);
        return debugAbbrevEntry;
    }

    private HashMap<Long, DebugAbbrevEntry> parseAbbrevTable() {
        if (this.getSectionRestLength() <= 0L) {
            return null;
        }
        HashMap<Long, DebugAbbrevEntry> hashMap = new HashMap<Long, DebugAbbrevEntry>();
        long l = 0L;
        try {
            while (0L != (l = this.binaryFileReader.parseULeb128())) {
                DebugAbbrevEntry debugAbbrevEntry = this.parseAbbrevEntry(l);
                if (null == debugAbbrevEntry) {
                    Log.error("Failed to parse abbrev entry", new Object[0]);
                    return null;
                }
                hashMap.put(new Long(debugAbbrevEntry.getCode()), debugAbbrevEntry);
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
        return hashMap;
    }

    public HashMap<Long, DebugAbbrevEntry> getAbbrevTable(long l) {
        if (l < 0L || l >= this.sectionSize) {
            return null;
        }
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(l)) {
            this.close();
            return null;
        }
        HashMap<Long, DebugAbbrevEntry> hashMap = this.parseAbbrevTable();
        if (null == hashMap) {
            Log.error("Failed to parse abbrev table", new Object[0]);
        }
        this.close();
        return hashMap;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public SectionReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public LRUCache<Long, HashMap<Long, DebugAbbrevEntry>> getAbbrvCache() {
        return this.abbrvCache;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setBinaryFileReader(SectionReader sectionReader) {
        this.binaryFileReader = sectionReader;
    }

    public void setLittleEndian(boolean bl) {
        this.littleEndian = bl;
    }

    public void setAbbrvCache(LRUCache<Long, HashMap<Long, DebugAbbrevEntry>> lRUCache) {
        this.abbrvCache = lRUCache;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DebugAbbrevParser)) {
            return false;
        }
        DebugAbbrevParser debugAbbrevParser = (DebugAbbrevParser)object;
        if (!debugAbbrevParser.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != debugAbbrevParser.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != debugAbbrevParser.getSectionSize()) {
            return false;
        }
        if (this.isLittleEndian() != debugAbbrevParser.isLittleEndian()) {
            return false;
        }
        String string = this.getFileName();
        String string2 = debugAbbrevParser.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        SectionReader sectionReader = this.getBinaryFileReader();
        SectionReader sectionReader2 = debugAbbrevParser.getBinaryFileReader();
        if (sectionReader == null ? sectionReader2 != null : !((Object)sectionReader).equals(sectionReader2)) {
            return false;
        }
        LRUCache<Long, HashMap<Long, DebugAbbrevEntry>> lRUCache = this.getAbbrvCache();
        LRUCache<Long, HashMap<Long, DebugAbbrevEntry>> lRUCache2 = debugAbbrevParser.getAbbrvCache();
        return !(lRUCache == null ? lRUCache2 != null : !lRUCache.equals(lRUCache2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DebugAbbrevParser;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getSectionSize();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        n2 = n2 * 59 + (this.isLittleEndian() ? 79 : 97);
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        SectionReader sectionReader = this.getBinaryFileReader();
        n2 = n2 * 59 + (sectionReader == null ? 43 : ((Object)sectionReader).hashCode());
        LRUCache<Long, HashMap<Long, DebugAbbrevEntry>> lRUCache = this.getAbbrvCache();
        n2 = n2 * 59 + (lRUCache == null ? 43 : lRUCache.hashCode());
        return n2;
    }

    public String toString() {
        return "DebugAbbrevParser(fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", binaryFileReader=" + this.getBinaryFileReader() + ", littleEndian=" + this.isLittleEndian() + ", abbrvCache=" + this.getAbbrvCache() + ")";
    }

    public static class DebugAbbrevEntry {
        private long code = 0L;
        private long tag = 0L;
        private byte hasChild = 0;
        private Vector<DebugAbbrevAttribute> attributeTable = null;

        public void setCode(long l) {
            this.code = l;
        }

        public void setTag(long l) {
            this.tag = l;
        }

        public void setHasChild(byte by) {
            this.hasChild = by;
        }

        public void setAttributeTable(Vector<DebugAbbrevAttribute> vector) {
            this.attributeTable = vector;
        }

        public DebugAbbrevEntry() {
            this.setCode(0L);
            this.setTag(0L);
            this.setHasChild((byte)0);
            this.setAttributeTable(null);
        }

        public DebugAbbrevEntry(long l) {
            this.setCode(l);
            this.setTag(0L);
            this.setHasChild((byte)0);
            this.setAttributeTable(null);
        }

        public long getCode() {
            return this.code;
        }

        public long getTag() {
            return this.tag;
        }

        public byte getHasChild() {
            return this.hasChild;
        }

        public Vector<DebugAbbrevAttribute> getAttributeTable() {
            return this.attributeTable;
        }
    }

    public static class DebugAbbrevAttribute {
        private long attribute = 0L;
        private long form = 0L;

        public DebugAbbrevAttribute() {
            this.setAttribute(0L);
            this.setForm(0L);
        }

        public DebugAbbrevAttribute(long l, long l2) {
            this.setAttribute(l);
            this.setForm(l2);
        }

        public void setAttribute(long l) {
            this.attribute = l;
        }

        public void setForm(long l) {
            this.form = l;
        }

        public long getAttribute() {
            return this.attribute;
        }

        public long getForm() {
            return this.form;
        }
    }
}

