/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.file;

import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SettingFileParser {
    public static final String NOTE_PREFIX = "*";
    public static final String INPUT_FILE = "input";
    public static final String OUTPUT_FILE = "output";
    public static final String SHOULD_UPLOAD = "upload";
    public static final String IS_DEBUG = "debug";
    public static final String APP_ID = "id";
    public static final String APP_KEY = "key";
    public static final String APP_PACKAGE = "package";
    public static final String APP_CHANNEL = "channel";
    public static final String APP_VERSION = "version";
    public static final String OFFSET_ADDRESS = "offset";
    public static final String CRASHSIGHT_VERSION = "crashsight";
    public static final String DEFAULT_SETTING_FILE_NAME = "settings.txt";
    private final File file;
    private Map<String, String> settings = new HashMap<String, String>();

    private SettingFileParser(String string) throws Exception {
        this.file = new File(string);
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parse() {
        Log.info("Begin to parse configuration file: %s", this.file.getAbsolutePath());
        BufferedReader bufferedReader = FileHelper.openFileReader(this.file);
        if (bufferedReader == null) {
            Log.info("Failed to open configuration file: %s", this.file.getAbsolutePath());
            return false;
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if ((string = string.replaceAll("[ ]*", "")) == null || string.startsWith(NOTE_PREFIX) || (stringArray = string.split("[=]+")).length != 2 || stringArray[0].isEmpty() || stringArray[1].isEmpty()) continue;
                this.settings.put(stringArray[0].toLowerCase(), stringArray[1]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(bufferedReader);
        }
        return true;
    }

    public static SettingFileParser create(String string) {
        SettingFileParser settingFileParser;
        if (string == null) {
            return null;
        }
        try {
            settingFileParser = new SettingFileParser(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (!settingFileParser.parse()) {
            return null;
        }
        return settingFileParser;
    }
}

