/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.file;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class BinaryFileWriter {
    public static long INVALID_ENDIAN = -1L;
    public static long BIG_ENDIAN = 0L;
    public static long LITTLE_ENDIAN = 1L;
    private byte[] shortByteArray = new byte[2];
    private byte[] intByteArray = new byte[4];
    private byte[] longByteArray = new byte[8];
    private static final int LONG_BYTES_NUMBER = 8;
    private static final int INT_BYTES_NUMBER = 4;
    private static final int SHORT_BYTES_NUMBER = 2;
    private static final long FIX_UBYTE = 255L;
    private static final long FIX_USHORT = 65535L;
    private static final long FIX_UINT = 0xFFFFFFFFL;
    private long endian = LITTLE_ENDIAN;
    private String fileName = null;
    private BufferedOutputStream bis = null;
    private long offset = 0L;
    private long readBytes = 0L;

    private void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getEndian() {
        return this.endian;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getReadBytesNum() {
        return this.readBytes;
    }

    public void setEndian(long l) {
        this.endian = l;
    }

    public void resetReadBytes() {
        this.readBytes = 0L;
    }

    public BinaryFileWriter(String string) throws Exception {
        this.open(string);
    }

    public BinaryFileWriter(String string, long l) throws Exception {
        this.open(string, l);
    }

    private void open() throws Exception {
        if (null == this.fileName) {
            throw new Exception("File name is null!");
        }
        this.bis = new BufferedOutputStream(new FileOutputStream(this.fileName));
        this.offset = 0L;
        this.readBytes = 0L;
    }

    private void open(String string, long l) throws Exception {
        this.setFileName(string);
        this.setEndian(l);
        this.open();
    }

    private void open(String string) throws Exception {
        this.open(string, LITTLE_ENDIAN);
    }

    public boolean close() {
        try {
            if (null != this.bis) {
                this.bis.close();
            }
            this.bis = null;
            this.fileName = null;
            this.offset = 0L;
            this.readBytes = 0L;
            return true;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
    }

    public BufferedOutputStream getFileStream() {
        return this.bis;
    }

    public boolean readByteArray(byte[] byArray) {
        try {
            this.bis.write(byArray);
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
        this.offset += (long)byArray.length;
        this.readBytes += (long)byArray.length;
        return true;
    }

    public int readInt() throws IOException {
        int n = 0;
        return n;
    }

    public long wirteULong() throws IOException {
        long l = 0L;
        return l;
    }

    private static byte[] longToByteArray(long l, long l2) {
        if (LITTLE_ENDIAN == l2) {
            return BinaryFileWriter.longToByteArrayLE(l);
        }
        return BinaryFileWriter.longToByteArrayBE(l);
    }

    private static byte[] intToByteArray(int n, long l) {
        if (LITTLE_ENDIAN == l) {
            return BinaryFileWriter.intToByteArrayLE(n);
        }
        return BinaryFileWriter.intToByteArrayBE(n);
    }

    public void writeName(byte[] byArray) throws IOException {
        int n = 16 - byArray.length;
        this.bis.write(byArray);
        for (int i = 0; i < n; ++i) {
            this.bis.write(0);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.bis.write(byArray);
    }

    public void writeULong(long l) throws IOException {
        byte[] byArray = BinaryFileWriter.longToByteArray(l, this.endian);
        this.bis.write(byArray);
    }

    public void writeUInt(int n) throws IOException {
        byte[] byArray = BinaryFileWriter.intToByteArray(n, this.endian);
        this.bis.write(byArray);
    }

    private static byte[] longToByteArrayBE(long l) {
        byte[] byArray = new byte[8];
        for (int i = 7; i >= 0; --i) {
            byArray[i] = (byte)(l >> 8 * i & 0xFFL);
        }
        return byArray;
    }

    private static byte[] longToByteArrayLE(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l >> 8 * i & 0xFFL);
        }
        return byArray;
    }

    private static byte[] intToByteArrayBE(long l) {
        byte[] byArray = new byte[4];
        for (int i = 3; i >= 0; --i) {
            byArray[i] = (byte)(l >> 8 * i & 0xFFL);
        }
        return byArray;
    }

    private static byte[] intToByteArrayLE(long l) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(l >> 8 * i & 0xFFL);
        }
        return byArray;
    }
}

