/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common;

import com.uqm.crashsight.symtabtool.common.Section;
import com.uqm.crashsight.symtabtool.common.SectionComparator;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileWriter;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.mach.MachParser;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class DsymRebuilder {
    private RandomAccessFile fileInputStream = null;
    private BinaryFileWriter binaryFileWriter = null;
    private byte[] uuid = new byte[16];
    private HashMap<String, Section> sectionTable = null;
    private Vector<Section> debugSectionTable = new Vector();
    private String SourceFileName = null;
    private static final int BUFF_SIZE = 1024;
    private long debugHeaderStartOffset = Long.MAX_VALUE;
    private long debugHeaderLength = 0L;
    private long debugSectionStartOffset = Long.MAX_VALUE;
    private long debugSectionStartAddr = Long.MAX_VALUE;
    private long outPutOffset = 0L;

    public DsymRebuilder(String string) {
        this.SourceFileName = string;
        try {
            this.fileInputStream = new RandomAccessFile(this.SourceFileName, "r");
            this.binaryFileWriter = new BinaryFileWriter(this.SourceFileName + "_rebuild");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int parseSectionInfo() {
        Log.debug("StartparseSectionInfo", new Object[0]);
        MachParser machParser = MachParser.create(this.SourceFileName, 0L, true);
        this.sectionTable = machParser.getSectionTable();
        int n = 0;
        for (String string : this.sectionTable.keySet()) {
            if (this.sectionTable.get(string).getSegmentName().equals("__DWARF")) {
                this.debugSectionTable.add(this.sectionTable.get(string));
                this.debugHeaderStartOffset = Long.min(this.debugHeaderStartOffset, this.sectionTable.get(string).getHeaderOffset());
                this.debugSectionStartOffset = Long.min(this.debugSectionStartOffset, this.sectionTable.get(string).getOffset());
                this.debugSectionStartAddr = Long.min(this.debugSectionStartAddr, this.sectionTable.get(string).getAddress());
                ++n;
            }
            Log.debug(this.sectionTable.get(string).getSectionName(), new Object[0]);
            Log.debug(String.valueOf(this.sectionTable.get(string).getOffset()), new Object[0]);
        }
        this.debugHeaderLength = (long)n * 80L;
        return 1;
    }

    public void rebuildDebugSection() {
        Log.debug("Start rebuild", new Object[0]);
        this.copyRawData(0L, this.debugHeaderStartOffset);
        Log.debug("Start rebuild debug header", new Object[0]);
        this.rebuildDebugHeader();
        this.writeDebugHeaders();
        this.copyRawData(this.debugHeaderStartOffset + this.debugHeaderLength, this.debugSectionStartOffset);
        Log.debug("Start write debug section", new Object[0]);
        this.writeDebugSections();
        this.copyRestRawData(this.outPutOffset);
        this.binaryFileWriter.close();
    }

    private boolean rebuildDebugHeader() {
        SectionComparator sectionComparator = new SectionComparator();
        Collections.sort(this.debugSectionTable, sectionComparator);
        long l = this.debugSectionStartOffset;
        long l2 = this.debugSectionStartAddr;
        for (int i = 0; i < this.debugSectionTable.size(); ++i) {
            this.debugSectionTable.get(i).setOldOffset(this.debugSectionTable.get(i).getOffset());
            this.debugSectionTable.get(i).setOffset(l);
            this.debugSectionTable.get(i).setAddress(l2);
            l += this.debugSectionTable.get(i).getSize();
            l2 += this.debugSectionTable.get(i).getSize();
            Log.debug(this.debugSectionTable.get(i).getSectionName(), new Object[0]);
            Log.debug(String.valueOf(this.debugSectionTable.get(i).getOffset()), new Object[0]);
        }
        return true;
    }

    private boolean writeDebugHeaders() {
        try {
            for (Section section : this.debugSectionTable) {
                this.binaryFileWriter.writeName(section.getSectionName().getBytes());
                this.binaryFileWriter.writeName(section.getSegmentName().getBytes());
                this.binaryFileWriter.writeULong(section.getAddress());
                this.binaryFileWriter.writeULong(section.getSize());
                this.binaryFileWriter.writeUInt((int)section.getOffset());
                this.binaryFileWriter.writeUInt(section.getAlign());
                this.binaryFileWriter.writeUInt(section.getRelocationOffset());
                this.binaryFileWriter.writeUInt(section.getRelocationEntryNumber());
                this.binaryFileWriter.writeUInt(section.getFlags());
                this.binaryFileWriter.writeUInt(section.getReserved1());
                this.binaryFileWriter.writeUInt(section.getReserved2());
                this.binaryFileWriter.writeUInt(section.getOmit());
                this.outPutOffset += 80L;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    private boolean writeDebugSections() {
        for (Section section : this.debugSectionTable) {
            this.copyRawData(section.getOldOffset(), section.getOldOffset() + section.getSize());
        }
        return true;
    }

    private boolean copyRawData(long l, long l2) {
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            this.fileInputStream.seek(l);
            while (l2 > l && (n = this.fileInputStream.read(byArray)) > 0) {
                if ((long)n > l2 - l) {
                    this.binaryFileWriter.getFileStream().write(byArray, 0, new Long(l2 - l).intValue());
                    this.outPutOffset += (long)new Long(l2 - l).intValue();
                    break;
                }
                this.binaryFileWriter.getFileStream().write(byArray, 0, n);
                this.outPutOffset += (long)n;
                this.binaryFileWriter.getFileStream().flush();
                l += (long)n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    private boolean copyRestRawData(long l) {
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            this.fileInputStream.seek(l);
            while ((n = this.fileInputStream.read(byArray)) > 0) {
                this.binaryFileWriter.getFileStream().write(byArray, 0, n);
                this.outPutOffset += (long)n;
                this.binaryFileWriter.getFileStream().flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }
}

