/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.stif;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.uqm.crashsight.symtabparser.common.file.FileHelper;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFileHeader;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFileInfoBean;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.Leb128Parser;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolEntry;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SymtabIndexFile {
    public static final int SYMTAB_INDEX_FILE_MAJOR_VERSION = 3;
    public static final int SYMTAB_INDEX_FILE_MINOR_VERSION = 2;
    public static final String SYMTAB_STIF_FILE_SUFFIX = "stif";
    public static final String SYMTAB_INDEX_FILE_SUFFIX = "index";
    public static final String SYMTAB_OFFSET_FILE_SUFFIX = "offset";
    public static final String SYMTAB_STR_FILE_SUFFIX = "str";
    public static final String SYMTAB_ADDRESS_FILE_SUFFIX = "address";
    public static final int BYTE_BUFFER_SIZE = 0x6400000;
    public static final int MAX_LEB128_LENGTH = 16;
    public static final int INDEX_USE_CACHE_THRESHOLD = 1048576000;
    public static long vmAddr = 0L;
    public static long pvAddr = 0L;
    public static long moduleBase = 0L;
    public static String fileType = null;
    public static HashMap<Integer, Vector<Integer>> stringOffsetMap = new HashMap();
    private static RandomAccessFile stifRandomAccessFile = null;
    private static File indexFile = null;
    private static RandomAccessFile indexRandomAccessFile = null;
    private static File offsetFile = null;
    private static RandomAccessFile offsetRandomAccessFile = null;
    private static File strFile = null;
    private static RandomAccessFile strRandomAccessFile = null;

    private static void fixSymbolAddr(Symbol symbol) {
        if (symbol.fixedVmAddr) {
            return;
        }
        symbol.fixedVmAddr = true;
        if (fileType.equals("ELF") || fileType.equals("LINUX_ELF")) {
            symbol.setAddress(symbol.getAddress() + vmAddr);
            symbol.setEndAddress(symbol.getEndAddress() + vmAddr);
        } else if (fileType.equalsIgnoreCase("Mach-O")) {
            symbol.setAddress(symbol.getAddress() & 0xFFFFFFFFL);
            symbol.setEndAddress(symbol.getEndAddress() & 0xFFFFFFFFL);
        }
    }

    private static FileChannel createFileChannel(String string, String string2, String string3) {
        if (null == string) {
            return null;
        }
        String string4 = FileHelper.changeFileSuffix(new File(string).getName(), string3);
        string4 = FileHelper.changeFilePath(string4, string2);
        switch (string3) {
            case "stif": {
                File file = new File(string4);
                if (file.exists() && !file.delete()) {
                    Log.error("Fail to delete " + string4, new Object[0]);
                }
                if (null == (stifRandomAccessFile = FileHelper.openRandomAccessFile(file))) {
                    Log.error("Fail to open stif file", new Object[0]);
                    return null;
                }
                return stifRandomAccessFile.getChannel();
            }
            case "index": {
                indexFile = new File(string4);
                if (indexFile.exists() && !indexFile.delete()) {
                    Log.error("Fail to delete " + string4, new Object[0]);
                }
                if (null == (indexRandomAccessFile = FileHelper.openRandomAccessFile(indexFile))) {
                    Log.error("Fail to open index file", new Object[0]);
                    return null;
                }
                return indexRandomAccessFile.getChannel();
            }
            case "offset": {
                offsetFile = new File(string4);
                if (offsetFile.exists() && !offsetFile.delete()) {
                    Log.error("Fail to delete " + string4, new Object[0]);
                }
                if (null == (offsetRandomAccessFile = FileHelper.openRandomAccessFile(offsetFile))) {
                    Log.error("Fail to open offset file", new Object[0]);
                    return null;
                }
                return offsetRandomAccessFile.getChannel();
            }
            case "str": {
                strFile = new File(string4);
                if (strFile.exists() && !strFile.delete()) {
                    Log.error("Fail to delete " + string4, new Object[0]);
                }
                if (null == (strRandomAccessFile = FileHelper.openRandomAccessFile(strFile))) {
                    Log.error("Fail to open str file", new Object[0]);
                    return null;
                }
                return strRandomAccessFile.getChannel();
            }
        }
        return null;
    }

    private static File createSymtabAddressFile(String string, String string2) {
        if (null == string) {
            return null;
        }
        String string3 = FileHelper.changeFileSuffix(new File(string).getName(), SYMTAB_ADDRESS_FILE_SUFFIX);
        File file = new File(string3 = FileHelper.changeFilePath(string3, string2));
        if (file.exists() && !file.delete()) {
            Log.error("Fail to delete " + string3, new Object[0]);
        }
        return file;
    }

    private static boolean constructIndexHeader(SymtabIndexFileHeader symtabIndexFileHeader, ByteBuffer byteBuffer, long l, FileChannel fileChannel, FileChannel fileChannel2) {
        try {
            symtabIndexFileHeader.setIndexOffset(symtabIndexFileHeader.getHeaderLength());
            symtabIndexFileHeader.setIndexSize(l);
            symtabIndexFileHeader.setOffsetOffset(symtabIndexFileHeader.getIndexOffset() + symtabIndexFileHeader.getIndexSize());
            symtabIndexFileHeader.setOffsetSize(fileChannel.position());
            symtabIndexFileHeader.setStrOffset(symtabIndexFileHeader.getOffsetOffset() + symtabIndexFileHeader.getOffsetSize());
            symtabIndexFileHeader.setStrSize(fileChannel2.position());
            byteBuffer.putShort((short)symtabIndexFileHeader.getMajorVersion());
            byteBuffer.putShort((short)symtabIndexFileHeader.getMinorVersion());
            byteBuffer.putInt(symtabIndexFileHeader.getFormat());
            byteBuffer.putLong(symtabIndexFileHeader.getSymtabEntryNum());
            byteBuffer.putLong(symtabIndexFileHeader.getLoadPvaddr());
            byteBuffer.putLong(symtabIndexFileHeader.getLoadPoffset());
            byteBuffer.putLong(symtabIndexFileHeader.getMinEntryStartAddress());
            byteBuffer.putLong(symtabIndexFileHeader.getMaxEntryEndAddress());
            byteBuffer.putLong(symtabIndexFileHeader.getMaxEntryAddressSize());
            byteBuffer.putLong(symtabIndexFileHeader.getIndexOffset());
            byteBuffer.putLong(symtabIndexFileHeader.getIndexSize());
            byteBuffer.putLong(symtabIndexFileHeader.getOffsetOffset());
            byteBuffer.putLong(symtabIndexFileHeader.getOffsetSize());
            byteBuffer.putLong(symtabIndexFileHeader.getStrOffset());
            byteBuffer.putLong(symtabIndexFileHeader.getStrSize());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void flushByteBufferToFile(FileChannel fileChannel, ByteBuffer byteBuffer) {
        try {
            byteBuffer.flip();
            fileChannel.write(byteBuffer);
            byteBuffer.clear();
        }
        catch (Exception exception) {
            Log.error(exception);
        }
    }

    private static long writeStr(FileChannel fileChannel, ByteBuffer byteBuffer, String string) {
        long l = -1L;
        try {
            int n = string.hashCode();
            HashFunction hashFunction = Hashing.murmur3_32_fixed(0);
            int n2 = hashFunction.hashBytes(string.getBytes()).asInt();
            Vector<Integer> vector = stringOffsetMap.get(n);
            if (vector == null) {
                byte[] byArray = string.getBytes();
                if (byteBuffer.remaining() < byArray.length + 1) {
                    SymtabIndexFile.flushByteBufferToFile(fileChannel, byteBuffer);
                }
                l = fileChannel.position() + (long)byteBuffer.position();
                byteBuffer.put(string.getBytes());
                byteBuffer.put((byte)0);
                stringOffsetMap.put(n, new Vector());
                stringOffsetMap.get(n).add(n2);
                stringOffsetMap.get(n).add((int)l);
            } else {
                boolean bl = false;
                for (int i = 0; i < vector.size(); i += 2) {
                    if (n2 != vector.get(i)) continue;
                    l = vector.get(i + 1).intValue();
                    bl = true;
                    break;
                }
                if (!bl) {
                    byte[] byArray = string.getBytes();
                    if (byteBuffer.remaining() < byArray.length + 1) {
                        SymtabIndexFile.flushByteBufferToFile(fileChannel, byteBuffer);
                    }
                    l = fileChannel.position() + (long)byteBuffer.position();
                    byteBuffer.put(string.getBytes());
                    byteBuffer.put((byte)0);
                    stringOffsetMap.get(n).add(n2);
                    stringOffsetMap.get(n).add((int)l);
                }
            }
        }
        catch (Exception exception) {
            Log.error(exception);
        }
        return l;
    }

    private static void writeSymbol(Symbol symbol, byte by, FileChannel fileChannel, ByteBuffer byteBuffer, FileChannel fileChannel2, ByteBuffer byteBuffer2, SymtabIndexFileHeader symtabIndexFileHeader) {
        try {
            for (int i = 0; i < symbol.getEntries().size(); ++i) {
                symtabIndexFileHeader.setMinEntryStartAddress(Long.min(symtabIndexFileHeader.getMinEntryStartAddress(), symbol.getAddress()));
                symtabIndexFileHeader.setMaxEntryEndAddress(Long.max(symtabIndexFileHeader.getMaxEntryEndAddress(), symbol.getEndAddress()));
                symtabIndexFileHeader.setMaxEntryAddressSize(Long.max(symtabIndexFileHeader.getMaxEntryAddressSize(), symbol.getEndAddress() - symbol.getAddress()));
                if (byteBuffer.remaining() < 32) {
                    byteBuffer.flip();
                    fileChannel.write(byteBuffer);
                    byteBuffer.clear();
                }
                byte by2 = 0;
                if (i == 0) {
                    by2 = by;
                }
                if (i < symbol.getEntries().size() - 1) {
                    by2 = (byte)(by2 | 0x80);
                }
                byteBuffer.put(by2);
                SymbolEntry symbolEntry = symbol.getEntries().get(i);
                Leb128Parser.writeUnsignedLeb128(byteBuffer, SymtabIndexFile.writeStr(fileChannel2, byteBuffer2, symbolEntry.getDirString()));
                Leb128Parser.writeUnsignedLeb128(byteBuffer, SymtabIndexFile.writeStr(fileChannel2, byteBuffer2, symbolEntry.getFileString()));
                Leb128Parser.writeUnsignedLeb128(byteBuffer, SymtabIndexFile.writeStr(fileChannel2, byteBuffer2, symbolEntry.getFuncString()));
                Leb128Parser.writeUnsignedLeb128(byteBuffer, SymtabIndexFile.writeStr(fileChannel2, byteBuffer2, symbolEntry.getLineString()));
            }
        }
        catch (Exception exception) {
            Log.error("write symbol error", new Object[0]);
            Log.error(exception);
        }
    }

    private static long writeIndexItem(FileChannel fileChannel, ByteBuffer byteBuffer, boolean bl, List<IndexItem> list, SymtabIndexFileHeader symtabIndexFileHeader) {
        long l = 0L;
        try {
            if (bl) {
                for (IndexItem indexItem : list) {
                    long l2 = indexItem.startAddress - symtabIndexFileHeader.getMinEntryStartAddress();
                    if (l2 > Integer.MAX_VALUE) {
                        Log.error("address[%s] offset overflow!!!", Long.toHexString(l2));
                        continue;
                    }
                    byteBuffer.position((int)l2);
                    Leb128Parser.writeUnsignedLeb128(byteBuffer, indexItem.offset);
                    byteBuffer.put((byte)0);
                }
                l = byteBuffer.position();
            } else {
                byteBuffer.clear();
                for (IndexItem indexItem : list) {
                    long l3 = indexItem.startAddress - symtabIndexFileHeader.getMinEntryStartAddress();
                    if (l3 > Integer.MAX_VALUE) {
                        Log.error("address[%s] offset overflow!!!", Long.toHexString(l3));
                        continue;
                    }
                    Leb128Parser.writeUnsignedLeb128(byteBuffer, indexItem.offset);
                    byteBuffer.put((byte)0);
                    byteBuffer.flip();
                    fileChannel.write(byteBuffer, l3);
                    byteBuffer.clear();
                }
                l = fileChannel.size();
            }
            return l;
        }
        catch (Exception exception) {
            Log.error("Failed to write index items", new Object[0]);
            Log.error(exception);
            return l;
        }
    }

    private static boolean writeBufferToFile(FileChannel fileChannel, FileChannel fileChannel2, ByteBuffer byteBuffer) {
        try {
            fileChannel2.position(0L);
            while (fileChannel2.read(byteBuffer) > 0) {
                byteBuffer.flip();
                fileChannel.write(byteBuffer);
                byteBuffer.clear();
            }
            return true;
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
    }

    private static void saveAddress(BufferedWriter bufferedWriter, Symbol symbol) {
        try {
            long l = (symbol.getAddress() + symbol.getEndAddress()) / 2L;
            if (l == 5515L) {
                Log.info("", new Object[0]);
            }
            bufferedWriter.write(Long.toHexString(l) + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean construct(SymtabIndexFileInfoBean symtabIndexFileInfoBean, SymbolTable symbolTable) {
        long l = System.currentTimeMillis();
        String string = symtabIndexFileInfoBean.getFileName();
        FileChannel fileChannel = SymtabIndexFile.createFileChannel(string, symtabIndexFileInfoBean.getOutputDirName(), SYMTAB_STIF_FILE_SUFFIX);
        FileChannel fileChannel2 = SymtabIndexFile.createFileChannel(string, symtabIndexFileInfoBean.getOutputDirName(), SYMTAB_INDEX_FILE_SUFFIX);
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        FileChannel fileChannel3 = SymtabIndexFile.createFileChannel(string, symtabIndexFileInfoBean.getOutputDirName(), SYMTAB_OFFSET_FILE_SUFFIX);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(0x6400000);
        FileChannel fileChannel4 = SymtabIndexFile.createFileChannel(string, symtabIndexFileInfoBean.getOutputDirName(), SYMTAB_STR_FILE_SUFFIX);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(0x6400000);
        SymtabIndexFileHeader symtabIndexFileHeader = symtabIndexFileInfoBean.getHeader();
        symtabIndexFileHeader.setHasDwarfInfo(symbolTable.isHasDwarfInfo() ? 1 : 0);
        Log.info("Begin to construct stif file", new Object[0]);
        try {
            boolean bl;
            stringOffsetMap.clear();
            ArrayList<IndexItem> arrayList = new ArrayList<IndexItem>();
            long l2 = System.currentTimeMillis();
            symbolTable.rewind();
            Symbol symbol = symbolTable.lastNext();
            ArrayList<Symbol> arrayList2 = new ArrayList<Symbol>();
            int n = 0;
            while (null != symbol) {
                Symbol symbol2;
                SymtabIndexFile.fixSymbolAddr(symbol);
                if (symbol.getAddress() <= 0L || symbol.getEndAddress() <= 0L) {
                    symbol = symbolTable.lastNext();
                    continue;
                }
                long l3 = fileChannel3.position() + (long)byteBuffer2.position();
                arrayList.add(new IndexItem(symbol.getAddress(), l3));
                byteBuffer.clear();
                int n2 = Leb128Parser.writeUnsignedLeb128(byteBuffer, l3);
                arrayList2.clear();
                byte by = 0;
                while (null != (symbol2 = symbolTable.lastNext())) {
                    if (symbol2.getAddress() == 417885620L) {
                        boolean bl2 = true;
                    }
                    SymtabIndexFile.fixSymbolAddr(symbol2);
                    if (symbol2.getAddress() <= 0L || symbol2.getEndAddress() <= 0L) continue;
                    long l4 = symbol2.getAddress() - symbol.getAddress();
                    if ((long)(n2 + 1) <= l4) break;
                    if (l4 < 6L) {
                        arrayList2.add(symbol2);
                        by = (byte)(by | 1 << (int)l4);
                        continue;
                    }
                    Log.info("distance of overlapped symbol's start address from symbol > 6 !!!", new Object[0]);
                }
                if (!arrayList2.isEmpty()) {
                    by = (byte)(by | 0x40);
                }
                SymtabIndexFile.writeSymbol(symbol, by, fileChannel3, byteBuffer2, fileChannel4, byteBuffer3, symtabIndexFileHeader);
                if (++n % 1000000 == 0) {
                    Log.info("Symbom count %d", n);
                }
                for (Symbol symbol3 : arrayList2) {
                    by = 0;
                    by = (byte)(by | 1 << (int)(symbol3.getAddress() - symbol.getAddress()));
                    SymtabIndexFile.writeSymbol(symbol3, by, fileChannel3, byteBuffer2, fileChannel4, byteBuffer3, symtabIndexFileHeader);
                }
                symbol = symbol2;
            }
            int n3 = 0;
            for (Map.Entry<Integer, Vector<Integer>> entry : stringOffsetMap.entrySet()) {
                if (entry.getValue().size() <= 2) continue;
                ++n3;
            }
            Log.info("---------------- %d", n3);
            Log.info("Total Symbol count %d", n);
            byteBuffer2.flip();
            fileChannel3.write(byteBuffer2);
            byteBuffer3.flip();
            fileChannel4.write(byteBuffer3);
            Log.info("write string and offset cost %d[ms] string size: %d, offset size: %d", System.currentTimeMillis() - l2, fileChannel4.position(), fileChannel3.position());
            l2 = System.currentTimeMillis();
            boolean bl3 = bl = symtabIndexFileHeader.getMaxEntryEndAddress() < 1048576000L;
            if (bl) {
                byteBuffer = ByteBuffer.allocate((int)(symtabIndexFileHeader.getMaxEntryEndAddress() - symtabIndexFileHeader.getMinEntryStartAddress() + 16L));
            }
            long l5 = SymtabIndexFile.writeIndexItem(fileChannel2, byteBuffer, bl, arrayList, symtabIndexFileHeader);
            Log.info("write index cost " + (System.currentTimeMillis() - l2) + "ms", new Object[0]);
            byteBuffer2.clear();
            if (!SymtabIndexFile.constructIndexHeader(symtabIndexFileHeader, byteBuffer2, l5, fileChannel3, fileChannel4)) {
                Log.error("Failed to construct header of stif file", new Object[0]);
                boolean bl4 = false;
                return bl4;
            }
            byteBuffer2.flip();
            fileChannel.write(byteBuffer2);
            byteBuffer2.clear();
            Log.info(symtabIndexFileHeader.toString(), new Object[0]);
            if (bl) {
                byteBuffer.flip();
                fileChannel.write(byteBuffer);
            } else if (!SymtabIndexFile.writeBufferToFile(fileChannel, fileChannel2, byteBuffer2)) {
                Log.info("Fail to write offset buffer", new Object[0]);
                boolean bl5 = false;
                return bl5;
            }
            if (!SymtabIndexFile.writeBufferToFile(fileChannel, fileChannel3, byteBuffer2)) {
                Log.info("Fail to write offset buffer", new Object[0]);
                boolean bl6 = false;
                return bl6;
            }
            if (!SymtabIndexFile.writeBufferToFile(fileChannel, fileChannel4, byteBuffer2)) {
                Log.info("Fail to write str buffer", new Object[0]);
                boolean bl7 = false;
                return bl7;
            }
            Log.info("Successfully constructed index file cost %d[ms]", System.currentTimeMillis() - l);
            boolean bl8 = true;
            return bl8;
        }
        catch (IOException | RuntimeException exception) {
            Log.error(exception);
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(offsetRandomAccessFile);
            if (!offsetFile.delete()) {
                offsetFile.deleteOnExit();
            }
            FileHelper.closeFile(strRandomAccessFile);
            if (!strFile.delete()) {
                strFile.deleteOnExit();
            }
            FileHelper.closeFile(indexRandomAccessFile);
            if (!indexFile.delete()) {
                indexFile.deleteOnExit();
            }
            FileHelper.closeFile(stifRandomAccessFile);
        }
    }

    static class IndexItem {
        final long startAddress;
        final long offset;

        public IndexItem(long l, long l2) {
            this.startAddress = l;
            this.offset = l2;
        }
    }
}

