/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.common.file;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileHelper {
    private static final int ZIP_BUFFER = 2048;
    public static final String ZIP_FILE_SUFFIX = ".zip";
    private static final int MERGE_BUFFER_SIZE = 4096;

    public static String changeFileSuffix(String string, String string2) {
        if (null == string || string.isEmpty()) {
            return string;
        }
        String string3 = string;
        if (string.lastIndexOf(".") > 0) {
            string3 = string.substring(0, string.lastIndexOf("."));
        }
        string3 = string3 + "." + string2;
        return string3;
    }

    public static String changeFilePath(String string, String string2) {
        if (null == string || null == string2) {
            return string;
        }
        String string3 = string2 + "/";
        int n = string.lastIndexOf("/") + 1;
        if (n < 0) {
            return string2 + string;
        }
        string3 = string3 + string.substring(n);
        return string3;
    }

    public static String getFileNameFromPath(String string) {
        return new File(string).getName();
    }

    public static Vector<File> getDirFileList(File file) {
        if (null == file) {
            return null;
        }
        Vector<File> vector = new Vector<File>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                vector.add(fileArray[i]);
            }
            if (!fileArray[i].isDirectory()) continue;
            vector.addAll(FileHelper.getDirFileList(fileArray[i]));
        }
        return vector;
    }

    public static MappedByteBuffer mapSymtabIndexFile(String string, long l, long l2) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            MappedByteBuffer mappedByteBuffer = null;
            mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, l, l2);
            randomAccessFile.close();
            return mappedByteBuffer;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
    }

    public static File createTempFile(String string, String string2) {
        try {
            File file = File.createTempFile(string, string2);
            file.deleteOnExit();
            return file;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
    }

    public static boolean closeFile(RandomAccessFile randomAccessFile) {
        if (null == randomAccessFile) {
            return false;
        }
        try {
            randomAccessFile.close();
            return true;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
    }

    public static boolean closeFile(BufferedWriter bufferedWriter) {
        if (null == bufferedWriter) {
            return false;
        }
        try {
            bufferedWriter.flush();
            bufferedWriter.close();
            return true;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
    }

    public static boolean closeFile(BufferedReader bufferedReader) {
        if (null == bufferedReader) {
            return false;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
        return true;
    }

    public static boolean closeFiles(Vector<BufferedReader> vector) {
        for (BufferedReader bufferedReader : vector) {
            FileHelper.closeFile(bufferedReader);
        }
        return true;
    }

    public static Vector<BufferedReader> openFiles(Vector<File> vector) {
        Vector<BufferedReader> vector2 = new Vector<BufferedReader>();
        for (File file : vector) {
            BufferedReader bufferedReader = FileHelper.openFileReader(file);
            if (null == bufferedReader) {
                Log.error("FileHelper: Failed to open file!", new Object[0]);
                return null;
            }
            vector2.add(bufferedReader);
        }
        return vector2;
    }

    public static RandomAccessFile openRandomAccessFile(String string) {
        return FileHelper.openRandomAccessFile(new File(string));
    }

    public static RandomAccessFile openRandomAccessFile(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            return randomAccessFile;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
    }

    public static BufferedReader openFileReader(String string) {
        return FileHelper.openFileReader(new File(string));
    }

    public static BufferedReader openFileReader(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            return bufferedReader;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.error(unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.error(fileNotFoundException);
        }
        return null;
    }

    public static BufferedWriter openFileWriter(String string) {
        return FileHelper.openFileWriter(new File(string));
    }

    public static BufferedWriter openFileWriter(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            return bufferedWriter;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.error(unsupportedEncodingException);
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.error(fileNotFoundException);
            return null;
        }
    }

    public static boolean zipFiles(Vector<File> vector, String string) {
        if (null == vector || null == string) {
            return false;
        }
        byte[] byArray = new byte[2048];
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            ZipEntry zipEntry = null;
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                File file = vector.elementAt(i);
                zipEntry = new ZipEntry(file.getName());
                zipEntry.setSize(file.length());
                zipEntry.setTime(file.lastModified());
                zipOutputStream.putNextEntry(zipEntry);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, 2048)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                ((InputStream)bufferedInputStream).close();
            }
            zipOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
    }

    public static boolean zipFile(File file, String string) {
        Vector<File> vector = new Vector<File>();
        vector.add(file);
        return FileHelper.zipFiles(vector, string);
    }

    public static boolean zipFile(String string, String string2) {
        return FileHelper.zipFile(new File(string), string2);
    }

    public static Vector<String> upZipFile(String string, String string2) {
        return FileHelper.unzipFile(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<String> unzipFile(String string, String string2, String string3) {
        byte[] byArray = new byte[1024];
        Vector<String> vector = new Vector<String>();
        if (!string.endsWith(ZIP_FILE_SUFFIX)) {
            Log.error("Not a zip file", new Object[0]);
            return null;
        }
        File file = new File(string2);
        if (!file.isDirectory()) {
            Log.error("Not a directory: " + string2, new Object[0]);
            return null;
        }
        if (!file.canExecute()) {
            Log.error("No right to access the directory" + string2, new Object[0]);
            return null;
        }
        ZipFile zipFile = null;
        try {
            Cloneable cloneable;
            zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                cloneable = enumeration.nextElement();
                if (((ZipEntry)cloneable).isDirectory() || null != string3 && !((ZipEntry)cloneable).getName().endsWith(string3)) continue;
                String string4 = new File(string2, FileHelper.getFileNameFromPath(((ZipEntry)cloneable).getName())).getAbsolutePath();
                vector.add(string4);
                BufferedOutputStream bufferedOutputStream = null;
                InputStream inputStream2 = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string4));
                    inputStream2 = new BufferedInputStream(zipFile.getInputStream((ZipEntry)cloneable));
                    int n = 0;
                    while ((n = inputStream2.read(byArray, 0, 1024)) != -1) {
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    }
                }
                finally {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                    if (bufferedOutputStream == null) continue;
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            cloneable = vector;
            return cloneable;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            Vector<String> vector2 = null;
            return vector2;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    Log.error(iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean mergeFiles(File file, File file2) {
        if (null == file) return false;
        if (null == file2) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byte[] byArray = new byte[4096];
                int n = 0;
                while ((n = fileInputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                Log.error(iOException);
                boolean bl2 = false;
                return bl2;
            }
            finally {
                try {
                    fileOutputStream.close();
                    fileInputStream.close();
                }
                catch (IOException iOException3) {
                    Log.error(iOException3);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.error(fileNotFoundException);
            return false;
        }
    }
}

