/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser;

import com.uqm.crashsight.symtabparser.ArgsParser;
import com.uqm.crashsight.symtabparser.SymtabFileInfoParser;
import com.uqm.crashsight.symtabparser.common.file.FileHelper;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFile;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFileInfoBean;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import java.io.File;
import java.util.Vector;

public class SymtabFileParser {
    private static final String SYMTAB_FILE_DEFAULT_VERSION = "1.2";
    private static final String SYMTAB_FILE_SUFFIX = ".symbol";
    private static final String SYMTAB_FILE_SUFFIX2 = ".sym";

    private static boolean checkPara(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.isFile()) {
            Log.error("The input is not file\uff1a" + string, new Object[0]);
            return false;
        }
        if (!string.endsWith(SYMTAB_FILE_SUFFIX) && !string.endsWith(SYMTAB_FILE_SUFFIX2)) {
            Log.error("The input is not symtab file: " + string, new Object[0]);
            return false;
        }
        if (!file2.isDirectory()) {
            Log.error("The output specified is not directory: " + string2, new Object[0]);
            return false;
        }
        return true;
    }

    private static int getSymtabFileFormat(SymtabFileInfoParser symtabFileInfoParser) {
        int n = -1;
        String string = symtabFileInfoParser.getInfo("Format");
        if (null == string) {
            return n;
        }
        String string2 = string;
        int n2 = string.indexOf("/");
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1);
        }
        if ((n2 = string2.indexOf("-")) < 0) {
            return n;
        }
        string2 = string2.substring(0, n2);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Log.error(numberFormatException);
            return n;
        }
        return n;
    }

    private static String getSymtabFileVersion(SymtabFileInfoParser symtabFileInfoParser) {
        String string = symtabFileInfoParser.getInfo("File Version");
        if (null == string) {
            string = SYMTAB_FILE_DEFAULT_VERSION;
        }
        if (!string.contains(".")) {
            return null;
        }
        return string;
    }

    private static int parseMajorVersion(String string) {
        try {
            return Integer.parseInt(string.substring(0, string.indexOf(".")));
        }
        catch (NumberFormatException numberFormatException) {
            Log.error(numberFormatException);
            return -1;
        }
    }

    private static int parseMinorVersion(String string) {
        try {
            return Integer.parseInt(string.substring(string.indexOf(".") + 1));
        }
        catch (NumberFormatException numberFormatException) {
            Log.error(numberFormatException);
            return -1;
        }
    }

    private static SymtabIndexFileInfoBean getSymtabFileInfoBean(SymtabFileInfoParser symtabFileInfoParser, String string) {
        SymtabIndexFileInfoBean symtabIndexFileInfoBean = new SymtabIndexFileInfoBean();
        symtabIndexFileInfoBean.setFileName(symtabFileInfoParser.getFileName());
        symtabIndexFileInfoBean.setOutputDirName(string);
        symtabIndexFileInfoBean.setHeaderInfoLineCount(symtabFileInfoParser.getHeaderInfoLineCount());
        symtabIndexFileInfoBean.setSymtabEntryNum(symtabFileInfoParser.getSymbolNumbers());
        symtabIndexFileInfoBean.setPvaddr(Long.parseLong(symtabFileInfoParser.getInfo("Program Virtual Address")));
        symtabIndexFileInfoBean.setPoffset(Long.parseLong(symtabFileInfoParser.getInfo("Program Offset")));
        symtabIndexFileInfoBean.setPalign(Long.parseLong(symtabFileInfoParser.getInfo("Program Align")));
        int n = SymtabFileParser.getSymtabFileFormat(symtabFileInfoParser);
        if (n < 0) {
            Log.error("The format of the symtab file is wrong", new Object[0]);
            return null;
        }
        symtabIndexFileInfoBean.setFormat(n);
        return symtabIndexFileInfoBean;
    }

    private static boolean constructSymtabIndexFile(SymtabFileInfoParser symtabFileInfoParser, String string, SymbolTable symbolTable) {
        String string2 = SymtabFileParser.getSymtabFileVersion(symtabFileInfoParser);
        if (null == string2) {
            Log.error("The version of the symtab file is wrong", new Object[0]);
        }
        assert (string2 != null);
        int n = SymtabFileParser.parseMajorVersion(string2);
        SymtabIndexFileInfoBean symtabIndexFileInfoBean = null;
        switch (n) {
            case 1: {
                Log.info("The major version of the symtab file is 1.", new Object[0]);
                symtabIndexFileInfoBean = SymtabFileParser.getSymtabFileInfoBean(symtabFileInfoParser, string);
                assert (symtabIndexFileInfoBean != null);
                return SymtabIndexFile.construct(symtabIndexFileInfoBean, symbolTable);
            }
            case 2: 
            case 3: {
                Log.info("The major version of the symtab file is 2.", new Object[0]);
                symtabIndexFileInfoBean = SymtabFileParser.getSymtabFileInfoBean(symtabFileInfoParser, string);
                assert (symtabIndexFileInfoBean != null);
                return SymtabIndexFile.construct(symtabIndexFileInfoBean, symbolTable);
            }
        }
        Log.error("The major version of the symtab file is wrong", new Object[0]);
        return false;
    }

    private static boolean parseSymtabFile(String string, String string2, SymbolTable symbolTable) {
        if (!SymtabFileParser.checkPara(string, string2)) {
            return false;
        }
        SymtabFileInfoParser symtabFileInfoParser = SymtabFileInfoParser.create(string);
        if (null == symtabFileInfoParser) {
            return false;
        }
        if (!SymtabFileParser.constructSymtabIndexFile(symtabFileInfoParser, string2, symbolTable)) {
            Log.error("Failed to construct stif file", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean parseSymtabZipFile(String string, String string2) {
        int n;
        if (null == string) {
            return false;
        }
        Log.info("Begin to unzip file: " + string, new Object[0]);
        Vector<String> vector = FileHelper.unzipFile(string, string2, SYMTAB_FILE_SUFFIX);
        if (null == vector) {
            return false;
        }
        Log.info("Successfully unzipped, file list: ", new Object[0]);
        for (n = 0; n < vector.size(); ++n) {
            Log.info("[" + n + "] " + vector.elementAt(n), new Object[0]);
        }
        for (n = 0; n < vector.size(); ++n) {
            String string3 = vector.elementAt(n);
            if (SymtabFileParser.parseSymtabFile(string3, string2, null)) continue;
            return false;
        }
        return true;
    }

    public static boolean parseFile(String string, String string2, SymbolTable symbolTable) {
        if (null == string) {
            return false;
        }
        if (string.endsWith(".zip")) {
            return SymtabFileParser.parseSymtabZipFile(string, string2);
        }
        return SymtabFileParser.parseSymtabFile(string, string2, symbolTable);
    }

    public static boolean parseIosSysSymtabFile(String string, String string2) {
        return SymtabFileParser.parseSymtabFile(string, string2, null);
    }

    public static boolean parseIosSysFolder(String string) {
        boolean bl = false;
        if (null == string) {
            return false;
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (!file2.isFile() || !file2.getName().endsWith(SYMTAB_FILE_SUFFIX2)) continue;
                SymtabFileParser.parseIosSysSymtabFile(file2.getAbsolutePath(), string);
            }
        } else {
            Log.error("No folder or is not dir", new Object[0]);
        }
        return bl;
    }

    public static boolean parseIosSysFolders(String string) {
        boolean bl = false;
        if (null == string) {
            return false;
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) {
                    SymtabFileParser.parseIosSysFolder(file2.getAbsolutePath());
                    continue;
                }
                Log.error("Folder is invalid " + string + " " + file2.getAbsolutePath(), new Object[0]);
            }
        } else {
            Log.error("No folder or is not dir", new Object[0]);
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        ArgsParser argsParser = ArgsParser.create(stringArray);
        if (null == argsParser) {
            return;
        }
        String string = argsParser.getFileName();
        String string2 = argsParser.getOutputDirName();
        if (null == string2) {
            string2 = new File(string).getParent();
        }
        SymtabFileParser.parseFile(string, string2, null);
    }
}

