/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Challenge;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;

public final class AuthenticatorAdapter
implements Authenticator {
    public static final Authenticator INSTANCE = new AuthenticatorAdapter();

    @Override
    public Request authenticate(Proxy proxy, Response response) throws IOException {
        List<Challenge> list = response.challenges();
        Request request = response.request();
        HttpUrl httpUrl = request.httpUrl();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            PasswordAuthentication passwordAuthentication;
            Challenge challenge = list.get(i);
            if (!"Basic".equalsIgnoreCase(challenge.getScheme()) || (passwordAuthentication = java.net.Authenticator.requestPasswordAuthentication(httpUrl.host(), this.getConnectToInetAddress(proxy, httpUrl), httpUrl.port(), httpUrl.scheme(), challenge.getRealm(), challenge.getScheme(), httpUrl.url(), Authenticator.RequestorType.SERVER)) == null) continue;
            String string = Credentials.basic(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()));
            return request.newBuilder().header("Authorization", string).build();
        }
        return null;
    }

    @Override
    public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
        List<Challenge> list = response.challenges();
        Request request = response.request();
        HttpUrl httpUrl = request.httpUrl();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            InetSocketAddress inetSocketAddress;
            PasswordAuthentication passwordAuthentication;
            Challenge challenge = list.get(i);
            if (!"Basic".equalsIgnoreCase(challenge.getScheme()) || (passwordAuthentication = java.net.Authenticator.requestPasswordAuthentication((inetSocketAddress = (InetSocketAddress)proxy.address()).getHostName(), this.getConnectToInetAddress(proxy, httpUrl), inetSocketAddress.getPort(), httpUrl.scheme(), challenge.getRealm(), challenge.getScheme(), httpUrl.url(), Authenticator.RequestorType.PROXY)) == null) continue;
            String string = Credentials.basic(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()));
            return request.newBuilder().header("Proxy-Authorization", string).build();
        }
        return null;
    }

    private InetAddress getConnectToInetAddress(Proxy proxy, HttpUrl httpUrl) throws IOException {
        return proxy != null && proxy.type() != Proxy.Type.DIRECT ? ((InetSocketAddress)proxy.address()).getAddress() : InetAddress.getByName(httpUrl.host());
    }
}

