/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.framed.ErrorCode;
import com.squareup.okhttp.internal.framed.FrameReader;
import com.squareup.okhttp.internal.framed.FrameWriter;
import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.HeadersMode;
import com.squareup.okhttp.internal.framed.NameValueBlockReader;
import com.squareup.okhttp.internal.framed.Settings;
import com.squareup.okhttp.internal.framed.Variant;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.util.List;
import java.util.zip.Deflater;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.DeflaterSink;
import okio.Okio;
import okio.Sink;

public final class Spdy3
implements Variant {
    static final int TYPE_DATA = 0;
    static final int TYPE_SYN_STREAM = 1;
    static final int TYPE_SYN_REPLY = 2;
    static final int TYPE_RST_STREAM = 3;
    static final int TYPE_SETTINGS = 4;
    static final int TYPE_PING = 6;
    static final int TYPE_GOAWAY = 7;
    static final int TYPE_HEADERS = 8;
    static final int TYPE_WINDOW_UPDATE = 9;
    static final int FLAG_FIN = 1;
    static final int FLAG_UNIDIRECTIONAL = 2;
    static final int VERSION = 3;
    static final byte[] DICTIONARY;

    @Override
    public Protocol getProtocol() {
        return Protocol.SPDY_3;
    }

    @Override
    public FrameReader newReader(BufferedSource bufferedSource, boolean bl) {
        return new Reader(bufferedSource, bl);
    }

    @Override
    public FrameWriter newWriter(BufferedSink bufferedSink, boolean bl) {
        return new Writer(bufferedSink, bl);
    }

    static {
        try {
            DICTIONARY = "\u0000\u0000\u0000\u0007options\u0000\u0000\u0000\u0004head\u0000\u0000\u0000\u0004post\u0000\u0000\u0000\u0003put\u0000\u0000\u0000\u0006delete\u0000\u0000\u0000\u0005trace\u0000\u0000\u0000\u0006accept\u0000\u0000\u0000\u000eaccept-charset\u0000\u0000\u0000\u000faccept-encoding\u0000\u0000\u0000\u000faccept-language\u0000\u0000\u0000\raccept-ranges\u0000\u0000\u0000\u0003age\u0000\u0000\u0000\u0005allow\u0000\u0000\u0000\rauthorization\u0000\u0000\u0000\rcache-control\u0000\u0000\u0000\nconnection\u0000\u0000\u0000\fcontent-base\u0000\u0000\u0000\u0010content-encoding\u0000\u0000\u0000\u0010content-language\u0000\u0000\u0000\u000econtent-length\u0000\u0000\u0000\u0010content-location\u0000\u0000\u0000\u000bcontent-md5\u0000\u0000\u0000\rcontent-range\u0000\u0000\u0000\fcontent-type\u0000\u0000\u0000\u0004date\u0000\u0000\u0000\u0004etag\u0000\u0000\u0000\u0006expect\u0000\u0000\u0000\u0007expires\u0000\u0000\u0000\u0004from\u0000\u0000\u0000\u0004host\u0000\u0000\u0000\bif-match\u0000\u0000\u0000\u0011if-modified-since\u0000\u0000\u0000\rif-none-match\u0000\u0000\u0000\bif-range\u0000\u0000\u0000\u0013if-unmodified-since\u0000\u0000\u0000\rlast-modified\u0000\u0000\u0000\blocation\u0000\u0000\u0000\fmax-forwards\u0000\u0000\u0000\u0006pragma\u0000\u0000\u0000\u0012proxy-authenticate\u0000\u0000\u0000\u0013proxy-authorization\u0000\u0000\u0000\u0005range\u0000\u0000\u0000\u0007referer\u0000\u0000\u0000\u000bretry-after\u0000\u0000\u0000\u0006server\u0000\u0000\u0000\u0002te\u0000\u0000\u0000\u0007trailer\u0000\u0000\u0000\u0011transfer-encoding\u0000\u0000\u0000\u0007upgrade\u0000\u0000\u0000\nuser-agent\u0000\u0000\u0000\u0004vary\u0000\u0000\u0000\u0003via\u0000\u0000\u0000\u0007warning\u0000\u0000\u0000\u0010www-authenticate\u0000\u0000\u0000\u0006method\u0000\u0000\u0000\u0003get\u0000\u0000\u0000\u0006status\u0000\u0000\u0000\u0006200 OK\u0000\u0000\u0000\u0007version\u0000\u0000\u0000\bHTTP/1.1\u0000\u0000\u0000\u0003url\u0000\u0000\u0000\u0006public\u0000\u0000\u0000\nset-cookie\u0000\u0000\u0000\nkeep-alive\u0000\u0000\u0000\u0006origin100101201202205206300302303304305306307402405406407408409410411412413414415416417502504505203 Non-Authoritative Information204 No Content301 Moved Permanently400 Bad Request401 Unauthorized403 Forbidden404 Not Found500 Internal Server Error501 Not Implemented503 Service UnavailableJan Feb Mar Apr May Jun Jul Aug Sept Oct Nov Dec 00:00:00 Mon, Tue, Wed, Thu, Fri, Sat, Sun, GMTchunked,text/html,image/png,image/jpg,image/gif,application/xml,application/xhtml+xml,text/plain,text/javascript,publicprivatemax-age=gzip,deflate,sdchcharset=utf-8charset=iso-8859-1,utf-,*,enq=0.".getBytes(Util.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError();
        }
    }

    static final class Writer
    implements FrameWriter {
        private final BufferedSink sink;
        private final Buffer headerBlockBuffer;
        private final BufferedSink headerBlockOut;
        private final boolean client;
        private boolean closed;

        Writer(BufferedSink bufferedSink, boolean bl) {
            this.sink = bufferedSink;
            this.client = bl;
            Deflater deflater = new Deflater();
            deflater.setDictionary(DICTIONARY);
            this.headerBlockBuffer = new Buffer();
            this.headerBlockOut = Okio.buffer(new DeflaterSink((Sink)this.headerBlockBuffer, deflater));
        }

        @Override
        public void ackSettings(Settings settings) {
        }

        @Override
        public void pushPromise(int n, int n2, List<Header> list) throws IOException {
        }

        @Override
        public synchronized void connectionPreface() {
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.sink.flush();
        }

        @Override
        public synchronized void synStream(boolean bl, boolean bl2, int n, int n2, List<Header> list) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.writeNameValueBlockToBuffer(list);
            int n3 = (int)(10L + this.headerBlockBuffer.size());
            int n4 = 1;
            int n5 = (bl ? 1 : 0) | (bl2 ? 2 : 0);
            int n6 = 0;
            this.sink.writeInt(0x80030000 | n4 & 0xFFFF);
            this.sink.writeInt((n5 & 0xFF) << 24 | n3 & 0xFFFFFF);
            this.sink.writeInt(n & Integer.MAX_VALUE);
            this.sink.writeInt(n2 & Integer.MAX_VALUE);
            this.sink.writeShort((n6 & 7) << 13 | (n6 & 0x1F) << 8 | n6 & 0xFF);
            this.sink.writeAll(this.headerBlockBuffer);
            this.sink.flush();
        }

        @Override
        public synchronized void synReply(boolean bl, int n, List<Header> list) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.writeNameValueBlockToBuffer(list);
            int n2 = 2;
            int n3 = bl ? 1 : 0;
            int n4 = (int)(this.headerBlockBuffer.size() + 4L);
            this.sink.writeInt(0x80030000 | n2 & 0xFFFF);
            this.sink.writeInt((n3 & 0xFF) << 24 | n4 & 0xFFFFFF);
            this.sink.writeInt(n & Integer.MAX_VALUE);
            this.sink.writeAll(this.headerBlockBuffer);
            this.sink.flush();
        }

        @Override
        public synchronized void headers(int n, List<Header> list) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.writeNameValueBlockToBuffer(list);
            int n2 = 0;
            int n3 = 8;
            int n4 = (int)(this.headerBlockBuffer.size() + 4L);
            this.sink.writeInt(0x80030000 | n3 & 0xFFFF);
            this.sink.writeInt((n2 & 0xFF) << 24 | n4 & 0xFFFFFF);
            this.sink.writeInt(n & Integer.MAX_VALUE);
            this.sink.writeAll(this.headerBlockBuffer);
        }

        @Override
        public synchronized void rstStream(int n, ErrorCode errorCode) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (errorCode.spdyRstCode == -1) {
                throw new IllegalArgumentException();
            }
            int n2 = 0;
            int n3 = 3;
            int n4 = 8;
            this.sink.writeInt(0x80030000 | n3 & 0xFFFF);
            this.sink.writeInt((n2 & 0xFF) << 24 | n4 & 0xFFFFFF);
            this.sink.writeInt(n & Integer.MAX_VALUE);
            this.sink.writeInt(errorCode.spdyRstCode);
            this.sink.flush();
        }

        @Override
        public int maxDataLength() {
            return 16383;
        }

        @Override
        public synchronized void data(boolean bl, int n, Buffer buffer, int n2) throws IOException {
            int n3 = bl ? 1 : 0;
            this.sendDataFrame(n, n3, buffer, n2);
        }

        void sendDataFrame(int n, int n2, Buffer buffer, int n3) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if ((long)n3 > 0xFFFFFFL) {
                throw new IllegalArgumentException("FRAME_TOO_LARGE max size is 16Mib: " + n3);
            }
            this.sink.writeInt(n & Integer.MAX_VALUE);
            this.sink.writeInt((n2 & 0xFF) << 24 | n3 & 0xFFFFFF);
            if (n3 > 0) {
                this.sink.write(buffer, (long)n3);
            }
        }

        private void writeNameValueBlockToBuffer(List<Header> list) throws IOException {
            this.headerBlockOut.writeInt(list.size());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ByteString byteString = list.get((int)i).name;
                this.headerBlockOut.writeInt(byteString.size());
                this.headerBlockOut.write(byteString);
                ByteString byteString2 = list.get((int)i).value;
                this.headerBlockOut.writeInt(byteString2.size());
                this.headerBlockOut.write(byteString2);
            }
            this.headerBlockOut.flush();
        }

        @Override
        public synchronized void settings(Settings settings) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int n = 4;
            int n2 = 0;
            int n3 = settings.size();
            int n4 = 4 + n3 * 8;
            this.sink.writeInt(0x80030000 | n & 0xFFFF);
            this.sink.writeInt((n2 & 0xFF) << 24 | n4 & 0xFFFFFF);
            this.sink.writeInt(n3);
            for (int i = 0; i <= 10; ++i) {
                if (!settings.isSet(i)) continue;
                int n5 = settings.flags(i);
                this.sink.writeInt((n5 & 0xFF) << 24 | i & 0xFFFFFF);
                this.sink.writeInt(settings.get(i));
            }
            this.sink.flush();
        }

        @Override
        public synchronized void ping(boolean bl, int n, int n2) throws IOException {
            boolean bl2;
            if (this.closed) {
                throw new IOException("closed");
            }
            boolean bl3 = bl2 = this.client != ((n & 1) == 1);
            if (bl != bl2) {
                throw new IllegalArgumentException("payload != reply");
            }
            int n3 = 6;
            int n4 = 0;
            int n5 = 4;
            this.sink.writeInt(0x80030000 | n3 & 0xFFFF);
            this.sink.writeInt((n4 & 0xFF) << 24 | n5 & 0xFFFFFF);
            this.sink.writeInt(n);
            this.sink.flush();
        }

        @Override
        public synchronized void goAway(int n, ErrorCode errorCode, byte[] byArray) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (errorCode.spdyGoAwayCode == -1) {
                throw new IllegalArgumentException("errorCode.spdyGoAwayCode == -1");
            }
            int n2 = 7;
            int n3 = 0;
            int n4 = 8;
            this.sink.writeInt(0x80030000 | n2 & 0xFFFF);
            this.sink.writeInt((n3 & 0xFF) << 24 | n4 & 0xFFFFFF);
            this.sink.writeInt(n);
            this.sink.writeInt(errorCode.spdyGoAwayCode);
            this.sink.flush();
        }

        @Override
        public synchronized void windowUpdate(int n, long l) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (l == 0L || l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("windowSizeIncrement must be between 1 and 0x7fffffff: " + l);
            }
            int n2 = 9;
            int n3 = 0;
            int n4 = 8;
            this.sink.writeInt(0x80030000 | n2 & 0xFFFF);
            this.sink.writeInt((n3 & 0xFF) << 24 | n4 & 0xFFFFFF);
            this.sink.writeInt(n);
            this.sink.writeInt((int)l);
            this.sink.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            this.closed = true;
            Util.closeAll(this.sink, this.headerBlockOut);
        }
    }

    static final class Reader
    implements FrameReader {
        private final BufferedSource source;
        private final boolean client;
        private final NameValueBlockReader headerBlockReader;

        Reader(BufferedSource bufferedSource, boolean bl) {
            this.source = bufferedSource;
            this.headerBlockReader = new NameValueBlockReader(this.source);
            this.client = bl;
        }

        @Override
        public void readConnectionPreface() {
        }

        @Override
        public boolean nextFrame(FrameReader.Handler handler) throws IOException {
            int n;
            int n2;
            try {
                n2 = this.source.readInt();
                n = this.source.readInt();
            }
            catch (IOException iOException) {
                return false;
            }
            boolean bl = (n2 & Integer.MIN_VALUE) != 0;
            int n3 = (n & 0xFF000000) >>> 24;
            int n4 = n & 0xFFFFFF;
            if (bl) {
                int n5 = (n2 & 0x7FFF0000) >>> 16;
                int n6 = n2 & 0xFFFF;
                if (n5 != 3) {
                    throw new ProtocolException("version != 3: " + n5);
                }
                switch (n6) {
                    case 1: {
                        this.readSynStream(handler, n3, n4);
                        return true;
                    }
                    case 2: {
                        this.readSynReply(handler, n3, n4);
                        return true;
                    }
                    case 3: {
                        this.readRstStream(handler, n3, n4);
                        return true;
                    }
                    case 4: {
                        this.readSettings(handler, n3, n4);
                        return true;
                    }
                    case 6: {
                        this.readPing(handler, n3, n4);
                        return true;
                    }
                    case 7: {
                        this.readGoAway(handler, n3, n4);
                        return true;
                    }
                    case 8: {
                        this.readHeaders(handler, n3, n4);
                        return true;
                    }
                    case 9: {
                        this.readWindowUpdate(handler, n3, n4);
                        return true;
                    }
                }
                this.source.skip(n4);
                return true;
            }
            int n7 = n2 & Integer.MAX_VALUE;
            boolean bl2 = (n3 & 1) != 0;
            handler.data(bl2, n7, this.source, n4);
            return true;
        }

        private void readSynStream(FrameReader.Handler handler, int n, int n2) throws IOException {
            int n3 = this.source.readInt();
            int n4 = this.source.readInt();
            int n5 = n3 & Integer.MAX_VALUE;
            int n6 = n4 & Integer.MAX_VALUE;
            this.source.readShort();
            List<Header> list = this.headerBlockReader.readNameValueBlock(n2 - 10);
            boolean bl = (n & 1) != 0;
            boolean bl2 = (n & 2) != 0;
            handler.headers(bl2, bl, n5, n6, list, HeadersMode.SPDY_SYN_STREAM);
        }

        private void readSynReply(FrameReader.Handler handler, int n, int n2) throws IOException {
            int n3 = this.source.readInt();
            int n4 = n3 & Integer.MAX_VALUE;
            List<Header> list = this.headerBlockReader.readNameValueBlock(n2 - 4);
            boolean bl = (n & 1) != 0;
            handler.headers(false, bl, n4, -1, list, HeadersMode.SPDY_REPLY);
        }

        private void readRstStream(FrameReader.Handler handler, int n, int n2) throws IOException {
            if (n2 != 8) {
                throw Reader.ioException("TYPE_RST_STREAM length: %d != 8", n2);
            }
            int n3 = this.source.readInt() & Integer.MAX_VALUE;
            int n4 = this.source.readInt();
            ErrorCode errorCode = ErrorCode.fromSpdy3Rst(n4);
            if (errorCode == null) {
                throw Reader.ioException("TYPE_RST_STREAM unexpected error code: %d", n4);
            }
            handler.rstStream(n3, errorCode);
        }

        private void readHeaders(FrameReader.Handler handler, int n, int n2) throws IOException {
            int n3 = this.source.readInt();
            int n4 = n3 & Integer.MAX_VALUE;
            List<Header> list = this.headerBlockReader.readNameValueBlock(n2 - 4);
            handler.headers(false, false, n4, -1, list, HeadersMode.SPDY_HEADERS);
        }

        private void readWindowUpdate(FrameReader.Handler handler, int n, int n2) throws IOException {
            if (n2 != 8) {
                throw Reader.ioException("TYPE_WINDOW_UPDATE length: %d != 8", n2);
            }
            int n3 = this.source.readInt();
            int n4 = this.source.readInt();
            int n5 = n3 & Integer.MAX_VALUE;
            long l = n4 & Integer.MAX_VALUE;
            if (l == 0L) {
                throw Reader.ioException("windowSizeIncrement was 0", l);
            }
            handler.windowUpdate(n5, l);
        }

        private void readPing(FrameReader.Handler handler, int n, int n2) throws IOException {
            if (n2 != 4) {
                throw Reader.ioException("TYPE_PING length: %d != 4", n2);
            }
            int n3 = this.source.readInt();
            boolean bl = this.client == ((n3 & 1) == 1);
            handler.ping(bl, n3, 0);
        }

        private void readGoAway(FrameReader.Handler handler, int n, int n2) throws IOException {
            if (n2 != 8) {
                throw Reader.ioException("TYPE_GOAWAY length: %d != 8", n2);
            }
            int n3 = this.source.readInt() & Integer.MAX_VALUE;
            int n4 = this.source.readInt();
            ErrorCode errorCode = ErrorCode.fromSpdyGoAway(n4);
            if (errorCode == null) {
                throw Reader.ioException("TYPE_GOAWAY unexpected error code: %d", n4);
            }
            handler.goAway(n3, errorCode, ByteString.EMPTY);
        }

        private void readSettings(FrameReader.Handler handler, int n, int n2) throws IOException {
            int n3;
            int n4 = this.source.readInt();
            if (n2 != 4 + 8 * n4) {
                throw Reader.ioException("TYPE_SETTINGS length: %d != 4 + 8 * %d", n2, n4);
            }
            Settings settings = new Settings();
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = this.source.readInt();
                int n6 = this.source.readInt();
                int n7 = (n5 & 0xFF000000) >>> 24;
                int n8 = n5 & 0xFFFFFF;
                settings.set(n8, n7, n6);
            }
            n3 = (n & 1) != 0 ? 1 : 0;
            handler.settings(n3 != 0, settings);
        }

        private static IOException ioException(String string, Object ... objectArray) throws IOException {
            throw new IOException(String.format(string, objectArray));
        }

        @Override
        public void close() throws IOException {
            this.headerBlockReader.close();
        }
    }
}

