/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import okio.ByteString;

public final class Header {
    public static final ByteString RESPONSE_STATUS = ByteString.encodeUtf8(":status");
    public static final ByteString TARGET_METHOD = ByteString.encodeUtf8(":method");
    public static final ByteString TARGET_PATH = ByteString.encodeUtf8(":path");
    public static final ByteString TARGET_SCHEME = ByteString.encodeUtf8(":scheme");
    public static final ByteString TARGET_AUTHORITY = ByteString.encodeUtf8(":authority");
    public static final ByteString TARGET_HOST = ByteString.encodeUtf8(":host");
    public static final ByteString VERSION = ByteString.encodeUtf8(":version");
    public final ByteString name;
    public final ByteString value;
    final int hpackSize;

    public Header(String string, String string2) {
        this(ByteString.encodeUtf8(string), ByteString.encodeUtf8(string2));
    }

    public Header(ByteString byteString, String string) {
        this(byteString, ByteString.encodeUtf8(string));
    }

    public Header(ByteString byteString, ByteString byteString2) {
        this.name = byteString;
        this.value = byteString2;
        this.hpackSize = 32 + byteString.size() + byteString2.size();
    }

    public boolean equals(Object object) {
        if (object instanceof Header) {
            Header header = (Header)object;
            return this.name.equals(header.name) && this.value.equals(header.value);
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.value.hashCode();
        return n;
    }

    public String toString() {
        return String.format("%s: %s", this.name.utf8(), this.value.utf8());
    }
}

