/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.internal.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import okio.Buffer;
import okio.BufferedSource;

public abstract class ResponseBody
implements Closeable {
    private Reader reader;

    public abstract MediaType contentType();

    public abstract long contentLength() throws IOException;

    public final InputStream byteStream() throws IOException {
        return this.source().inputStream();
    }

    public abstract BufferedSource source() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] bytes() throws IOException {
        byte[] byArray;
        long l = this.contentLength();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + l);
        }
        BufferedSource bufferedSource = this.source();
        try {
            byArray = bufferedSource.readByteArray();
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
        if (l != -1L && l != (long)byArray.length) {
            throw new IOException("Content-Length and stream length disagree");
        }
        return byArray;
    }

    public final Reader charStream() throws IOException {
        Reader reader = this.reader;
        return reader != null ? reader : (this.reader = new InputStreamReader(this.byteStream(), this.charset()));
    }

    public final String string() throws IOException {
        return new String(this.bytes(), this.charset().name());
    }

    private Charset charset() {
        MediaType mediaType = this.contentType();
        return mediaType != null ? mediaType.charset(Util.UTF_8) : Util.UTF_8;
    }

    @Override
    public void close() throws IOException {
        this.source().close();
    }

    public static ResponseBody create(MediaType mediaType, String string) {
        Charset charset = Util.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.UTF_8;
            mediaType = MediaType.parse(mediaType + "; charset=utf-8");
        }
        Buffer buffer = new Buffer().writeString(string, charset);
        return ResponseBody.create(mediaType, buffer.size(), buffer);
    }

    public static ResponseBody create(MediaType mediaType, byte[] byArray) {
        Buffer buffer = new Buffer().write(byArray);
        return ResponseBody.create(mediaType, byArray.length, buffer);
    }

    public static ResponseBody create(final MediaType mediaType, final long l, final BufferedSource bufferedSource) {
        if (bufferedSource == null) {
            throw new NullPointerException("source == null");
        }
        return new ResponseBody(){

            @Override
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public long contentLength() {
                return l;
            }

            @Override
            public BufferedSource source() {
                return bufferedSource;
            }
        };
    }
}

