/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

public final class MultipartBuilder {
    public static final MediaType MIXED = MediaType.parse("multipart/mixed");
    public static final MediaType ALTERNATIVE = MediaType.parse("multipart/alternative");
    public static final MediaType DIGEST = MediaType.parse("multipart/digest");
    public static final MediaType PARALLEL = MediaType.parse("multipart/parallel");
    public static final MediaType FORM = MediaType.parse("multipart/form-data");
    private static final byte[] COLONSPACE = new byte[]{58, 32};
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHDASH = new byte[]{45, 45};
    private final ByteString boundary;
    private MediaType type = MIXED;
    private final List<Headers> partHeaders = new ArrayList<Headers>();
    private final List<RequestBody> partBodies = new ArrayList<RequestBody>();

    public MultipartBuilder() {
        this(UUID.randomUUID().toString());
    }

    public MultipartBuilder(String string) {
        this.boundary = ByteString.encodeUtf8(string);
    }

    public MultipartBuilder type(MediaType mediaType) {
        if (mediaType == null) {
            throw new NullPointerException("type == null");
        }
        if (!mediaType.type().equals("multipart")) {
            throw new IllegalArgumentException("multipart != " + mediaType);
        }
        this.type = mediaType;
        return this;
    }

    public MultipartBuilder addPart(RequestBody requestBody) {
        return this.addPart(null, requestBody);
    }

    public MultipartBuilder addPart(Headers headers, RequestBody requestBody) {
        if (requestBody == null) {
            throw new NullPointerException("body == null");
        }
        if (headers != null && headers.get("Content-Type") != null) {
            throw new IllegalArgumentException("Unexpected header: Content-Type");
        }
        if (headers != null && headers.get("Content-Length") != null) {
            throw new IllegalArgumentException("Unexpected header: Content-Length");
        }
        this.partHeaders.add(headers);
        this.partBodies.add(requestBody);
        return this;
    }

    private static StringBuilder appendQuotedString(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append("%0A");
                    continue block5;
                }
                case '\r': {
                    stringBuilder.append("%0D");
                    continue block5;
                }
                case '\"': {
                    stringBuilder.append("%22");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder;
    }

    public MultipartBuilder addFormDataPart(String string, String string2) {
        return this.addFormDataPart(string, null, RequestBody.create(null, string2));
    }

    public MultipartBuilder addFormDataPart(String string, String string2, RequestBody requestBody) {
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        StringBuilder stringBuilder = new StringBuilder("form-data; name=");
        MultipartBuilder.appendQuotedString(stringBuilder, string);
        if (string2 != null) {
            stringBuilder.append("; filename=");
            MultipartBuilder.appendQuotedString(stringBuilder, string2);
        }
        return this.addPart(Headers.of("Content-Disposition", stringBuilder.toString()), requestBody);
    }

    public RequestBody build() {
        if (this.partHeaders.isEmpty()) {
            throw new IllegalStateException("Multipart body must have at least one part.");
        }
        return new MultipartRequestBody(this.type, this.boundary, this.partHeaders, this.partBodies);
    }

    private static final class MultipartRequestBody
    extends RequestBody {
        private final ByteString boundary;
        private final MediaType contentType;
        private final List<Headers> partHeaders;
        private final List<RequestBody> partBodies;
        private long contentLength = -1L;

        public MultipartRequestBody(MediaType mediaType, ByteString byteString, List<Headers> list, List<RequestBody> list2) {
            if (mediaType == null) {
                throw new NullPointerException("type == null");
            }
            this.boundary = byteString;
            this.contentType = MediaType.parse(mediaType + "; boundary=" + byteString.utf8());
            this.partHeaders = Util.immutableList(list);
            this.partBodies = Util.immutableList(list2);
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public long contentLength() throws IOException {
            long l = this.contentLength;
            if (l != -1L) {
                return l;
            }
            this.contentLength = this.writeOrCountBytes(null, true);
            return this.contentLength;
        }

        private long writeOrCountBytes(BufferedSink bufferedSink, boolean bl) throws IOException {
            long l = 0L;
            Buffer buffer = null;
            if (bl) {
                buffer = new Buffer();
                bufferedSink = buffer;
            }
            int n = this.partHeaders.size();
            for (int i = 0; i < n; ++i) {
                long l2;
                MediaType mediaType;
                Headers headers = this.partHeaders.get(i);
                RequestBody requestBody = this.partBodies.get(i);
                bufferedSink.write(DASHDASH);
                bufferedSink.write(this.boundary);
                bufferedSink.write(CRLF);
                if (headers != null) {
                    int n2 = headers.size();
                    for (int j = 0; j < n2; ++j) {
                        bufferedSink.writeUtf8(headers.name(j)).write(COLONSPACE).writeUtf8(headers.value(j)).write(CRLF);
                    }
                }
                if ((mediaType = requestBody.contentType()) != null) {
                    bufferedSink.writeUtf8("Content-Type: ").writeUtf8(mediaType.toString()).write(CRLF);
                }
                if ((l2 = requestBody.contentLength()) != -1L) {
                    bufferedSink.writeUtf8("Content-Length: ").writeDecimalLong(l2).write(CRLF);
                } else if (bl) {
                    buffer.clear();
                    return -1L;
                }
                bufferedSink.write(CRLF);
                if (bl) {
                    l += l2;
                } else {
                    this.partBodies.get(i).writeTo(bufferedSink);
                }
                bufferedSink.write(CRLF);
            }
            bufferedSink.write(DASHDASH);
            bufferedSink.write(this.boundary);
            bufferedSink.write(DASHDASH);
            bufferedSink.write(CRLF);
            if (bl) {
                l += buffer.size();
                buffer.clear();
            }
            return l;
        }

        @Override
        public void writeTo(BufferedSink bufferedSink) throws IOException {
            this.writeOrCountBytes(bufferedSink, false);
        }
    }
}

