/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpEngine;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Dispatcher {
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    private ExecutorService executorService;
    private final Deque<Call.AsyncCall> readyCalls = new ArrayDeque<Call.AsyncCall>();
    private final Deque<Call.AsyncCall> runningCalls = new ArrayDeque<Call.AsyncCall>();
    private final Deque<Call> executedCalls = new ArrayDeque<Call>();

    public Dispatcher(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Dispatcher() {
    }

    public synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Dispatcher", false));
        }
        return this.executorService;
    }

    public synchronized void setMaxRequests(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("max < 1: " + n);
        }
        this.maxRequests = n;
        this.promoteCalls();
    }

    public synchronized int getMaxRequests() {
        return this.maxRequests;
    }

    public synchronized void setMaxRequestsPerHost(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("max < 1: " + n);
        }
        this.maxRequestsPerHost = n;
        this.promoteCalls();
    }

    public synchronized int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    synchronized void enqueue(Call.AsyncCall asyncCall) {
        if (this.runningCalls.size() < this.maxRequests && this.runningCallsForHost(asyncCall) < this.maxRequestsPerHost) {
            this.runningCalls.add(asyncCall);
            this.getExecutorService().execute(asyncCall);
        } else {
            this.readyCalls.add(asyncCall);
        }
    }

    public synchronized void cancel(Object object) {
        for (Call.AsyncCall object2 : this.readyCalls) {
            if (!Util.equal(object, object2.tag())) continue;
            object2.cancel();
        }
        for (Call.AsyncCall asyncCall : this.runningCalls) {
            if (!Util.equal(object, asyncCall.tag())) continue;
            asyncCall.get().canceled = true;
            HttpEngine httpEngine = asyncCall.get().engine;
            if (httpEngine == null) continue;
            httpEngine.cancel();
        }
        for (Call call : this.executedCalls) {
            if (!Util.equal(object, call.tag())) continue;
            call.cancel();
        }
    }

    synchronized void finished(Call.AsyncCall asyncCall) {
        if (!this.runningCalls.remove(asyncCall)) {
            throw new AssertionError((Object)"AsyncCall wasn't running!");
        }
        this.promoteCalls();
    }

    private void promoteCalls() {
        if (this.runningCalls.size() >= this.maxRequests) {
            return;
        }
        if (this.readyCalls.isEmpty()) {
            return;
        }
        Iterator<Call.AsyncCall> iterator2 = this.readyCalls.iterator();
        while (iterator2.hasNext()) {
            Call.AsyncCall asyncCall = iterator2.next();
            if (this.runningCallsForHost(asyncCall) < this.maxRequestsPerHost) {
                iterator2.remove();
                this.runningCalls.add(asyncCall);
                this.getExecutorService().execute(asyncCall);
            }
            if (this.runningCalls.size() < this.maxRequests) continue;
            return;
        }
    }

    private int runningCallsForHost(Call.AsyncCall asyncCall) {
        int n = 0;
        for (Call.AsyncCall asyncCall2 : this.runningCalls) {
            if (!asyncCall2.host().equals(asyncCall.host())) continue;
            ++n;
        }
        return n;
    }

    synchronized void executed(Call call) {
        this.executedCalls.add(call);
    }

    synchronized void finished(Call call) {
        if (!this.executedCalls.remove(call)) {
            throw new AssertionError((Object)"Call wasn't in-flight!");
        }
    }

    public synchronized int getRunningCallCount() {
        return this.runningCalls.size();
    }

    public synchronized int getQueuedCallCount() {
        return this.readyCalls.size();
    }
}

