/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.NamedRunnable;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.RequestException;
import com.squareup.okhttp.internal.http.RouteException;
import com.squareup.okhttp.internal.http.StreamAllocation;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.logging.Level;

public class Call {
    private final OkHttpClient client;
    private boolean executed;
    volatile boolean canceled;
    Request originalRequest;
    HttpEngine engine;

    protected Call(OkHttpClient okHttpClient, Request request) {
        this.client = okHttpClient.copyWithDefaults();
        this.originalRequest = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        try {
            this.client.getDispatcher().executed(this);
            object = this.getResponseWithInterceptorChain(false);
            if (object == null) {
                throw new IOException("Canceled");
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.client.getDispatcher().finished(this);
        }
    }

    Object tag() {
        return this.originalRequest.tag();
    }

    public void enqueue(Callback callback) {
        this.enqueue(callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Callback callback, boolean bl) {
        Call call = this;
        synchronized (call) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.client.getDispatcher().enqueue(new AsyncCall(callback, bl));
    }

    public void cancel() {
        this.canceled = true;
        if (this.engine != null) {
            this.engine.cancel();
        }
    }

    public synchronized boolean isExecuted() {
        return this.executed;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private String toLoggableString() {
        String string = this.canceled ? "canceled call" : "call";
        HttpUrl httpUrl = this.originalRequest.httpUrl().resolve("/...");
        return string + " to " + httpUrl;
    }

    private Response getResponseWithInterceptorChain(boolean bl) throws IOException {
        ApplicationInterceptorChain applicationInterceptorChain = new ApplicationInterceptorChain(0, this.originalRequest, bl);
        return applicationInterceptorChain.proceed(this.originalRequest);
    }

    Response getResponse(Request object, boolean bl) throws IOException {
        RequestBody requestBody = ((Request)object).body();
        if (requestBody != null) {
            long l;
            Request.Builder builder = ((Request)object).newBuilder();
            MediaType mediaType = requestBody.contentType();
            if (mediaType != null) {
                builder.header("Content-Type", mediaType.toString());
            }
            if ((l = requestBody.contentLength()) != -1L) {
                builder.header("Content-Length", Long.toString(l));
                builder.removeHeader("Transfer-Encoding");
            } else {
                builder.header("Transfer-Encoding", "chunked");
                builder.removeHeader("Content-Length");
            }
            object = builder.build();
        }
        this.engine = new HttpEngine(this.client, (Request)object, false, false, bl, null, null, null);
        int n = 0;
        while (true) {
            StreamAllocation streamAllocation;
            Object object2;
            if (this.canceled) {
                this.engine.releaseStreamAllocation();
                throw new IOException("Canceled");
            }
            boolean bl2 = true;
            try {
                this.engine.sendRequest();
                this.engine.readResponse();
                bl2 = false;
            }
            catch (RequestException requestException) {
                throw requestException.getCause();
            }
            catch (RouteException routeException) {
                object2 = this.engine.recover(routeException);
                if (object2 != null) {
                    bl2 = false;
                    this.engine = object2;
                    continue;
                }
                throw routeException.getLastConnectException();
            }
            catch (IOException iOException) {
                object2 = this.engine.recover(iOException, null);
                if (object2 != null) {
                    bl2 = false;
                    this.engine = object2;
                    continue;
                }
                throw iOException;
            }
            finally {
                if (!bl2) continue;
                streamAllocation = this.engine.close();
                streamAllocation.release();
                continue;
            }
            Response response = this.engine.getResponse();
            object2 = this.engine.followUpRequest();
            if (object2 == null) {
                if (!bl) {
                    this.engine.releaseStreamAllocation();
                }
                return response;
            }
            streamAllocation = this.engine.close();
            if (++n > 20) {
                streamAllocation.release();
                throw new ProtocolException("Too many follow-up requests: " + n);
            }
            if (!this.engine.sameConnection(((Request)object2).httpUrl())) {
                streamAllocation.release();
                streamAllocation = null;
            }
            object = object2;
            this.engine = new HttpEngine(this.client, (Request)object, false, false, bl, streamAllocation, null, response);
        }
    }

    class ApplicationInterceptorChain
    implements Interceptor.Chain {
        private final int index;
        private final Request request;
        private final boolean forWebSocket;

        ApplicationInterceptorChain(int n, Request request, boolean bl) {
            this.index = n;
            this.request = request;
            this.forWebSocket = bl;
        }

        @Override
        public Connection connection() {
            return null;
        }

        @Override
        public Request request() {
            return this.request;
        }

        @Override
        public Response proceed(Request request) throws IOException {
            if (this.index < Call.this.client.interceptors().size()) {
                ApplicationInterceptorChain applicationInterceptorChain = new ApplicationInterceptorChain(this.index + 1, request, this.forWebSocket);
                Interceptor interceptor = Call.this.client.interceptors().get(this.index);
                Response response = interceptor.intercept(applicationInterceptorChain);
                if (response == null) {
                    throw new NullPointerException("application interceptor " + interceptor + " returned null");
                }
                return response;
            }
            return Call.this.getResponse(request, this.forWebSocket);
        }
    }

    final class AsyncCall
    extends NamedRunnable {
        private final Callback responseCallback;
        private final boolean forWebSocket;

        private AsyncCall(Callback callback, boolean bl) {
            super("OkHttp %s", Call.this.originalRequest.urlString());
            this.responseCallback = callback;
            this.forWebSocket = bl;
        }

        String host() {
            return Call.this.originalRequest.httpUrl().host();
        }

        Request request() {
            return Call.this.originalRequest;
        }

        Object tag() {
            return Call.this.originalRequest.tag();
        }

        void cancel() {
            Call.this.cancel();
        }

        Call get() {
            return Call.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            boolean bl = false;
            try {
                Response response = Call.this.getResponseWithInterceptorChain(this.forWebSocket);
                if (Call.this.canceled) {
                    bl = true;
                    this.responseCallback.onFailure(Call.this.originalRequest, new IOException("Canceled"));
                } else {
                    bl = true;
                    this.responseCallback.onResponse(response);
                }
            }
            catch (IOException iOException) {
                if (bl) {
                    Internal.logger.log(Level.INFO, "Callback failure for " + Call.this.toLoggableString(), iOException);
                } else {
                    Request request = Call.this.engine == null ? Call.this.originalRequest : Call.this.engine.getRequest();
                    this.responseCallback.onFailure(request, iOException);
                }
            }
            finally {
                Call.this.client.getDispatcher().finished(this);
            }
        }
    }
}

