/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Handshake;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.DiskLruCache;
import com.squareup.okhttp.internal.InternalCache;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.CacheRequest;
import com.squareup.okhttp.internal.http.CacheStrategy;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.StatusLine;
import com.squareup.okhttp.internal.io.FileSystem;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class Cache {
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    final InternalCache internalCache = new InternalCache(){

        @Override
        public Response get(Request request) throws IOException {
            return Cache.this.get(request);
        }

        @Override
        public CacheRequest put(Response response) throws IOException {
            return Cache.this.put(response);
        }

        @Override
        public void remove(Request request) throws IOException {
            Cache.this.remove(request);
        }

        @Override
        public void update(Response response, Response response2) throws IOException {
            Cache.this.update(response, response2);
        }

        @Override
        public void trackConditionalCacheHit() {
            Cache.this.trackConditionalCacheHit();
        }

        @Override
        public void trackResponse(CacheStrategy cacheStrategy) {
            Cache.this.trackResponse(cacheStrategy);
        }
    };
    private final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;

    public Cache(File file, long l) {
        this(file, l, FileSystem.SYSTEM);
    }

    Cache(File file, long l, FileSystem fileSystem) {
        this.cache = DiskLruCache.create(fileSystem, file, 201105, 2, l);
    }

    private static String urlToKey(Request request) {
        return Util.md5Hex(request.urlString());
    }

    Response get(Request request) {
        Entry entry;
        DiskLruCache.Snapshot snapshot;
        String string = Cache.urlToKey(request);
        try {
            snapshot = this.cache.get(string);
            if (snapshot == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            entry = new Entry(snapshot.getSource(0));
        }
        catch (IOException iOException) {
            Util.closeQuietly(snapshot);
            return null;
        }
        Response response = entry.response(request, snapshot);
        if (!entry.matches(request, response)) {
            Util.closeQuietly(response.body());
            return null;
        }
        return response;
    }

    private CacheRequest put(Response response) throws IOException {
        String string = response.request().method();
        if (HttpMethod.invalidatesCache(response.request().method())) {
            try {
                this.remove(response.request());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (!string.equals("GET")) {
            return null;
        }
        if (OkHeaders.hasVaryAll(response)) {
            return null;
        }
        Entry entry = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            editor = this.cache.edit(Cache.urlToKey(response.request()));
            if (editor == null) {
                return null;
            }
            entry.writeTo(editor);
            return new CacheRequestImpl(editor);
        }
        catch (IOException iOException) {
            this.abortQuietly(editor);
            return null;
        }
    }

    private void remove(Request request) throws IOException {
        this.cache.remove(Cache.urlToKey(request));
    }

    private void update(Response response, Response response2) {
        Entry entry = new Entry(response2);
        DiskLruCache.Snapshot snapshot = ((CacheResponseBody)response.body()).snapshot;
        DiskLruCache.Editor editor = null;
        try {
            editor = snapshot.edit();
            if (editor != null) {
                entry.writeTo(editor);
                editor.commit();
            }
        }
        catch (IOException iOException) {
            this.abortQuietly(editor);
        }
    }

    private void abortQuietly(DiskLruCache.Editor editor) {
        try {
            if (editor != null) {
                editor.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void initialize() throws IOException {
        this.cache.initialize();
    }

    public void delete() throws IOException {
        this.cache.delete();
    }

    public void evictAll() throws IOException {
        this.cache.evictAll();
    }

    public Iterator<String> urls() throws IOException {
        return new Iterator<String>(){
            final Iterator<DiskLruCache.Snapshot> delegate;
            String nextUrl;
            boolean canRemove;
            {
                this.delegate = Cache.this.cache.snapshots();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    DiskLruCache.Snapshot snapshot = this.delegate.next();
                    try {
                        BufferedSource bufferedSource = Okio.buffer(snapshot.getSource(0));
                        this.nextUrl = bufferedSource.readUtf8LineStrict();
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException iOException) {}
                    continue;
                    finally {
                        snapshot.close();
                    }
                }
                return false;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string = this.nextUrl;
                this.nextUrl = null;
                this.canRemove = true;
                return string;
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException("remove() before next()");
                }
                this.delegate.remove();
            }
        };
    }

    public synchronized int getWriteAbortCount() {
        return this.writeAbortCount;
    }

    public synchronized int getWriteSuccessCount() {
        return this.writeSuccessCount;
    }

    public long getSize() throws IOException {
        return this.cache.size();
    }

    public long getMaxSize() {
        return this.cache.getMaxSize();
    }

    public void flush() throws IOException {
        this.cache.flush();
    }

    public void close() throws IOException {
        this.cache.close();
    }

    public File getDirectory() {
        return this.cache.getDirectory();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    private synchronized void trackResponse(CacheStrategy cacheStrategy) {
        ++this.requestCount;
        if (cacheStrategy.networkRequest != null) {
            ++this.networkCount;
        } else if (cacheStrategy.cacheResponse != null) {
            ++this.hitCount;
        }
    }

    private synchronized void trackConditionalCacheHit() {
        ++this.hitCount;
    }

    public synchronized int getNetworkCount() {
        return this.networkCount;
    }

    public synchronized int getHitCount() {
        return this.hitCount;
    }

    public synchronized int getRequestCount() {
        return this.requestCount;
    }

    private static int readInt(BufferedSource bufferedSource) throws IOException {
        try {
            long l = bufferedSource.readDecimalLong();
            String string = bufferedSource.readUtf8LineStrict();
            if (l < 0L || l > Integer.MAX_VALUE || !string.isEmpty()) {
                throw new IOException("expected an int but was \"" + l + string + "\"");
            }
            return (int)l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    private static class CacheResponseBody
    extends ResponseBody {
        private final DiskLruCache.Snapshot snapshot;
        private final BufferedSource bodySource;
        private final String contentType;
        private final String contentLength;

        public CacheResponseBody(final DiskLruCache.Snapshot snapshot, String string, String string2) {
            this.snapshot = snapshot;
            this.contentType = string;
            this.contentLength = string2;
            Source source2 = snapshot.getSource(1);
            this.bodySource = Okio.buffer(new ForwardingSource(source2){

                @Override
                public void close() throws IOException {
                    snapshot.close();
                    super.close();
                }
            });
        }

        @Override
        public MediaType contentType() {
            return this.contentType != null ? MediaType.parse(this.contentType) : null;
        }

        @Override
        public long contentLength() {
            try {
                return this.contentLength != null ? Long.parseLong(this.contentLength) : -1L;
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
        }

        @Override
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    private static final class Entry {
        private final String url;
        private final Headers varyHeaders;
        private final String requestMethod;
        private final Protocol protocol;
        private final int code;
        private final String message;
        private final Headers responseHeaders;
        private final Handshake handshake;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Entry(Source source2) throws IOException {
            try {
                BufferedSource bufferedSource = Okio.buffer(source2);
                this.url = bufferedSource.readUtf8LineStrict();
                this.requestMethod = bufferedSource.readUtf8LineStrict();
                Headers.Builder builder = new Headers.Builder();
                int n = Cache.readInt(bufferedSource);
                for (int i = 0; i < n; ++i) {
                    builder.addLenient(bufferedSource.readUtf8LineStrict());
                }
                this.varyHeaders = builder.build();
                StatusLine statusLine = StatusLine.parse(bufferedSource.readUtf8LineStrict());
                this.protocol = statusLine.protocol;
                this.code = statusLine.code;
                this.message = statusLine.message;
                Headers.Builder builder2 = new Headers.Builder();
                int n2 = Cache.readInt(bufferedSource);
                for (int i = 0; i < n2; ++i) {
                    builder2.addLenient(bufferedSource.readUtf8LineStrict());
                }
                this.responseHeaders = builder2.build();
                if (this.isHttps()) {
                    String string = bufferedSource.readUtf8LineStrict();
                    if (string.length() > 0) {
                        throw new IOException("expected \"\" but was \"" + string + "\"");
                    }
                    String string2 = bufferedSource.readUtf8LineStrict();
                    List<Certificate> list = this.readCertificateList(bufferedSource);
                    List<Certificate> list2 = this.readCertificateList(bufferedSource);
                    this.handshake = Handshake.get(string2, list, list2);
                } else {
                    this.handshake = null;
                }
            }
            finally {
                source2.close();
            }
        }

        public Entry(Response response) {
            this.url = response.request().urlString();
            this.varyHeaders = OkHeaders.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
        }

        public void writeTo(DiskLruCache.Editor editor) throws IOException {
            int n;
            BufferedSink bufferedSink = Okio.buffer(editor.newSink(0));
            bufferedSink.writeUtf8(this.url);
            bufferedSink.writeByte(10);
            bufferedSink.writeUtf8(this.requestMethod);
            bufferedSink.writeByte(10);
            bufferedSink.writeDecimalLong(this.varyHeaders.size());
            bufferedSink.writeByte(10);
            int n2 = this.varyHeaders.size();
            for (n = 0; n < n2; ++n) {
                bufferedSink.writeUtf8(this.varyHeaders.name(n));
                bufferedSink.writeUtf8(": ");
                bufferedSink.writeUtf8(this.varyHeaders.value(n));
                bufferedSink.writeByte(10);
            }
            bufferedSink.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString());
            bufferedSink.writeByte(10);
            bufferedSink.writeDecimalLong(this.responseHeaders.size());
            bufferedSink.writeByte(10);
            n2 = this.responseHeaders.size();
            for (n = 0; n < n2; ++n) {
                bufferedSink.writeUtf8(this.responseHeaders.name(n));
                bufferedSink.writeUtf8(": ");
                bufferedSink.writeUtf8(this.responseHeaders.value(n));
                bufferedSink.writeByte(10);
            }
            if (this.isHttps()) {
                bufferedSink.writeByte(10);
                bufferedSink.writeUtf8(this.handshake.cipherSuite());
                bufferedSink.writeByte(10);
                this.writeCertList(bufferedSink, this.handshake.peerCertificates());
                this.writeCertList(bufferedSink, this.handshake.localCertificates());
            }
            bufferedSink.close();
        }

        private boolean isHttps() {
            return this.url.startsWith("https://");
        }

        private List<Certificate> readCertificateList(BufferedSource bufferedSource) throws IOException {
            int n = Cache.readInt(bufferedSource);
            if (n == -1) {
                return Collections.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> arrayList = new ArrayList<Certificate>(n);
                for (int i = 0; i < n; ++i) {
                    String string = bufferedSource.readUtf8LineStrict();
                    Buffer buffer = new Buffer();
                    buffer.write(ByteString.decodeBase64(string));
                    arrayList.add(certificateFactory.generateCertificate(buffer.inputStream()));
                }
                return arrayList;
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
        }

        private void writeCertList(BufferedSink bufferedSink, List<Certificate> list) throws IOException {
            try {
                bufferedSink.writeDecimalLong(list.size());
                bufferedSink.writeByte(10);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    byte[] byArray = list.get(i).getEncoded();
                    String string = ByteString.of(byArray).base64();
                    bufferedSink.writeUtf8(string);
                    bufferedSink.writeByte(10);
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException(certificateEncodingException.getMessage());
            }
        }

        public boolean matches(Request request, Response response) {
            return this.url.equals(request.urlString()) && this.requestMethod.equals(request.method()) && OkHeaders.varyMatches(response, this.varyHeaders, request);
        }

        public Response response(Request request, DiskLruCache.Snapshot snapshot) {
            String string = this.responseHeaders.get("Content-Type");
            String string2 = this.responseHeaders.get("Content-Length");
            Request request2 = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(request2).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, string, string2)).handshake(this.handshake).build();
        }
    }

    private final class CacheRequestImpl
    implements CacheRequest {
        private final DiskLruCache.Editor editor;
        private Sink cacheOut;
        private boolean done;
        private Sink body;

        public CacheRequestImpl(final DiskLruCache.Editor editor) throws IOException {
            this.editor = editor;
            this.cacheOut = editor.newSink(1);
            this.body = new ForwardingSink(this.cacheOut){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    Cache cache = Cache.this;
                    synchronized (cache) {
                        if (CacheRequestImpl.this.done) {
                            return;
                        }
                        CacheRequestImpl.this.done = true;
                        Cache.this.writeSuccessCount++;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            Cache cache = Cache.this;
            synchronized (cache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                Cache.this.writeAbortCount++;
            }
            Util.closeQuietly(this.cacheOut);
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public Sink body() {
            return this.body;
        }
    }
}

