/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import java.util.zip.Checksum;

public class CRC64
implements Checksum {
    private static final long POLY = -3932672073523589310L;
    private static final long[] table = new long[256];
    private long value;
    private static final int GF2_DIM = 64;

    public CRC64() {
        this.value = 0L;
    }

    public CRC64(long l) {
        this.value = l;
    }

    public CRC64(byte[] byArray, int n) {
        this.value = 0L;
        this.update(byArray, n);
    }

    public static CRC64 fromBytes(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            l <<= 8;
            l ^= (long)byArray[i] & 0xFFL;
        }
        return new CRC64(l);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[7 - i] = (byte)(this.value >>> i * 8);
        }
        return byArray;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public void update(byte[] byArray, int n) {
        int n2 = 0;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        while (n > 0) {
            this.value = table[(int)(this.value ^ (long)byArray[n2]) & 0xFF] ^ this.value >>> 8;
            ++n2;
            --n;
        }
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    public void update(byte by) {
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        this.value = table[(int)(this.value ^ (long)by) & 0xFF] ^ this.value >>> 8;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void update(int n) {
        this.update((byte)(n & 0xFF));
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n2 > 0) {
            this.update(byArray[n3++]);
            --n2;
        }
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    private static long gf2MatrixTimes(long[] lArray, long l) {
        long l2 = 0L;
        int n = 0;
        while (l != 0L) {
            if ((l & 1L) == 1L) {
                l2 ^= lArray[n];
            }
            l >>>= 1;
            ++n;
        }
        return l2;
    }

    private static void gf2MatrixSquare(long[] lArray, long[] lArray2) {
        for (int i = 0; i < 64; ++i) {
            lArray[i] = CRC64.gf2MatrixTimes(lArray2, lArray2[i]);
        }
    }

    public static CRC64 combine(CRC64 cRC64, CRC64 cRC642, long l) {
        if (l == 0L) {
            return new CRC64(cRC64.getValue());
        }
        long[] lArray = new long[64];
        long[] lArray2 = new long[64];
        lArray2[0] = -3932672073523589310L;
        long l2 = 1L;
        for (int i = 1; i < 64; ++i) {
            lArray2[i] = l2;
            l2 <<= 1;
        }
        CRC64.gf2MatrixSquare(lArray, lArray2);
        CRC64.gf2MatrixSquare(lArray2, lArray);
        long l3 = cRC64.getValue();
        long l4 = cRC642.getValue();
        do {
            CRC64.gf2MatrixSquare(lArray, lArray2);
            if ((l & 1L) == 1L) {
                l3 = CRC64.gf2MatrixTimes(lArray, l3);
            }
            if ((l >>>= 1) == 0L) break;
            CRC64.gf2MatrixSquare(lArray2, lArray);
            if ((l & 1L) != 1L) continue;
            l3 = CRC64.gf2MatrixTimes(lArray2, l3);
        } while ((l >>>= 1) != 0L);
        return new CRC64(l3 ^= l4);
    }

    public static long combine(long l, long l2, long l3) {
        if (l3 == 0L) {
            return l;
        }
        long[] lArray = new long[64];
        long[] lArray2 = new long[64];
        lArray2[0] = -3932672073523589310L;
        long l4 = 1L;
        for (int i = 1; i < 64; ++i) {
            lArray2[i] = l4;
            l4 <<= 1;
        }
        CRC64.gf2MatrixSquare(lArray, lArray2);
        CRC64.gf2MatrixSquare(lArray2, lArray);
        do {
            CRC64.gf2MatrixSquare(lArray, lArray2);
            if ((l3 & 1L) == 1L) {
                l = CRC64.gf2MatrixTimes(lArray, l);
            }
            if ((l3 >>>= 1) == 0L) break;
            CRC64.gf2MatrixSquare(lArray2, lArray);
            if ((l3 & 1L) != 1L) continue;
            l = CRC64.gf2MatrixTimes(lArray2, l);
        } while ((l3 >>>= 1) != 0L);
        return l ^= l2;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                if ((l & 1L) == 1L) {
                    l = l >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                l >>>= 1;
            }
            CRC64.table[i] = l;
        }
    }
}

