/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.TransferStateChangeListener;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.PauseException;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.transfer.AbstractTransfer;
import com.qcloud.cos.transfer.PauseResult;
import com.qcloud.cos.transfer.PauseStatus;
import com.qcloud.cos.transfer.PersistableUpload;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.transfer.Upload;
import com.qcloud.cos.transfer.UploadMonitor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class UploadImpl
extends AbstractTransfer
implements Upload {
    private boolean isResumeableMultipartUploadAfterFailed = false;
    private PersistableUpload persistableUploadInfo = null;

    public UploadImpl(String string, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, TransferStateChangeListener transferStateChangeListener) {
        super(string, transferProgress, progressListenerChain, transferStateChangeListener);
    }

    @Override
    public UploadResult waitForUploadResult() throws CosClientException, CosServiceException, InterruptedException {
        try {
            UploadResult uploadResult = null;
            while (!this.monitor.isDone() || uploadResult == null) {
                Future<?> future = this.monitor.getFuture();
                uploadResult = (UploadResult)future.get();
            }
            return uploadResult;
        }
        catch (ExecutionException executionException) {
            this.rethrowExecutionException(executionException);
            return null;
        }
    }

    @Override
    public PersistableUpload pause() throws PauseException {
        PauseResult<PersistableUpload> pauseResult = this.pause(true);
        if (pauseResult.getPauseStatus() != PauseStatus.SUCCESS) {
            throw new PauseException(pauseResult.getPauseStatus());
        }
        return pauseResult.getInfoToResume();
    }

    private PauseResult<PersistableUpload> pause(boolean bl) throws CosClientException {
        UploadMonitor uploadMonitor = (UploadMonitor)this.monitor;
        return uploadMonitor.pause(bl);
    }

    @Override
    public PauseResult<PersistableUpload> tryPause(boolean bl) {
        return this.pause(bl);
    }

    @Override
    public void abort() {
        UploadMonitor uploadMonitor = (UploadMonitor)this.monitor;
        uploadMonitor.performAbort();
    }

    @Override
    public boolean isResumeableMultipartUploadAfterFailed() {
        return this.isResumeableMultipartUploadAfterFailed;
    }

    @Override
    public PersistableUpload getResumeableMultipartUploadId() {
        if (this.isResumeableMultipartUploadAfterFailed) {
            return this.persistableUploadInfo;
        }
        return null;
    }

    PersistableUpload getPersistableUploadInfo() {
        return this.persistableUploadInfo;
    }

    void setPersistableUploadInfo(PersistableUpload persistableUpload) {
        this.persistableUploadInfo = persistableUpload;
    }

    void setResumeableMultipartUploadAfterFailed(boolean bl) {
        this.isResumeableMultipartUploadAfterFailed = bl;
    }
}

