/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.event.COSProgressListener;
import com.qcloud.cos.event.COSProgressListenerChain;
import com.qcloud.cos.event.MultipleFileTransferProgressUpdatingListener;
import com.qcloud.cos.event.MultipleFileTransferStateChangeListener;
import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.TransferCompletionFilter;
import com.qcloud.cos.event.TransferProgressUpdatingListener;
import com.qcloud.cos.event.TransferStateChangeListener;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.FileLockException;
import com.qcloud.cos.internal.CopyImpl;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.FileLocks;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.GetObjectMetadataRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListMultipartUploadsRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.MultipartUpload;
import com.qcloud.cos.model.MultipartUploadListing;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingResponse;
import com.qcloud.cos.transfer.Copy;
import com.qcloud.cos.transfer.CopyCallable;
import com.qcloud.cos.transfer.CopyMonitor;
import com.qcloud.cos.transfer.Download;
import com.qcloud.cos.transfer.DownloadCallable;
import com.qcloud.cos.transfer.DownloadImpl;
import com.qcloud.cos.transfer.DownloadMonitor;
import com.qcloud.cos.transfer.ImageAuditingCallable;
import com.qcloud.cos.transfer.ImageAuditingImpl;
import com.qcloud.cos.transfer.ImageAuditingMonitor;
import com.qcloud.cos.transfer.MultipleFileDownload;
import com.qcloud.cos.transfer.MultipleFileDownloadImpl;
import com.qcloud.cos.transfer.MultipleFileTransferMonitor;
import com.qcloud.cos.transfer.MultipleFileUpload;
import com.qcloud.cos.transfer.MultipleFileUploadImpl;
import com.qcloud.cos.transfer.MultipleImageAuditingImpl;
import com.qcloud.cos.transfer.ObjectMetadataProvider;
import com.qcloud.cos.transfer.PersistableDownload;
import com.qcloud.cos.transfer.PersistableResumeDownload;
import com.qcloud.cos.transfer.PersistableUpload;
import com.qcloud.cos.transfer.ResumableDownloadMonitor;
import com.qcloud.cos.transfer.ResumableDownloadSubmitter;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.TransferManagerUtils;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.transfer.Upload;
import com.qcloud.cos.transfer.UploadCallable;
import com.qcloud.cos.transfer.UploadImpl;
import com.qcloud.cos.transfer.UploadMonitor;
import com.qcloud.cos.utils.VersionInfoUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferManager {
    private final COS cos;
    private TransferManagerConfiguration configuration;
    private final ExecutorService threadPool;
    private final ScheduledExecutorService timedThreadPool = new ScheduledThreadPoolExecutor(1, daemonThreadFactory);
    private static final Logger log = LoggerFactory.getLogger(TransferManager.class);
    private final boolean shutDownThreadPools;
    private static final String USER_AGENT = TransferManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String USER_AGENT_MULTIPART = TransferManager.class.getName() + "_multipart/" + VersionInfoUtils.getVersion();
    private static final String USER_AGENT_IMAGE_AUDITING_JOB = TransferManager.class.getName() + "_ImageAuditing/" + VersionInfoUtils.getVersion();
    private static final String DEFAULT_DELIMITER = "/";
    private static final ThreadFactory daemonThreadFactory = new ThreadFactory(){
        final AtomicInteger threadCount = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable runnable2) {
            int n = this.threadCount.incrementAndGet();
            Thread thread2 = new Thread(runnable2);
            thread2.setDaemon(true);
            thread2.setName("COSTransferManagerTimedThread-" + n);
            return thread2;
        }
    };

    public TransferManager(COS cOS) {
        this(cOS, TransferManagerUtils.createDefaultExecutorService());
    }

    public TransferManager(COS cOS, ExecutorService executorService) {
        this(cOS, executorService, true);
    }

    public TransferManager(COS cOS, ExecutorService executorService, boolean bl) {
        this.cos = cOS;
        this.threadPool = executorService;
        this.configuration = new TransferManagerConfiguration();
        this.shutDownThreadPools = bl;
        if (cOS.getClientConfig().getRegion() == null) {
            throw new IllegalArgumentException("region in clientConfig of cosClient must be specified!");
        }
    }

    public void setConfiguration(TransferManagerConfiguration transferManagerConfiguration) {
        this.configuration = transferManagerConfiguration;
    }

    public TransferManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public COS getCOSClient() {
        return this.cos;
    }

    public Upload upload(String string, String string2, InputStream inputStream2, ObjectMetadata objectMetadata) throws CosServiceException, CosClientException {
        return this.upload(new PutObjectRequest(string, string2, inputStream2, objectMetadata));
    }

    public Upload upload(String string, String string2, File file) throws CosServiceException, CosClientException {
        return this.upload(new PutObjectRequest(string, string2, file));
    }

    public Upload upload(PutObjectRequest putObjectRequest) throws CosServiceException, CosClientException {
        return this.doUpload(putObjectRequest, null, null, null);
    }

    public Upload upload(PutObjectRequest putObjectRequest, COSProgressListener cOSProgressListener) throws CosServiceException, CosClientException {
        return this.doUpload(putObjectRequest, null, cOSProgressListener, null);
    }

    private Upload doUpload(PutObjectRequest putObjectRequest, TransferStateChangeListener transferStateChangeListener, COSProgressListener cOSProgressListener, PersistableUpload persistableUpload) throws CosServiceException, CosClientException {
        String string;
        TransferManager.appendSingleObjectUserAgent(putObjectRequest);
        String string2 = string = persistableUpload != null ? persistableUpload.getMultipartUploadId() : null;
        if (putObjectRequest.getMetadata() == null) {
            putObjectRequest.setMetadata(new ObjectMetadata());
        }
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        File file = TransferManagerUtils.getRequestFile(putObjectRequest);
        if (file != null) {
            objectMetadata.setContentLength(file.length());
        } else if (string != null) {
            throw new IllegalArgumentException("Unable to resume the upload. No file specified.");
        }
        String string3 = "Uploading to " + putObjectRequest.getBucketName() + DEFAULT_DELIMITER + putObjectRequest.getKey();
        TransferProgress transferProgress = new TransferProgress();
        transferProgress.setTotalBytesToTransfer(TransferManagerUtils.getContentLength(putObjectRequest));
        COSProgressListenerChain cOSProgressListenerChain = new COSProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), putObjectRequest.getGeneralProgressListener(), cOSProgressListener);
        putObjectRequest.setGeneralProgressListener(cOSProgressListenerChain);
        UploadImpl uploadImpl = new UploadImpl(string3, transferProgress, cOSProgressListenerChain, transferStateChangeListener);
        UploadCallable uploadCallable = new UploadCallable(this, this.threadPool, uploadImpl, putObjectRequest, cOSProgressListenerChain, string, transferProgress);
        UploadMonitor uploadMonitor = UploadMonitor.create(this, uploadImpl, this.threadPool, uploadCallable, putObjectRequest, cOSProgressListenerChain);
        uploadImpl.setMonitor(uploadMonitor);
        return uploadImpl;
    }

    public Download download(String string, String string2, File file) {
        return this.download(new GetObjectRequest(string, string2), file);
    }

    public Download download(GetObjectRequest getObjectRequest, File file) {
        return this.doDownload(getObjectRequest, file, null, null, false);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, COSProgressListener cOSProgressListener) {
        return this.doDownload(getObjectRequest, file, null, cOSProgressListener, false);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, boolean bl) {
        return this.download(getObjectRequest, file, null, bl, null, 0x1400000, 0x800000);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, COSProgressListener cOSProgressListener, boolean bl) {
        return this.download(getObjectRequest, file, cOSProgressListener, bl, null, 0x1400000, 0x800000);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, boolean bl, String string, int n, int n2) {
        return this.download(getObjectRequest, file, null, bl, string, n, n2);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, COSProgressListener cOSProgressListener, boolean bl, String string, int n, int n2) {
        if (!bl) {
            return this.doDownload(getObjectRequest, file, null, cOSProgressListener, false);
        }
        return this.doResumableDownload(getObjectRequest, file, null, cOSProgressListener, string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistableResumeDownload getPersistableResumeRecord(GetObjectRequest getObjectRequest, File file, String string) {
        Serializable serializable;
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey());
        if (getObjectRequest.getSSECustomerKey() != null) {
            getObjectMetadataRequest.setSSECustomerKey(getObjectRequest.getSSECustomerKey());
        }
        if (getObjectRequest.getVersionId() != null) {
            getObjectMetadataRequest.setVersionId(getObjectRequest.getVersionId());
        }
        ObjectMetadata objectMetadata = this.cos.getObjectMetadata(getObjectMetadataRequest);
        long l = objectMetadata.getContentLength();
        long l2 = objectMetadata.getLastModified().getTime();
        String string2 = objectMetadata.getETag();
        String string3 = objectMetadata.getCrc64Ecma();
        File file2 = string == null || string == "" ? new File(file.getAbsolutePath() + ".cosresumabletask") : new File(string);
        PersistableResumeDownload persistableResumeDownload = null;
        FileInputStream fileInputStream = null;
        try {
            serializable = file2.getParentFile();
            if (serializable != null && !serializable.exists() && !serializable.mkdirs()) {
                throw new CosClientException("Unable to create directory in the path" + serializable.getAbsolutePath());
            }
            if (!file2.exists()) {
                file2.createNewFile();
            }
            fileInputStream = new FileInputStream(file2);
            persistableResumeDownload = (PersistableResumeDownload)PersistableResumeDownload.deserializeFrom(fileInputStream);
            log.info("deserialize download record from " + file2.getAbsolutePath() + "record: " + persistableResumeDownload.serialize());
        }
        catch (IOException iOException) {
            throw new CosClientException("can not create file" + file2.getAbsolutePath() + iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("resumedownload task file cannot deserialize" + illegalArgumentException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    throw new CosClientException("can not close input stream " + file2.getAbsolutePath() + iOException);
                }
            }
        }
        if (!(persistableResumeDownload != null && persistableResumeDownload.getLastModified() == l2 && persistableResumeDownload.getContentLength().equals(Long.toString(l)) && persistableResumeDownload.getEtag().equals(string2) && persistableResumeDownload.getCrc64ecma().equals(string3))) {
            serializable = new HashMap();
            persistableResumeDownload = new PersistableResumeDownload(l2, Long.toString(l), string2, string3, (HashMap<String, Integer>)serializable);
        }
        persistableResumeDownload.setDumpFile(file2);
        return persistableResumeDownload;
    }

    private Download doResumableDownload(GetObjectRequest getObjectRequest, File file, TransferStateChangeListener transferStateChangeListener, COSProgressListener cOSProgressListener, String string, int n, int n2) {
        FileChannel fileChannel;
        RandomAccessFile randomAccessFile;
        PersistableResumeDownload persistableResumeDownload = this.getPersistableResumeRecord(getObjectRequest, file, string);
        long l = Long.parseLong(persistableResumeDownload.getContentLength());
        if (l < (long)n) {
            persistableResumeDownload.getDumpFile().delete();
            return this.doDownload(getObjectRequest, file, transferStateChangeListener, cOSProgressListener, false);
        }
        TransferManager.appendSingleObjectUserAgent(getObjectRequest);
        String string2 = "Resumable downloading from " + getObjectRequest.getBucketName() + DEFAULT_DELIMITER + getObjectRequest.getKey();
        TransferProgress transferProgress = new TransferProgress();
        COSProgressListenerChain cOSProgressListenerChain = new COSProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), getObjectRequest.getGeneralProgressListener(), cOSProgressListener);
        getObjectRequest.setGeneralProgressListener(new ProgressListenerChain(new TransferCompletionFilter(), cOSProgressListenerChain));
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(l);
            fileChannel = randomAccessFile.getChannel();
        }
        catch (Exception exception) {
            throw new CosClientException("resumable download got exception:" + exception.getCause().getMessage() + exception.getMessage());
        }
        transferProgress.setTotalBytesToTransfer(l);
        DownloadImpl downloadImpl = new DownloadImpl(string2, transferProgress, cOSProgressListenerChain, null, transferStateChangeListener, getObjectRequest, file);
        ResumableDownloadSubmitter resumableDownloadSubmitter = new ResumableDownloadSubmitter(this.cos, this.threadPool, getObjectRequest, downloadImpl, file, randomAccessFile, fileChannel, persistableResumeDownload, n2, n, transferProgress, cOSProgressListenerChain);
        ResumableDownloadMonitor resumableDownloadMonitor = ResumableDownloadMonitor.create(cOSProgressListenerChain, resumableDownloadSubmitter, downloadImpl, this.threadPool, persistableResumeDownload, file, fileChannel);
        downloadImpl.setMonitor(resumableDownloadMonitor);
        return downloadImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Download doDownload(GetObjectRequest getObjectRequest, File file, TransferStateChangeListener transferStateChangeListener, COSProgressListener cOSProgressListener, boolean bl) {
        long l;
        TransferManager.appendSingleObjectUserAgent(getObjectRequest);
        String string = "Downloading from " + getObjectRequest.getBucketName() + DEFAULT_DELIMITER + getObjectRequest.getKey();
        TransferProgress transferProgress = new TransferProgress();
        COSProgressListenerChain cOSProgressListenerChain = new COSProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), getObjectRequest.getGeneralProgressListener(), cOSProgressListener);
        getObjectRequest.setGeneralProgressListener(new ProgressListenerChain(new TransferCompletionFilter(), cOSProgressListenerChain));
        long l2 = 0L;
        long[] lArray = getObjectRequest.getRange();
        if (lArray != null && lArray.length == 2) {
            l2 = lArray[0];
            l = lArray[1];
        } else {
            GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey());
            if (getObjectRequest.getSSECustomerKey() != null) {
                getObjectMetadataRequest.setSSECustomerKey(getObjectRequest.getSSECustomerKey());
            }
            if (getObjectRequest.getVersionId() != null) {
                getObjectMetadataRequest.setVersionId(getObjectRequest.getVersionId());
            }
            ObjectMetadata objectMetadata = this.cos.getObjectMetadata(getObjectMetadataRequest);
            l = objectMetadata.getContentLength() - 1L;
        }
        long l3 = l2;
        DownloadImpl downloadImpl = new DownloadImpl(string, transferProgress, cOSProgressListenerChain, null, transferStateChangeListener, getObjectRequest, file);
        long l4 = l - l2 + 1L;
        transferProgress.setTotalBytesToTransfer(l4);
        long l5 = -1L;
        if (bl) {
            if (!FileLocks.lock(file)) {
                throw new FileLockException("Fail to lock " + file + " for resume download");
            }
            try {
                if (file.exists()) {
                    l5 = file.length();
                    getObjectRequest.setRange(l2 += l5, l);
                    transferProgress.updateProgress(Math.min(l5, l4));
                    l4 = l - l2 + 1L;
                    if (log.isDebugEnabled()) {
                        log.debug("Resume download: totalBytesToDownload=" + l4 + ", origStartingByte=" + l3 + ", startingByte=" + l2 + ", lastByte=" + l + ", numberOfBytesRead=" + l5 + ", file: " + file);
                    }
                }
            }
            finally {
                FileLocks.unlock(file);
            }
        }
        if (l4 < 0L) {
            throw new IllegalArgumentException("Unable to determine the range for download operation.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Future<File> future = this.threadPool.submit(new DownloadCallable(this.cos, countDownLatch, getObjectRequest, bl, downloadImpl, file, l3, l5));
        downloadImpl.setMonitor(new DownloadMonitor(downloadImpl, future));
        countDownLatch.countDown();
        return downloadImpl;
    }

    public MultipleFileDownload downloadDirectory(String string, String string2, File file) {
        Object object;
        Object object2;
        Object object3;
        if (string2 == null) {
            string2 = "";
        }
        LinkedList<COSObjectSummary> linkedList = new LinkedList<COSObjectSummary>();
        Stack<String> stack = new Stack<String>();
        stack.add(string2);
        long l = 0L;
        do {
            object3 = (String)stack.pop();
            object2 = null;
            do {
                if (object2 == null) {
                    object = new ListObjectsRequest().withBucketName(string).withDelimiter(DEFAULT_DELIMITER).withPrefix((String)object3);
                    object2 = this.cos.listObjects((ListObjectsRequest)object);
                } else {
                    object2 = this.cos.listNextBatchOfObjects((ObjectListing)object2);
                }
                for (COSObjectSummary serializable2 : ((ObjectListing)object2).getObjectSummaries()) {
                    if (!serializable2.getKey().equals(object3) && !((ObjectListing)object2).getCommonPrefixes().contains(serializable2.getKey() + DEFAULT_DELIMITER)) {
                        linkedList.add(serializable2);
                        l += serializable2.getSize();
                        continue;
                    }
                    log.debug("Skipping download for object " + serializable2.getKey() + " since it is also a virtual directory");
                }
                stack.addAll(((ObjectListing)object2).getCommonPrefixes());
            } while (((ObjectListing)object2).isTruncated());
        } while (!stack.isEmpty());
        object3 = new ProgressListenerChain(new ProgressListener[0]);
        object2 = new TransferProgress();
        ((TransferProgress)object2).setTotalBytesToTransfer(l);
        object = new MultipleFileTransferProgressUpdatingListener((TransferProgress)object2, (ProgressListenerChain)object3);
        ArrayList<DownloadImpl> arrayList = new ArrayList<DownloadImpl>();
        String string3 = "Downloading from " + string + DEFAULT_DELIMITER + string2;
        MultipleFileDownloadImpl multipleFileDownloadImpl = new MultipleFileDownloadImpl(string3, (TransferProgress)object2, (ProgressListenerChain)object3, string2, string, arrayList);
        multipleFileDownloadImpl.setMonitor(new MultipleFileTransferMonitor(multipleFileDownloadImpl, arrayList));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        MultipleFileTransferStateChangeListener multipleFileTransferStateChangeListener = new MultipleFileTransferStateChangeListener(countDownLatch, multipleFileDownloadImpl);
        for (COSObjectSummary cOSObjectSummary : linkedList) {
            File file2 = new File(file, cOSObjectSummary.getKey());
            File file3 = file2.getParentFile();
            if (file3 == null || !file3.exists() && !file3.mkdirs()) {
                throw new RuntimeException("Couldn't create parent directories for " + file2.getAbsolutePath());
            }
            arrayList.add((DownloadImpl)this.doDownload((GetObjectRequest)new GetObjectRequest(cOSObjectSummary.getBucketName(), cOSObjectSummary.getKey()).withGeneralProgressListener((ProgressListener)object), file2, multipleFileTransferStateChangeListener, null, false));
        }
        if (arrayList.isEmpty()) {
            multipleFileDownloadImpl.setState(Transfer.TransferState.Completed);
            return multipleFileDownloadImpl;
        }
        countDownLatch.countDown();
        return multipleFileDownloadImpl;
    }

    public MultipleFileUpload uploadDirectory(String string, String string2, File file, boolean bl) {
        return this.uploadDirectory(string, string2, file, bl, null);
    }

    public MultipleFileUpload uploadDirectory(String string, String string2, File file, boolean bl, ObjectMetadataProvider objectMetadataProvider) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Must provide a directory to upload");
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        this.listFiles(file, linkedList, bl);
        return this.uploadFileList(string, string2, file, linkedList, objectMetadataProvider);
    }

    public MultipleFileUpload uploadFileList(String string, String string2, File file, List<File> list) {
        return this.uploadFileList(string, string2, file, list, null);
    }

    public MultipleFileUpload uploadFileList(String string, String string2, File file, List<File> list, ObjectMetadataProvider objectMetadataProvider) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Must provide a common base directory for uploaded files");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        } else if (!string2.endsWith(DEFAULT_DELIMITER)) {
            string2 = string2 + DEFAULT_DELIMITER;
        }
        ProgressListenerChain progressListenerChain = new ProgressListenerChain(new ProgressListener[0]);
        TransferProgress transferProgress = new TransferProgress();
        MultipleFileTransferProgressUpdatingListener multipleFileTransferProgressUpdatingListener = new MultipleFileTransferProgressUpdatingListener(transferProgress, progressListenerChain);
        LinkedList<UploadImpl> linkedList = new LinkedList<UploadImpl>();
        MultipleFileUploadImpl multipleFileUploadImpl = new MultipleFileUploadImpl("Uploading etc", transferProgress, progressListenerChain, string2, string, linkedList);
        multipleFileUploadImpl.setMonitor(new MultipleFileTransferMonitor(multipleFileUploadImpl, linkedList));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        MultipleFileTransferStateChangeListener multipleFileTransferStateChangeListener = new MultipleFileTransferStateChangeListener(countDownLatch, multipleFileUploadImpl);
        if (list == null || list.isEmpty()) {
            multipleFileUploadImpl.setState(Transfer.TransferState.Completed);
        } else {
            int n = file.getAbsolutePath().length();
            if (!file.getAbsolutePath().endsWith(File.separator)) {
                ++n;
            }
            long l = 0L;
            for (File file2 : list) {
                if (!file2.isFile()) continue;
                l += file2.length();
                String string3 = file2.getAbsolutePath().substring(n).replaceAll("\\\\", DEFAULT_DELIMITER);
                ObjectMetadata objectMetadata = new ObjectMetadata();
                if (objectMetadataProvider != null) {
                    objectMetadataProvider.provideObjectMetadata(file2, objectMetadata);
                }
                linkedList.add((UploadImpl)this.doUpload((PutObjectRequest)new PutObjectRequest(string, string2 + string3, file2).withMetadata(objectMetadata).withGeneralProgressListener(multipleFileTransferProgressUpdatingListener), multipleFileTransferStateChangeListener, null, null));
            }
            transferProgress.setTotalBytesToTransfer(l);
        }
        countDownLatch.countDown();
        return multipleFileUploadImpl;
    }

    private void listFiles(File file, List<File> list, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    if (!bl) continue;
                    this.listFiles(file2, list, bl);
                    continue;
                }
                list.add(file2);
            }
        }
    }

    public void abortMultipartUploads(String string, Date date) throws CosServiceException, CosClientException {
        Object object;
        MultipartUploadListing multipartUploadListing = this.cos.listMultipartUploads(TransferManager.appendSingleObjectUserAgent(new ListMultipartUploadsRequest(string)));
        do {
            object = multipartUploadListing.getMultipartUploads().iterator();
            while (object.hasNext()) {
                MultipartUpload multipartUpload = object.next();
                if (multipartUpload.getInitiated().compareTo(date) >= 0) continue;
                this.cos.abortMultipartUpload(TransferManager.appendSingleObjectUserAgent(new AbortMultipartUploadRequest(string, multipartUpload.getKey(), multipartUpload.getUploadId())));
            }
        } while ((multipartUploadListing = this.cos.listMultipartUploads((ListMultipartUploadsRequest)TransferManager.appendSingleObjectUserAgent(object = new ListMultipartUploadsRequest(string).withUploadIdMarker(multipartUploadListing.getNextUploadIdMarker()).withKeyMarker(multipartUploadListing.getNextKeyMarker())))).isTruncated());
    }

    public MultipleImageAuditingImpl batchPostImageAuditing(List<ImageAuditingRequest> list) {
        String string = "Send image auditing jobs in bulk";
        TransferProgress transferProgress = new TransferProgress();
        ArrayList<ImageAuditingImpl> arrayList = new ArrayList<ImageAuditingImpl>();
        MultipleImageAuditingImpl multipleImageAuditingImpl = new MultipleImageAuditingImpl(string, transferProgress, arrayList);
        multipleImageAuditingImpl.setMonitor(new MultipleFileTransferMonitor(multipleImageAuditingImpl, arrayList));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        MultipleFileTransferStateChangeListener multipleFileTransferStateChangeListener = new MultipleFileTransferStateChangeListener(countDownLatch, multipleImageAuditingImpl);
        for (ImageAuditingRequest imageAuditingRequest : list) {
            arrayList.add(this.doImageAuditing(imageAuditingRequest, multipleFileTransferStateChangeListener));
        }
        countDownLatch.countDown();
        return multipleImageAuditingImpl;
    }

    private ImageAuditingImpl doImageAuditing(ImageAuditingRequest imageAuditingRequest, MultipleFileTransferStateChangeListener multipleFileTransferStateChangeListener) {
        TransferManager.appendImageAuditingUserAgent(imageAuditingRequest);
        String string = "send image auditing job ";
        TransferProgress transferProgress = new TransferProgress();
        COSProgressListenerChain cOSProgressListenerChain = new COSProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), imageAuditingRequest.getGeneralProgressListener());
        ImageAuditingImpl imageAuditingImpl = new ImageAuditingImpl(string, transferProgress, cOSProgressListenerChain, multipleFileTransferStateChangeListener, imageAuditingRequest);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Future<ImageAuditingResponse> future = this.threadPool.submit(new ImageAuditingCallable(this.cos, countDownLatch, imageAuditingRequest, imageAuditingImpl));
        imageAuditingImpl.setMonitor(new ImageAuditingMonitor(imageAuditingImpl, future));
        countDownLatch.countDown();
        return imageAuditingImpl;
    }

    public void shutdownNow() {
        this.shutdownNow(true);
    }

    public void shutdownNow(boolean bl) {
        if (this.shutDownThreadPools) {
            this.threadPool.shutdownNow();
            this.timedThreadPool.shutdownNow();
        }
        if (bl && this.cos instanceof COSClient) {
            ((COSClient)this.cos).shutdown();
        }
    }

    private void shutdownThreadPools() {
        if (this.shutDownThreadPools) {
            this.threadPool.shutdown();
            this.timedThreadPool.shutdown();
        }
    }

    public static <X extends CosServiceRequest> X appendSingleObjectUserAgent(X x) {
        x.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return x;
    }

    public static <X extends CosServiceRequest> X appendMultipartUserAgent(X x) {
        x.getRequestClientOptions().appendUserAgent(USER_AGENT_MULTIPART);
        return x;
    }

    public static <X extends CosServiceRequest> X appendImageAuditingUserAgent(X x) {
        x.getRequestClientOptions().appendUserAgent(USER_AGENT_MULTIPART);
        return x;
    }

    public Upload resumeUpload(PersistableUpload persistableUpload) {
        this.assertParameterNotNull(persistableUpload, "PauseUpload is mandatory to resume a upload.");
        this.configuration.setMinimumUploadPartSize(persistableUpload.getPartSize());
        this.configuration.setMultipartUploadThreshold(persistableUpload.getMutlipartUploadThreshold());
        return this.doUpload(new PutObjectRequest(persistableUpload.getBucketName(), persistableUpload.getKey(), new File(persistableUpload.getFile())), null, null, persistableUpload);
    }

    public Download resumeDownload(PersistableDownload persistableDownload) {
        this.assertParameterNotNull(persistableDownload, "PausedDownload is mandatory to resume a download.");
        GetObjectRequest getObjectRequest = new GetObjectRequest(persistableDownload.getBucketName(), persistableDownload.getKey(), persistableDownload.getVersionId());
        if (persistableDownload.getRange() != null && persistableDownload.getRange().length == 2) {
            long[] lArray = persistableDownload.getRange();
            getObjectRequest.setRange(lArray[0], lArray[1]);
        }
        getObjectRequest.setResponseHeaders(persistableDownload.getResponseHeaders());
        return this.doDownload(getObjectRequest, new File(persistableDownload.getFile()), null, null, true);
    }

    public Copy copy(String string, String string2, String string3, String string4) throws CosServiceException, CosClientException {
        return this.copy(new CopyObjectRequest(string, string2, string3, string4));
    }

    public Copy copy(CopyObjectRequest copyObjectRequest) {
        return this.copy(copyObjectRequest, null);
    }

    public Copy copy(CopyObjectRequest copyObjectRequest, TransferStateChangeListener transferStateChangeListener) throws CosClientException, CosServiceException {
        return this.copy(copyObjectRequest, this.cos, transferStateChangeListener);
    }

    public Copy copy(CopyObjectRequest copyObjectRequest, COS cOS, TransferStateChangeListener transferStateChangeListener) throws CosServiceException, CosClientException {
        TransferManager.appendSingleObjectUserAgent(copyObjectRequest);
        this.assertParameterNotNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when a copy request is initiated.");
        this.assertParameterNotNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when a copy request is initiated.");
        this.assertParameterNotNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when a copy request is initiated.");
        this.assertParameterNotNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when a copy request is initiated.");
        this.assertParameterNotNull(cOS, "The srcCOS parameter is mandatory");
        String string = "Copying object from " + copyObjectRequest.getSourceBucketName() + DEFAULT_DELIMITER + copyObjectRequest.getSourceKey() + " to " + copyObjectRequest.getDestinationBucketName() + DEFAULT_DELIMITER + copyObjectRequest.getDestinationKey();
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(copyObjectRequest.getSourceBucketName(), copyObjectRequest.getSourceKey()).withVersionId(copyObjectRequest.getSourceVersionId());
        ObjectMetadata objectMetadata = cOS.getObjectMetadata(getObjectMetadataRequest);
        TransferProgress transferProgress = new TransferProgress();
        transferProgress.setTotalBytesToTransfer(objectMetadata.getContentLength());
        ProgressListenerChain progressListenerChain = new ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress));
        CopyImpl copyImpl = new CopyImpl(string, transferProgress, progressListenerChain, transferStateChangeListener);
        CopyCallable copyCallable = new CopyCallable(this, this.threadPool, copyImpl, copyObjectRequest, objectMetadata, progressListenerChain);
        CopyMonitor copyMonitor = CopyMonitor.create(this, copyImpl, this.threadPool, copyCallable, copyObjectRequest, progressListenerChain);
        copyImpl.setMonitor(copyMonitor);
        return copyImpl;
    }

    private void assertParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdownThreadPools();
    }
}

