/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.model.COSObjectIdBuilder;
import com.qcloud.cos.model.InstructionFileId;
import java.io.Serializable;

public class COSObjectId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String key;
    private final String versionId;

    public COSObjectId(String string, String string2) {
        this(string, string2, null);
    }

    public COSObjectId(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("bucket and key must be specified");
        }
        this.bucket = string;
        this.key = string2;
        this.versionId = string3;
    }

    public COSObjectId(COSObjectIdBuilder cOSObjectIdBuilder) {
        this.bucket = cOSObjectIdBuilder.getBucket();
        this.key = cOSObjectIdBuilder.getKey();
        this.versionId = cOSObjectIdBuilder.getVersionId();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public InstructionFileId instructionFileId() {
        return this.instructionFileId(null);
    }

    public InstructionFileId instructionFileId(String string) {
        String string2 = this.key + ".";
        string2 = string2 + (string == null || string.trim().length() == 0 ? "instruction" : string);
        return new InstructionFileId(this.bucket, string2, this.versionId);
    }

    public String toString() {
        return "bucket: " + this.bucket + ", key: " + this.key + ", versionId: " + this.versionId;
    }
}

