/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.Grant;
import com.qcloud.cos.model.Grantee;
import com.qcloud.cos.model.GroupGrantee;
import com.qcloud.cos.model.Owner;
import com.qcloud.cos.model.Permission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AccessControlList
implements Serializable {
    private static final long serialVersionUID = 8095040648034788376L;
    private Set<Grant> grantSet;
    private List<Grant> grantList;
    private Owner owner = null;
    private boolean existDefaultAcl;

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void grantPermission(Grantee grantee, Permission permission) {
        this.getGrantsAsList().add(new Grant(grantee, permission));
    }

    public void grantAllPermissions(Grant ... grantArray) {
        for (Grant grant : grantArray) {
            this.grantPermission(grant.getGrantee(), grant.getPermission());
        }
    }

    public void revokeAllPermissions(Grantee grantee) {
        ArrayList<Grant> arrayList = new ArrayList<Grant>();
        List<Grant> list = this.getGrantsAsList();
        for (Grant grant : list) {
            if (!grant.getGrantee().equals(grantee)) continue;
            arrayList.add(grant);
        }
        this.grantList.removeAll(arrayList);
    }

    @Deprecated
    public Set<Grant> getGrants() {
        this.checkState();
        if (this.grantSet == null) {
            if (this.grantList == null) {
                this.grantSet = new HashSet<Grant>();
            } else {
                this.grantSet = new HashSet<Grant>(this.grantList);
                this.grantList = null;
            }
        }
        return this.grantSet;
    }

    private void checkState() {
        if (this.grantList != null && this.grantSet != null) {
            throw new IllegalStateException("Both grant set and grant list cannot be null");
        }
    }

    public List<Grant> getGrantsAsList() {
        this.checkState();
        if (this.grantList == null) {
            if (this.grantSet == null) {
                this.grantList = new LinkedList<Grant>();
            } else {
                this.grantList = new LinkedList<Grant>(this.grantSet);
                this.grantSet = null;
            }
        }
        return this.grantList;
    }

    public String toString() {
        return "AccessControlList [owner=" + this.owner + ", grants=" + this.getGrantsAsList() + "]";
    }

    private boolean isAllUsersGrantee(Grantee grantee) {
        String string = grantee.getIdentifier();
        return grantee.equals(GroupGrantee.AllUsers) || string != null && string.equals("qcs::cam::anyone:anyone");
    }

    public CannedAccessControlList getCannedAccessControl() {
        if (this.grantList == null) {
            return null;
        }
        if (this.existDefaultAcl) {
            return CannedAccessControlList.Default;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Grant grant : this.grantList) {
            Grantee grantee = grant.getGrantee();
            Permission permission = grant.getPermission();
            if (grantee == null || permission == null || !this.isAllUsersGrantee(grantee)) continue;
            if (permission.equals((Object)Permission.Read)) {
                bl = true;
            }
            if (!permission.equals((Object)Permission.Write)) continue;
            bl2 = true;
        }
        if (bl && bl2) {
            return CannedAccessControlList.PublicReadWrite;
        }
        if (bl) {
            return CannedAccessControlList.PublicRead;
        }
        return CannedAccessControlList.Private;
    }

    public boolean isExistDefaultAcl() {
        return this.existDefaultAcl;
    }

    public void setExistDefaultAcl(boolean bl) {
        this.existDefaultAcl = bl;
    }
}

