/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadPartRequest;

public class SkipMd5CheckStrategy {
    public static final String DISABLE_GET_OBJECT_MD5_VALIDATION_PROPERTY = "com.Qcloud.services.cos.disableGetObjectMD5Validation";
    public static final String DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY = "com.Qcloud.services.cos.disablePutObjectMD5Validation";
    public static final SkipMd5CheckStrategy INSTANCE = new SkipMd5CheckStrategy();

    private SkipMd5CheckStrategy() {
    }

    public boolean skipClientSideValidationPerGetResponse(ObjectMetadata objectMetadata) {
        if (this.isGetObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.skipClientSideValidationPerResponse(objectMetadata);
    }

    public boolean skipClientSideValidationPerPutResponse(ObjectMetadata objectMetadata) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.skipClientSideValidationPerResponse(objectMetadata);
    }

    public boolean skipClientSideValidationPerUploadPartResponse(ObjectMetadata objectMetadata) {
        return this.skipClientSideValidationPerPutResponse(objectMetadata);
    }

    public boolean skipClientSideValidation(GetObjectRequest getObjectRequest, ObjectMetadata objectMetadata) {
        return this.skipClientSideValidationPerRequest(getObjectRequest) || this.skipClientSideValidationPerGetResponse(objectMetadata);
    }

    public boolean skipClientSideValidationPerRequest(PutObjectRequest putObjectRequest) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.putRequestInvolvesSse(putObjectRequest) || this.metadataInvolvesSse(putObjectRequest.getMetadata());
    }

    public boolean skipClientSideValidationPerRequest(UploadPartRequest uploadPartRequest) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return uploadPartRequest.getSSECustomerKey() != null;
    }

    public boolean skipServerSideValidation(PutObjectRequest putObjectRequest) {
        return this.isPutObjectMd5ValidationDisabledByProperty();
    }

    public boolean skipClientSideValidationPerRequest(GetObjectRequest getObjectRequest) {
        if (this.isGetObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return getObjectRequest.getRange() != null;
    }

    private boolean skipClientSideValidationPerResponse(ObjectMetadata objectMetadata) {
        if (objectMetadata == null) {
            return true;
        }
        return objectMetadata.getETag() == null || SkipMd5CheckStrategy.isMultipartUploadETag(objectMetadata.getETag()) || SkipMd5CheckStrategy.isV4ETag(objectMetadata.getETag()) || this.isSSECustomerResponse(objectMetadata);
    }

    private boolean isSSECustomerResponse(ObjectMetadata objectMetadata) {
        return null != objectMetadata.getSSECustomerAlgorithm() && null != objectMetadata.getSSECustomerKeyMd5();
    }

    private boolean isGetObjectMd5ValidationDisabledByProperty() {
        String string = System.getProperty(DISABLE_GET_OBJECT_MD5_VALIDATION_PROPERTY);
        return string == null || !string.equalsIgnoreCase("false");
    }

    private boolean isPutObjectMd5ValidationDisabledByProperty() {
        String string = System.getProperty(DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY);
        return string != null && !string.equalsIgnoreCase("false");
    }

    private boolean metadataInvolvesSse(ObjectMetadata objectMetadata) {
        if (objectMetadata == null) {
            return false;
        }
        return SkipMd5CheckStrategy.containsNonNull(objectMetadata.getSSECustomerAlgorithm(), objectMetadata.getSSECustomerKeyMd5(), objectMetadata.getSSECOSKmsKeyId());
    }

    private boolean putRequestInvolvesSse(PutObjectRequest putObjectRequest) {
        return SkipMd5CheckStrategy.containsNonNull(putObjectRequest.getSSECustomerKey(), putObjectRequest.getSSECOSKeyManagementParams());
    }

    private static boolean isMultipartUploadETag(String string) {
        return string.contains("-");
    }

    private static boolean isV4ETag(String string) {
        return string.length() != 32;
    }

    private static boolean containsNonNull(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object == null) continue;
            return true;
        }
        return false;
    }
}

