/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import java.util.EnumMap;

public final class RequestClientOptions {
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 131073;
    private final EnumMap<Marker, String> markers = new EnumMap(Marker.class);
    private int readLimit = 131073;

    public String getClientMarker(Marker marker) {
        return this.markers.get((Object)marker);
    }

    public void putClientMarker(Marker marker, String string) {
        this.markers.put(marker, string);
    }

    public void appendUserAgent(String string) {
        String string2 = this.markers.get((Object)Marker.USER_AGENT);
        if (string2 == null) {
            string2 = "";
        }
        string2 = this.createUserAgentMarkerString(string2, string);
        this.putClientMarker(Marker.USER_AGENT, string2);
    }

    private String createUserAgentMarkerString(String string, String string2) {
        return string.contains(string2) ? string : string + " " + string2;
    }

    public final int getReadLimit() {
        return this.readLimit;
    }

    public final void setReadLimit(int n) {
        this.readLimit = n;
    }

    void copyTo(RequestClientOptions requestClientOptions) {
        requestClientOptions.setReadLimit(this.getReadLimit());
        for (Marker marker : Marker.values()) {
            requestClientOptions.putClientMarker(marker, this.getClientMarker(marker));
        }
    }

    public static enum Marker {
        USER_AGENT;

    }
}

