/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LengthCheckInputStream
extends SdkFilterInputStream {
    public static final boolean INCLUDE_SKIPPED_BYTES = true;
    public static final boolean EXCLUDE_SKIPPED_BYTES = false;
    private final long expectedLength;
    private final boolean includeSkipped;
    private long dataLength;
    private long marked;
    private boolean resetSinceLastMarked;
    private int markCount;
    private int resetCount;

    public LengthCheckInputStream(InputStream inputStream2, long l, boolean bl) {
        super(inputStream2);
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.expectedLength = l;
        this.includeSkipped = bl;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n >= 0) {
            ++this.dataLength;
        }
        this.checkLength(n == -1);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        this.dataLength += n3 >= 0 ? (long)n3 : 0L;
        this.checkLength(n3 == -1);
        return n3;
    }

    @Override
    public void mark(int n) {
        if (this.markSupported()) {
            super.mark(n);
            this.marked = this.dataLength;
            ++this.markCount;
            this.resetSinceLastMarked = false;
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.markSupported()) {
            super.reset();
            this.dataLength = this.marked;
            ++this.resetCount;
        } else {
            throw new IOException("mark/reset not supported");
        }
        this.resetSinceLastMarked = true;
    }

    private void checkLength(boolean bl) {
        if (bl) {
            if (this.dataLength != this.expectedLength) {
                throw new CosClientException("Data read has a different length than the expected: " + this.diagnosticInfo());
            }
        } else if (this.dataLength > this.expectedLength) {
            throw new CosClientException("More data read than expected: " + this.diagnosticInfo());
        }
    }

    private String diagnosticInfo() {
        return "dataLength=" + this.dataLength + "; expectedLength=" + this.expectedLength + "; includeSkipped=" + this.includeSkipped + "; in.getClass()=" + this.in.getClass() + "; markedSupported=" + this.markSupported() + "; marked=" + this.marked + "; resetSinceLastMarked=" + this.resetSinceLastMarked + "; markCount=" + this.markCount + "; resetCount=" + this.resetCount;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if (this.includeSkipped && l2 > 0L) {
            this.dataLength += l2;
            this.checkLength(false);
        }
        return l2;
    }
}

