/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.internal.ReadLimitInfo;
import com.qcloud.cos.internal.RequestClientOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CosServiceRequest
implements ReadLimitInfo,
Cloneable {
    private COSCredentials cosCredentials;
    private ProgressListener progressListener = ProgressListener.NOOP;
    private String fixedEndpointAddr;
    private Map<String, String> customRequestHeaders;
    private Map<String, List<String>> customQueryParameters;
    private final RequestClientOptions requestClientOptions = new RequestClientOptions();
    private CosServiceRequest cloneSource;
    private String ciSpecialEndParameter;

    public void setGeneralProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener == null ? ProgressListener.NOOP : progressListener;
    }

    public ProgressListener getGeneralProgressListener() {
        return this.progressListener;
    }

    public void setFixedEndpointAddr(String string) {
        this.fixedEndpointAddr = string;
    }

    public String getFixedEndpointAddr() {
        return this.fixedEndpointAddr;
    }

    public <T extends CosServiceRequest> T withGeneralProgressListener(ProgressListener progressListener) {
        this.setGeneralProgressListener(progressListener);
        CosServiceRequest cosServiceRequest = this;
        return (T)cosServiceRequest;
    }

    public Map<String, String> getCustomRequestHeaders() {
        if (this.customRequestHeaders == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customRequestHeaders);
    }

    public String putCustomRequestHeader(String string, String string2) {
        if (this.customRequestHeaders == null) {
            this.customRequestHeaders = new HashMap<String, String>();
        }
        if (string == null) {
            throw new IllegalArgumentException("custom header key cann't be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("custom header value cann't be null");
        }
        return this.customRequestHeaders.put(string, string2);
    }

    public Map<String, List<String>> getCustomQueryParameters() {
        if (this.customQueryParameters == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customQueryParameters);
    }

    public void putCustomQueryParameter(String string, String string2) {
        List<String> list;
        if (this.customQueryParameters == null) {
            this.customQueryParameters = new HashMap<String, List<String>>();
        }
        if ((list = this.customQueryParameters.get(string)) == null) {
            list = new LinkedList<String>();
            this.customQueryParameters.put(string, list);
        }
        list.add(string2);
    }

    public RequestClientOptions getRequestClientOptions() {
        return this.requestClientOptions;
    }

    protected final <T extends CosServiceRequest> T copyBaseTo(T t2) {
        if (this.customRequestHeaders != null) {
            for (Map.Entry<String, Object> entry : this.customRequestHeaders.entrySet()) {
                t2.putCustomRequestHeader(entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.customQueryParameters != null) {
            for (Map.Entry<String, Object> entry : this.customQueryParameters.entrySet()) {
                if (entry.getValue() == null) continue;
                for (String string : (List)entry.getValue()) {
                    t2.putCustomQueryParameter(entry.getKey(), string);
                }
            }
        }
        t2.setGeneralProgressListener(this.progressListener);
        this.requestClientOptions.copyTo(t2.getRequestClientOptions());
        return t2;
    }

    @Override
    public int getReadLimit() {
        return this.requestClientOptions.getReadLimit();
    }

    public CosServiceRequest getCloneSource() {
        return this.cloneSource;
    }

    public CosServiceRequest getCloneRoot() {
        CosServiceRequest cosServiceRequest = this.cloneSource;
        if (cosServiceRequest != null) {
            while (cosServiceRequest.getCloneSource() != null) {
                cosServiceRequest = cosServiceRequest.getCloneSource();
            }
        }
        return cosServiceRequest;
    }

    private void setCloneSource(CosServiceRequest cosServiceRequest) {
        this.cloneSource = cosServiceRequest;
    }

    public CosServiceRequest clone() {
        try {
            CosServiceRequest cosServiceRequest = (CosServiceRequest)super.clone();
            cosServiceRequest.setCloneSource(this);
            return cosServiceRequest;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }

    public COSCredentials getCosCredentials() {
        return this.cosCredentials;
    }

    public void setCosCredentials(COSCredentials cOSCredentials) {
        this.cosCredentials = cOSCredentials;
    }

    public String getCiSpecialEndParameter() {
        return this.ciSpecialEndParameter;
    }

    public void setCiSpecialEndParameter(String string) {
        this.ciSpecialEndParameter = string;
    }
}

