/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.internal.AbstractCosResponseHandler;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.Unmarshaller;
import com.qcloud.cos.model.BucketDomainConfiguration;
import com.qcloud.cos.model.CiServiceResult;
import com.qcloud.cos.model.CosServiceResult;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSXmlResponseHandler<T>
extends AbstractCosResponseHandler<T> {
    private Unmarshaller<T, InputStream> responseUnmarshaller;
    private static final Logger log = LoggerFactory.getLogger(COSXmlResponseHandler.class);
    private Map<String, String> responseHeaders;

    public COSXmlResponseHandler(Unmarshaller<T, InputStream> unmarshaller) {
        this.responseUnmarshaller = unmarshaller;
    }

    @Override
    public CosServiceResponse<T> handle(CosHttpResponse cosHttpResponse) throws Exception {
        CosServiceResponse<T> cosServiceResponse = this.parseResponseMetadata(cosHttpResponse);
        this.responseHeaders = cosHttpResponse.getHeaders();
        if (this.responseUnmarshaller != null) {
            log.trace("Beginning to parse service response XML");
            T t2 = this.responseUnmarshaller.unmarshall(cosHttpResponse.getContent());
            if (t2 instanceof BucketDomainConfiguration && this.responseHeaders.containsKey("x-cos-domain-txt-verification")) {
                ((BucketDomainConfiguration)t2).setDomainTxtVerification(this.responseHeaders.get("x-cos-domain-txt-verification"));
            }
            log.trace("Done parsing service response XML");
            cosServiceResponse.setResult(t2);
        }
        if (cosServiceResponse.getResult() != null && cosServiceResponse.getResult() instanceof CosServiceResult) {
            ((CosServiceResult)cosServiceResponse.getResult()).setRequestId(this.responseHeaders.get("x-cos-request-id"));
        }
        if (cosServiceResponse.getResult() != null && cosServiceResponse.getResult() instanceof CiServiceResult) {
            ((CiServiceResult)cosServiceResponse.getResult()).setRequestId(this.responseHeaders.get("x-ci-request-id"));
        }
        return cosServiceResponse;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

