/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.internal.CosServiceRequest;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class CosHttpRequest<T extends CosServiceRequest> {
    private String resourcePath;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpProtocol protocol;
    private String endpoint;
    private HttpMethodName httpMethod = HttpMethodName.POST;
    private InputStream content;
    private T originRequest;
    private ProgressListener progressListener;
    private String ciSpecialEndParameter;

    public CosHttpRequest(T t2) {
        this.originRequest = t2;
        this.ciSpecialEndParameter = ((CosServiceRequest)t2).getCiSpecialEndParameter();
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setResourcePath(String string) {
        this.resourcePath = string;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void addParameter(String string, String string2) {
        this.parameters.put(string, string2);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public CosHttpRequest<T> withParameter(String string, String string2) {
        this.addParameter(string, string2);
        return this;
    }

    public HttpProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(HttpProtocol httpProtocol) {
        this.protocol = httpProtocol;
    }

    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethodName httpMethodName) {
        this.httpMethod = httpMethodName;
    }

    public void setEndpoint(String string) {
        this.endpoint = string;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers.clear();
        this.headers.putAll(map);
    }

    public void setParameters(Map<String, String> map) {
        this.parameters.clear();
        this.parameters.putAll(map);
    }

    public InputStream getContent() {
        return this.content;
    }

    public void setContent(InputStream inputStream2) {
        this.content = inputStream2;
    }

    public T getOriginalRequest() {
        return this.originRequest;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public String getCiSpecialEndParameter() {
        return this.ciSpecialEndParameter;
    }

    public void setCiSpecialEndParameter(String string) {
        this.ciSpecialEndParameter = string;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("endpoint: ").append(this.endpoint).append(", resourcepath: ").append(this.resourcePath).append(", httpMethod: ").append((Object)this.httpMethod);
        stringBuilder.append(", headers { ");
        for (String string2 : this.headers.keySet()) {
            string = this.headers.get(string2);
            stringBuilder.append(string2).append(" : ").append(string).append(", ");
        }
        stringBuilder.append("}, params: { ");
        for (String string2 : this.parameters.keySet()) {
            string = this.parameters.get(string2);
            stringBuilder.append(string2).append(" : ").append(string).append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

