/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.event;

import com.qcloud.cos.event.DeliveryMode;
import com.qcloud.cos.event.ProgressEvent;
import com.qcloud.cos.event.ProgressEventFilter;
import com.qcloud.cos.event.ProgressListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressListenerChain
implements DeliveryMode,
ProgressListener {
    private static final Logger log = LoggerFactory.getLogger(ProgressListenerChain.class);
    private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private final ProgressEventFilter progressEventFilter;
    private volatile boolean syncCallSafe = true;

    public ProgressListenerChain(ProgressListener ... progressListenerArray) {
        this((ProgressEventFilter)null, progressListenerArray);
    }

    public ProgressListenerChain(ProgressEventFilter progressEventFilter, ProgressListener ... progressListenerArray) {
        if (progressListenerArray == null) {
            throw new IllegalArgumentException("Progress Listeners cannot be null.");
        }
        for (ProgressListener progressListener : progressListenerArray) {
            this.addProgressListener(progressListener);
        }
        this.progressEventFilter = progressEventFilter;
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        if (progressListener == null) {
            return;
        }
        if (this.syncCallSafe) {
            this.syncCallSafe = DeliveryMode.Check.isSyncCallSafe(progressListener);
        }
        this.listeners.add(progressListener);
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (progressListener == null) {
            return;
        }
        this.listeners.remove(progressListener);
    }

    protected List<ProgressListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void progressChanged(ProgressEvent progressEvent) {
        ProgressEvent progressEvent2 = progressEvent;
        if (this.progressEventFilter != null && (progressEvent2 = this.progressEventFilter.filter(progressEvent)) == null) {
            return;
        }
        for (ProgressListener progressListener : this.listeners) {
            try {
                progressListener.progressChanged(progressEvent2);
            }
            catch (RuntimeException runtimeException) {
                log.warn("Couldn't update progress listener", runtimeException);
            }
        }
    }

    @Override
    public boolean isSyncCallSafe() {
        return this.syncCallSafe;
    }
}

