/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.ColorEnhance;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.SuperResolution;
import com.qcloud.cos.model.ciModel.job.VideoEnhance;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.utils.Jackson;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class VideoEnhanceJobDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        VideoEnhanceJobDemo.createMediaJobs(cOSClient);
    }

    public static void createMediaJobs(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890");
        mediaJobsRequest.setTag("VideoEnhance");
        mediaJobsRequest.getInput().setObject("1.mp4");
        VideoEnhance videoEnhance = mediaJobsRequest.getOperation().getVideoEnhance();
        MediaTranscodeObject mediaTranscodeObject = videoEnhance.getTrascode();
        MediaContainerObject mediaContainerObject = mediaTranscodeObject.getContainer();
        mediaContainerObject.setFormat("mp4");
        MediaTranscodeVideoObject mediaTranscodeVideoObject = mediaTranscodeObject.getVideo();
        mediaTranscodeVideoObject.setCodec("H.264");
        mediaTranscodeVideoObject.setBitrate("1000");
        mediaTranscodeVideoObject.setWidth("1280");
        mediaTranscodeVideoObject.setFps("30");
        MediaAudioObject mediaAudioObject = mediaTranscodeObject.getAudio();
        mediaAudioObject.setCodec("aac");
        mediaAudioObject.setSamplerate("44100");
        mediaAudioObject.setBitrate("128");
        mediaAudioObject.setChannels("4");
        SuperResolution superResolution = videoEnhance.getSuperResolution();
        superResolution.setResolution("sdtohd");
        superResolution.setEnableScaleUp("true");
        superResolution.setVersion("Enhance");
        ColorEnhance colorEnhance = videoEnhance.getColorEnhance();
        colorEnhance.setContrast("50");
        colorEnhance.setCorrection("100");
        colorEnhance.setSaturation("100");
        videoEnhance.getMsSharpen().setSharpenLevel("5");
        videoEnhance.getSdrToHDR().setHdrMode("HDR10");
        videoEnhance.getFrameEnhance().setFrameDoubling("true");
        mediaJobsRequest.getOperation().getOutput().setBucket("demo-1234567890");
        mediaJobsRequest.getOperation().getOutput().setRegion("ap-chongqing");
        mediaJobsRequest.getOperation().getOutput().setObject("VideoEnhance.mp4");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a52170834");
        mediaJobsRequest.setCallBack("https://cloud.tencent.com/xxx");
        MediaJobResponse mediaJobResponse = cOSClient.createMediaJobs(mediaJobsRequest);
        System.out.println(mediaJobResponse.getJobsDetail().getJobId());
    }

    public static void describeMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890.");
        mediaJobsRequest.setJobId("j5ff9acb6a63f11ed8d022552f0a5c600");
        MediaJobResponse mediaJobResponse = cOSClient.describeMediaJob(mediaJobsRequest);
        VideoEnhance videoEnhance = mediaJobResponse.getJobsDetail().getOperation().getVideoEnhance();
        System.out.println(Jackson.toJsonString(videoEnhance));
    }

    public static void createMediaTemplate(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("demo-1234567890.");
        mediaTemplateRequest.setTag("VideoEnhance");
        mediaTemplateRequest.setName("mark-VideoEnhance");
        VideoEnhance videoEnhance = mediaTemplateRequest.getVideoEnhance();
        MediaTranscodeObject mediaTranscodeObject = videoEnhance.getTrascode();
        MediaContainerObject mediaContainerObject = mediaTranscodeObject.getContainer();
        mediaContainerObject.setFormat("mp4");
        MediaTranscodeVideoObject mediaTranscodeVideoObject = mediaTranscodeObject.getVideo();
        mediaTranscodeVideoObject.setCodec("H.264");
        mediaTranscodeVideoObject.setBitrate("1000");
        mediaTranscodeVideoObject.setWidth("1280");
        mediaTranscodeVideoObject.setFps("30");
        MediaAudioObject mediaAudioObject = mediaTranscodeObject.getAudio();
        mediaAudioObject.setCodec("aac");
        mediaAudioObject.setSamplerate("44100");
        mediaAudioObject.setBitrate("128");
        mediaAudioObject.setChannels("4");
        SuperResolution superResolution = videoEnhance.getSuperResolution();
        superResolution.setResolution("sdtohd");
        superResolution.setEnableScaleUp("true");
        superResolution.setVersion("Enhance");
        ColorEnhance colorEnhance = videoEnhance.getColorEnhance();
        colorEnhance.setContrast("50");
        colorEnhance.setCorrection("100");
        colorEnhance.setSaturation("100");
        videoEnhance.getMsSharpen().setSharpenLevel("5");
        videoEnhance.getSdrToHDR().setHdrMode("HDR10");
        MediaTemplateResponse mediaTemplateResponse = cOSClient.createMediaTemplate(mediaTemplateRequest);
        System.out.println(mediaTemplateResponse);
    }

    public static void describeMediaTemplate(COSClient cOSClient) {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("demo-1234567890.");
        mediaTemplateRequest.setName("mark-VideoEnhance");
        MediaListTemplateResponse mediaListTemplateResponse = cOSClient.describeMediaTemplates(mediaTemplateRequest);
        List<MediaTemplateObject> list = mediaListTemplateResponse.getTemplateList();
        for (MediaTemplateObject mediaTemplateObject : list) {
            System.out.println(Jackson.toJsonString(mediaTemplateObject.getVideoEnhance()));
        }
    }
}

