/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.snapshot.CosSnapshotRequest;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotRequest;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SnapshotDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        SnapshotDemo.getSnapshot(cOSClient);
    }

    public static void getSnapshot(COSClient cOSClient) throws IOException {
        CosSnapshotRequest cosSnapshotRequest = new CosSnapshotRequest();
        cosSnapshotRequest.setBucketName("DemoBucket-123456789");
        cosSnapshotRequest.setObjectKey("1.mp4");
        cosSnapshotRequest.setTime("15");
        cosSnapshotRequest.setFormat("jpg");
        InputStream inputStream2 = null;
        try {
            inputStream2 = cOSClient.getSnapshot(cosSnapshotRequest);
            SnapshotDemo.inputStream2File(inputStream2, new File("1.jpg"));
        }
        finally {
            SnapshotDemo.close(inputStream2);
        }
    }

    public static void generateSnapshot(COSClient cOSClient) {
        SnapshotRequest snapshotRequest = new SnapshotRequest();
        snapshotRequest.setBucketName("DemoBucket-123456789");
        snapshotRequest.getInput().setObject("1.mp4");
        snapshotRequest.getOutput().setBucket("DemoBucket-123456789");
        snapshotRequest.getOutput().setRegion("ap-chongqing");
        snapshotRequest.getOutput().setObject("test/1.jpg");
        snapshotRequest.setTime("15");
        SnapshotResponse snapshotResponse = cOSClient.generateSnapshot(snapshotRequest);
        System.out.println(snapshotResponse);
    }

    private static void inputStream2File(InputStream inputStream2, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream2.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
    }

    private static void close(InputStream inputStream2) {
        try {
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

