/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.model.ciModel.image.GenerateQrcodeRequest;
import com.qcloud.cos.model.ciModel.persistence.CIObject;
import com.qcloud.cos.model.ciModel.persistence.CIUploadResult;
import com.qcloud.cos.model.ciModel.persistence.PicOperations;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import com.qcloud.cos.utils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;

public class QRCodeDemo {
    public static void generateQrcode(COSClient cOSClient) {
        GenerateQrcodeRequest generateQrcodeRequest = new GenerateQrcodeRequest();
        generateQrcodeRequest.setBucketName("examplebucket-1250000000");
        generateQrcodeRequest.setQrcodeContent("\u6570\u636e\u4e07\u8c61");
        generateQrcodeRequest.setWidth("400");
        generateQrcodeRequest.setMode("0");
        String string = cOSClient.generateQrcode(generateQrcodeRequest);
        System.out.println(string);
    }

    public static void identifyQrCodeWithGetObject(COSClient cOSClient) throws IOException {
        String string = "examplebucket-1250000000";
        String string2 = "\u6570\u636e\u4e07\u8c61.png";
        GetObjectRequest getObjectRequest = new GetObjectRequest(string, string2);
        getObjectRequest.putCustomQueryParameter("ci-process", "QRcode");
        getObjectRequest.putCustomQueryParameter("cover", "0");
        COSObject cOSObject = cOSClient.getObject(getObjectRequest);
        COSObjectInputStream cOSObjectInputStream = cOSObject.getObjectContent();
        String string3 = IOUtils.toString(cOSObjectInputStream);
        System.out.println(string3);
    }

    public static void identifyQrCode(COSClient cOSClient) {
        String string = "examplebucket-1250000000";
        String string2 = "qrcode.png";
        File file = new File("E://qrcode.png");
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, file);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> linkedList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule = new PicOperations.Rule();
        rule.setBucket(string);
        rule.setFileId("qrcode-1.png");
        rule.setRule("QRcode/cover/1");
        linkedList.add(rule);
        picOperations.setRules(linkedList);
        putObjectRequest.setPicOperations(picOperations);
        try {
            PutObjectResult putObjectResult = cOSClient.putObject(putObjectRequest);
            CIUploadResult cIUploadResult = putObjectResult.getCiUploadResult();
            System.out.println(putObjectResult.getRequestId());
            System.out.println(cIUploadResult.getOriginalInfo().getEtag());
            for (CIObject cIObject : cIUploadResult.getProcessResults().getObjectList()) {
                System.out.println(cIObject.getLocation());
            }
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
    }

    public static void identifyQrCodeWithMultipart(COSClient cOSClient) throws FileNotFoundException {
        String string = "examplebucket-1250000000";
        String string2 = "qrcode.png";
        File file = new File("E://qrcode.png");
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(string, string2);
        InitiateMultipartUploadResult initiateMultipartUploadResult = cOSClient.initiateMultipartUpload(initiateMultipartUploadRequest);
        String string3 = initiateMultipartUploadResult.getUploadId();
        LinkedList<PartETag> linkedList = new LinkedList<PartETag>();
        UploadPartRequest uploadPartRequest = new UploadPartRequest();
        uploadPartRequest.setBucketName(string);
        uploadPartRequest.setKey(string2);
        uploadPartRequest.setUploadId(string3);
        uploadPartRequest.setInputStream(new FileInputStream(file));
        uploadPartRequest.setPartSize(file.length());
        uploadPartRequest.setPartNumber(1);
        UploadPartResult uploadPartResult = cOSClient.uploadPart(uploadPartRequest);
        PartETag partETag = uploadPartResult.getPartETag();
        linkedList.add(partETag);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> linkedList2 = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule = new PicOperations.Rule();
        rule.setBucket(string);
        rule.setFileId("qrcode-1.png");
        rule.setRule("QRcode/cover/1");
        linkedList2.add(rule);
        picOperations.setRules(linkedList2);
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(string, string2, string3, linkedList);
        completeMultipartUploadRequest.setPicOperations(picOperations);
        CompleteMultipartUploadResult completeMultipartUploadResult = cOSClient.completeMultipartUpload(completeMultipartUploadRequest);
        CIUploadResult cIUploadResult = completeMultipartUploadResult.getCiUploadResult();
        System.out.println(completeMultipartUploadResult.getRequestId());
        System.out.println(cIUploadResult.getOriginalInfo().getEtag());
        for (CIObject cIObject : cIUploadResult.getProcessResults().getObjectList()) {
            System.out.println(cIObject.getLocation());
        }
    }

    public static void identifyQrCodeWithTransferManager(TransferManager transferManager) throws InterruptedException {
        String string = "examplebucket-1250000000";
        String string2 = "qrcode.png";
        File file = new File("E://qrcode.png");
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, file);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> linkedList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule = new PicOperations.Rule();
        rule.setBucket(string);
        rule.setFileId("qrcode-1.png");
        rule.setRule("QRcode/cover/1");
        linkedList.add(rule);
        picOperations.setRules(linkedList);
        putObjectRequest.setPicOperations(picOperations);
        Upload upload = transferManager.upload(putObjectRequest);
        UploadResult uploadResult = upload.waitForUploadResult();
        CIUploadResult cIUploadResult = uploadResult.getCiUploadResult();
        System.out.println(uploadResult.getRequestId());
        System.out.println(cIUploadResult.getOriginalInfo().getEtag());
        for (CIObject cIObject : cIUploadResult.getProcessResults().getObjectList()) {
            System.out.println(cIObject.getLocation());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        cOSClient.shutdown();
    }
}

