/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.ExtractDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ExtractDigitalWatermarkJobDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        ExtractDigitalWatermarkJobDemo.createMediaJobs(cOSClient);
    }

    public static void createMediaJobs(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demobucket-1234567890");
        mediaJobsRequest.setTag("ExtractDigitalWatermark");
        mediaJobsRequest.getInput().setObject("DigitalWatermark.mp4");
        MediaJobOperation mediaJobOperation = mediaJobsRequest.getOperation();
        ExtractDigitalWatermark extractDigitalWatermark = mediaJobOperation.getExtractDigitalWatermark();
        extractDigitalWatermark.setType("Text");
        extractDigitalWatermark.setVersion("V1");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a5217****");
        MediaJobResponse mediaJobResponse = cOSClient.createMediaJobs(mediaJobsRequest);
        System.out.println(mediaJobResponse);
    }

    public static void describeMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demobucket-1234567890");
        mediaJobsRequest.setJobId("j747b787ebbbf11ec86f46b5fdc18f37f");
        MediaJobResponse mediaJobResponse = cOSClient.describeMediaJob(mediaJobsRequest);
        System.out.println(mediaJobResponse);
    }

    public static void describeMediaJobs(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demobucket-1234567890");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a5217****");
        mediaJobsRequest.setTag("ExtractDigitalWatermark");
        MediaListJobResponse mediaListJobResponse = cOSClient.describeMediaJobs(mediaJobsRequest);
        List<MediaJobObject> list = mediaListJobResponse.getJobsDetailList();
        for (MediaJobObject mediaJobObject : list) {
            System.out.println(mediaJobObject);
        }
    }

    public static void cancelMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demobucket-1234567890");
        mediaJobsRequest.setJobId("jfb4039b0bb9e11ecbd2081a7c70******");
        Boolean bl = cOSClient.cancelMediaJob(mediaJobsRequest);
        System.out.println(bl);
    }
}

