/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.CSVInput;
import com.qcloud.cos.model.CSVOutput;
import com.qcloud.cos.model.CompressionType;
import com.qcloud.cos.model.ExpressionType;
import com.qcloud.cos.model.InputSerialization;
import com.qcloud.cos.model.JSONInput;
import com.qcloud.cos.model.JSONOutput;
import com.qcloud.cos.model.JSONType;
import com.qcloud.cos.model.OutputSerialization;
import com.qcloud.cos.model.SelectObjectContentEvent;
import com.qcloud.cos.model.SelectObjectContentEventVisitor;
import com.qcloud.cos.model.SelectObjectContentRequest;
import com.qcloud.cos.model.SelectObjectContentResult;
import com.qcloud.cos.model.SelectRecordsInputStream;
import com.qcloud.cos.region.Region;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;

public class SelectObjectContentDemo {
    public static void main(String[] stringArray) throws Exception {
        SelectObjectContentDemo.selectCsvContentDemo();
        SelectObjectContentDemo.selectJsonContentDemo();
    }

    public static void selectCsvContentDemo() throws Exception {
        String string;
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string2 = "test/my_test.csv";
        String string3 = "mybucket-1251668577";
        String string4 = "HuNan,ChangSha\nSiChuan,ChengDu\nGuiZhou,GuiYang\n";
        cOSClient.putObject(string3, string2, string4);
        String string5 = "select s._1 from COSObject s";
        SelectObjectContentRequest selectObjectContentRequest = new SelectObjectContentRequest();
        selectObjectContentRequest.setBucketName(string3);
        selectObjectContentRequest.setKey(string2);
        selectObjectContentRequest.setExpression(string5);
        selectObjectContentRequest.setExpressionType(ExpressionType.SQL);
        InputSerialization inputSerialization = new InputSerialization();
        CSVInput cSVInput = new CSVInput();
        cSVInput.setFieldDelimiter(",");
        cSVInput.setRecordDelimiter("\n");
        inputSerialization.setCsv(cSVInput);
        inputSerialization.setCompressionType(CompressionType.NONE);
        selectObjectContentRequest.setInputSerialization(inputSerialization);
        OutputSerialization outputSerialization = new OutputSerialization();
        outputSerialization.setCsv(new CSVOutput());
        selectObjectContentRequest.setOutputSerialization(outputSerialization);
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        SelectObjectContentResult selectObjectContentResult = cOSClient.selectObjectContent(selectObjectContentRequest);
        SelectRecordsInputStream selectRecordsInputStream = selectObjectContentResult.getPayload().getRecordsInputStream(new SelectObjectContentEventVisitor(){

            @Override
            public void visit(SelectObjectContentEvent.StatsEvent statsEvent) {
                System.out.println("Received Stats, Bytes Scanned: " + statsEvent.getDetails().getBytesScanned() + " Bytes Processed: " + statsEvent.getDetails().getBytesProcessed());
            }

            @Override
            public void visit(SelectObjectContentEvent.EndEvent endEvent) {
                atomicBoolean.set(true);
                System.out.println("Received End Event. Result is complete.");
            }
        });
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(selectRecordsInputStream));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string).append("\n");
        }
        System.out.println(stringBuffer.toString());
        if (!atomicBoolean.get()) {
            throw new Exception("result was incomplete");
        }
    }

    public static void selectJsonContentDemo() throws Exception {
        String string;
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string2 = "test/my_test.json";
        String string3 = "mybucket-1251668577";
        String string4 = "{\"name\":\"xiaoming\",\"mathScore\":89,\"musicScore\":92}\n{\"name\":\"xiaowang\",\"mathScore\":93,\"musicScore\":85}\n{\"name\":\"xiaoli\",\"mathScore\":82,\"musicScore\":95}\n";
        cOSClient.putObject(string3, string2, string4);
        String string5 = "select * from COSObject s where mathScore > 85'";
        SelectObjectContentRequest selectObjectContentRequest = new SelectObjectContentRequest();
        selectObjectContentRequest.setBucketName(string3);
        selectObjectContentRequest.setKey(string2);
        selectObjectContentRequest.setExpression(string5);
        selectObjectContentRequest.setExpressionType(ExpressionType.SQL);
        InputSerialization inputSerialization = new InputSerialization();
        JSONInput jSONInput = new JSONInput();
        jSONInput.setType(JSONType.LINES);
        inputSerialization.setJson(jSONInput);
        inputSerialization.setCompressionType(CompressionType.NONE);
        selectObjectContentRequest.setInputSerialization(inputSerialization);
        OutputSerialization outputSerialization = new OutputSerialization();
        outputSerialization.setJson(new JSONOutput());
        selectObjectContentRequest.setOutputSerialization(outputSerialization);
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        SelectObjectContentResult selectObjectContentResult = cOSClient.selectObjectContent(selectObjectContentRequest);
        SelectRecordsInputStream selectRecordsInputStream = selectObjectContentResult.getPayload().getRecordsInputStream(new SelectObjectContentEventVisitor(){

            @Override
            public void visit(SelectObjectContentEvent.StatsEvent statsEvent) {
                System.out.println("Received Stats, Bytes Scanned: " + statsEvent.getDetails().getBytesScanned() + " Bytes Processed: " + statsEvent.getDetails().getBytesProcessed());
            }

            @Override
            public void visit(SelectObjectContentEvent.EndEvent endEvent) {
                atomicBoolean.set(true);
                System.out.println("Received End Event. Result is complete.");
            }
        });
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(selectRecordsInputStream));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string).append("\n");
        }
        System.out.println(stringBuffer.toString());
        if (!atomicBoolean.get()) {
            throw new Exception("result was incomplete");
        }
    }
}

