/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ListPartsRequest;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.PartSummary;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.region.Region;
import java.io.ByteArrayInputStream;
import java.util.LinkedList;
import java.util.List;

public class MultipartUploadDemo {
    public static String InitMultipartUploadDemo() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        String string2 = "aaa/bbb.txt";
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(string, string2);
        initiateMultipartUploadRequest.setStorageClass(StorageClass.Standard);
        try {
            String string3;
            InitiateMultipartUploadResult initiateMultipartUploadResult = cOSClient.initiateMultipartUpload(initiateMultipartUploadRequest);
            String string4 = string3 = initiateMultipartUploadResult.getUploadId();
            return string4;
        }
        catch (CosServiceException cosServiceException) {
            throw cosServiceException;
        }
        catch (CosClientException cosClientException) {
            throw cosClientException;
        }
        finally {
            cOSClient.shutdown();
        }
    }

    public static List<PartETag> listPartDemo(String string) {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string2 = "mybucket-1251668577";
        String string3 = "aaa/bbb.txt";
        LinkedList<PartETag> linkedList = new LinkedList<PartETag>();
        PartListing partListing = null;
        ListPartsRequest listPartsRequest = new ListPartsRequest(string2, string3, string);
        do {
            try {
                partListing = cOSClient.listParts(listPartsRequest);
            }
            catch (CosServiceException cosServiceException) {
                throw cosServiceException;
            }
            catch (CosClientException cosClientException) {
                throw cosClientException;
            }
            for (PartSummary partSummary : partListing.getParts()) {
                linkedList.add(new PartETag(partSummary.getPartNumber(), partSummary.getETag()));
            }
            listPartsRequest.setPartNumberMarker(partListing.getNextPartNumberMarker());
        } while (partListing.isTruncated());
        cOSClient.shutdown();
        return linkedList;
    }

    public static List<PartETag> UploadPartDemo(String string) {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string2 = "mybucket-1251668577";
        String string3 = "aaa/bbb.txt";
        boolean bl = false;
        LinkedList<PartETag> linkedList = new LinkedList<PartETag>();
        for (int i = 0; i < 10; ++i) {
            byte[] byArray = new byte[0x100000];
            UploadPartRequest uploadPartRequest = new UploadPartRequest();
            uploadPartRequest.setBucketName(string2);
            uploadPartRequest.setKey(string3);
            uploadPartRequest.setUploadId(string);
            uploadPartRequest.setInputStream(new ByteArrayInputStream(byArray));
            uploadPartRequest.setPartSize(byArray.length);
            uploadPartRequest.setPartNumber(i + 1);
            if (bl) {
                uploadPartRequest.setTrafficLimit(0x800000);
            }
            try {
                UploadPartResult uploadPartResult = cOSClient.uploadPart(uploadPartRequest);
                PartETag partETag = uploadPartResult.getPartETag();
                linkedList.add(partETag);
                String string4 = uploadPartResult.getCrc64Ecma();
                continue;
            }
            catch (CosServiceException cosServiceException) {
                throw cosServiceException;
            }
            catch (CosClientException cosClientException) {
                throw cosClientException;
            }
        }
        cOSClient.shutdown();
        return linkedList;
    }

    public static void completePartDemo(String string, List<PartETag> list) {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string2 = "mybucket-1251668577";
        String string3 = "aaa/bbb.txt";
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(string2, string3, string, list);
        try {
            CompleteMultipartUploadResult completeMultipartUploadResult = cOSClient.completeMultipartUpload(completeMultipartUploadRequest);
            String string4 = completeMultipartUploadResult.getETag();
            String string5 = completeMultipartUploadResult.getCrc64Ecma();
        }
        catch (CosServiceException cosServiceException) {
            throw cosServiceException;
        }
        catch (CosClientException cosClientException) {
            throw cosClientException;
        }
        cOSClient.shutdown();
    }

    public static void abortPartUploadDemo(String string) {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string2 = "mybucket-1251668577";
        String string3 = "aaa/bbb.txt";
        AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(string2, string3, string);
        try {
            cOSClient.abortMultipartUpload(abortMultipartUploadRequest);
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        cOSClient.shutdown();
    }

    public static void copyPartUploadDemo(String string) {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string2 = "mybucket-1251668577";
        String string3 = "aaa/bbb.txt";
        CopyPartRequest copyPartRequest = new CopyPartRequest();
        copyPartRequest.setSourceBucketRegion(new Region("ap-guangzhou"));
        copyPartRequest.setSourceBucketName(string2);
        copyPartRequest.setSourceKey("aaa/ccc.txt");
        copyPartRequest.setFirstByte(0L);
        copyPartRequest.setLastByte(1048575L);
        copyPartRequest.setDestinationBucketName(string2);
        copyPartRequest.setDestinationKey(string3);
        copyPartRequest.setPartNumber(1);
        copyPartRequest.setUploadId(string);
        try {
            CopyPartResult copyPartResult = cOSClient.copyPart(copyPartRequest);
            PartETag partETag = copyPartResult.getPartETag();
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        cOSClient.shutdown();
    }

    public static void main(String[] stringArray) {
        String string = MultipartUploadDemo.InitMultipartUploadDemo();
        List<PartETag> list = MultipartUploadDemo.UploadPartDemo(string);
        MultipartUploadDemo.completePartDemo(string, list);
    }
}

