/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.InstanceCredentialsFetcher;
import com.qcloud.cos.auth.InstanceCredentialsProvider;
import com.qcloud.cos.auth.InstanceMetadataCredentialsEndpointProvider;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.region.Region;
import java.io.File;

public class CAMRoleDemo {
    public static void SimpleUploadFileFromLocal() {
        InstanceMetadataCredentialsEndpointProvider instanceMetadataCredentialsEndpointProvider = new InstanceMetadataCredentialsEndpointProvider(InstanceMetadataCredentialsEndpointProvider.Instance.CVM);
        InstanceCredentialsFetcher instanceCredentialsFetcher = new InstanceCredentialsFetcher(instanceMetadataCredentialsEndpointProvider);
        InstanceCredentialsProvider instanceCredentialsProvider = new InstanceCredentialsProvider(instanceCredentialsFetcher);
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(instanceCredentialsProvider, clientConfig);
        String string = "3399demo-125xxxxxxxx";
        String string2 = "test/demo.txt";
        File file = new File("test");
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, file);
        putObjectRequest.setStorageClass(StorageClass.Standard);
        PutObjectResult putObjectResult = cOSClient.putObject(putObjectRequest);
        cOSClient.shutdown();
    }

    public static void SimpleUploadFileFromEMR() {
        InstanceMetadataCredentialsEndpointProvider instanceMetadataCredentialsEndpointProvider = new InstanceMetadataCredentialsEndpointProvider(InstanceMetadataCredentialsEndpointProvider.Instance.EMR);
        InstanceCredentialsFetcher instanceCredentialsFetcher = new InstanceCredentialsFetcher(instanceMetadataCredentialsEndpointProvider);
        InstanceCredentialsProvider instanceCredentialsProvider = new InstanceCredentialsProvider(instanceCredentialsFetcher);
        COSCredentials cOSCredentials = instanceCredentialsProvider.getCredentials();
        System.out.println(cOSCredentials.getCOSAccessKeyId());
        System.out.println(cOSCredentials.getCOSSecretKey());
        System.out.println(cOSCredentials.getCOSAppId());
        ClientConfig clientConfig = new ClientConfig(new Region("ap-chongqing"));
        COSClient cOSClient = new COSClient(instanceCredentialsProvider, clientConfig);
        String string = "aaa-125xxx";
        String string2 = "test_emr.txt";
        File file = new File("./test");
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, file);
        putObjectRequest.setStorageClass(StorageClass.Standard);
        PutObjectResult putObjectResult = cOSClient.putObject(putObjectRequest);
        System.out.println("upload file etag: " + putObjectResult.getETag());
        System.out.println("upload file requestId: " + putObjectResult.getRequestId());
        ObjectMetadata objectMetadata = cOSClient.getObjectMetadata(string, string2);
        System.out.println("get file etag: " + objectMetadata.getETag());
        cOSClient.deleteObject(string, string2);
        if (cOSClient.doesObjectExist(string, string2)) {
            System.out.println("delete failed");
        } else {
            System.out.println("delete successfully");
        }
        cOSClient.shutdown();
    }

    public static void main(String[] stringArray) {
        CAMRoleDemo.SimpleUploadFileFromEMR();
    }
}

