/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.BucketRefererConfiguration;
import com.qcloud.cos.region.Region;

public class BucketRefererDemo {
    public static COSClient cosClient = null;
    public static String bucketName = "examplebucket-1251668577";

    public static void createCosClient() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKID********************************", "********************************");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        cosClient = new COSClient(basicCOSCredentials, clientConfig);
    }

    public static void shutdown() {
        if (cosClient != null) {
            cosClient.shutdown();
            cosClient = null;
        }
    }

    public static void setBucketReferer() {
        BucketRefererConfiguration bucketRefererConfiguration = new BucketRefererConfiguration();
        bucketRefererConfiguration.setStatus(BucketRefererConfiguration.DISABLED);
        bucketRefererConfiguration.setRefererType(BucketRefererConfiguration.BLACKLIST);
        bucketRefererConfiguration.addDomain("test.com");
        bucketRefererConfiguration.addDomain("test.1.com");
        bucketRefererConfiguration.setEmptyReferConfiguration(BucketRefererConfiguration.DENY);
        cosClient.setBucketRefererConfiguration(bucketName, bucketRefererConfiguration);
    }

    public static void getBucketReferer() {
        BucketRefererConfiguration bucketRefererConfiguration = cosClient.getBucketRefererConfiguration(bucketName);
        if (bucketRefererConfiguration == null) {
            System.out.printf("bucket %s does not have referer configuration\n", bucketName);
            return;
        }
        System.out.printf("status: %s\n", bucketRefererConfiguration.getStatus());
        System.out.printf("referer type: %s\n", bucketRefererConfiguration.getRefererType());
        System.out.printf("empty referer config: %s\n", bucketRefererConfiguration.getEmptyReferConfiguration());
        for (String string : bucketRefererConfiguration.getDomainList()) {
            System.out.printf("domain: %s\n", string);
        }
    }

    public static void main(String[] stringArray) {
        BucketRefererDemo.createCosClient();
        BucketRefererDemo.setBucketReferer();
        BucketRefererDemo.getBucketReferer();
        BucketRefererDemo.shutdown();
    }
}

