/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.SetBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.lifecycle.LifecycleFilter;
import com.qcloud.cos.model.lifecycle.LifecyclePrefixPredicate;
import com.qcloud.cos.region.Region;
import java.util.ArrayList;
import java.util.List;

public class BucketLifecycleDemo {
    public String bucketName = "example-1251668577";
    public COSClient cosClient = this.COSBuilder();

    public COSClient COSBuilder() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        return new COSClient(basicCOSCredentials, clientConfig);
    }

    public void addLifeCycle(String string, String string2) {
        ArrayList<BucketLifecycleConfiguration.Rule> arrayList = new ArrayList<BucketLifecycleConfiguration.Rule>();
        BucketLifecycleConfiguration.Rule rule = new BucketLifecycleConfiguration.Rule();
        rule.setId(string);
        rule.setFilter(new LifecycleFilter(new LifecyclePrefixPredicate(string2)));
        rule.setExpirationInDays(7);
        rule.setStatus("Enabled");
        BucketLifecycleConfiguration.Rule rule2 = new BucketLifecycleConfiguration.Rule();
        rule2.setId(string + System.currentTimeMillis());
        rule2.setFilter(new LifecycleFilter(new LifecyclePrefixPredicate(string2)));
        ArrayList<BucketLifecycleConfiguration.Transition> arrayList2 = new ArrayList<BucketLifecycleConfiguration.Transition>();
        BucketLifecycleConfiguration.Transition transition = new BucketLifecycleConfiguration.Transition();
        transition.setDays(20);
        transition.setStorageClass(StorageClass.Standard_IA.toString());
        arrayList2.add(transition);
        rule2.setTransitions(arrayList2);
        rule2.setStatus("Enabled");
        rule2.setExpirationInDays(30);
        arrayList.add(rule);
        BucketLifecycleConfiguration bucketLifecycleConfiguration = new BucketLifecycleConfiguration();
        bucketLifecycleConfiguration.setRules(arrayList);
        SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest = new SetBucketLifecycleConfigurationRequest(this.bucketName, bucketLifecycleConfiguration);
        this.cosClient.setBucketLifecycleConfiguration(setBucketLifecycleConfigurationRequest);
    }

    public void queryPath() {
        BucketLifecycleConfiguration bucketLifecycleConfiguration = this.cosClient.getBucketLifecycleConfiguration(this.bucketName);
        if (bucketLifecycleConfiguration == null) {
            return;
        }
        List<BucketLifecycleConfiguration.Rule> list = bucketLifecycleConfiguration.getRules();
        for (BucketLifecycleConfiguration.Rule rule : list) {
            System.out.println("path:" + rule.getId());
        }
    }

    public Boolean deletedAllLifeCycle() {
        COSClient cOSClient = this.COSBuilder();
        cOSClient.deleteBucketLifecycleConfiguration(this.bucketName);
        return true;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        BucketLifecycleDemo bucketLifecycleDemo = new BucketLifecycleDemo();
        bucketLifecycleDemo.deletedAllLifeCycle();
        bucketLifecycleDemo.addLifeCycle("warehouse-ods-apx", "warehouse/ods/apx/");
        bucketLifecycleDemo.addLifeCycle("warehouse-ods-apx2", "warehouse/ods/apx2/");
        bucketLifecycleDemo.queryPath();
    }
}

