/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.BucketLoggingConfiguration;
import com.qcloud.cos.model.BucketTaggingConfiguration;
import com.qcloud.cos.model.BucketVersioningConfiguration;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CreateBucketRequest;
import com.qcloud.cos.model.SetBucketLoggingConfigurationRequest;
import com.qcloud.cos.model.SetBucketTaggingConfigurationRequest;
import com.qcloud.cos.model.SetBucketVersioningConfigurationRequest;
import com.qcloud.cos.model.TagSet;
import com.qcloud.cos.region.Region;
import java.util.LinkedList;
import java.util.List;

public class BucketDemo {
    public static void CreateBucketDemo() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "publicreadbucket-1251668577";
        CreateBucketRequest createBucketRequest = new CreateBucketRequest(string);
        createBucketRequest.setCannedAcl(CannedAccessControlList.PublicRead);
        Bucket bucket = cOSClient.createBucket(createBucketRequest);
        cOSClient.shutdown();
    }

    public static void SetBucketVersioning() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "examplebucket-1251668577";
        BucketVersioningConfiguration bucketVersioningConfiguration = new BucketVersioningConfiguration("Enabled");
        SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest = new SetBucketVersioningConfigurationRequest(string, bucketVersioningConfiguration);
        cOSClient.setBucketVersioningConfiguration(setBucketVersioningConfigurationRequest);
        cOSClient.shutdown();
    }

    public static void SetBucketLogging() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "examplebucket-1251668577";
        BucketLoggingConfiguration bucketLoggingConfiguration = new BucketLoggingConfiguration();
        bucketLoggingConfiguration.setDestinationBucketName(string);
        bucketLoggingConfiguration.setLogFilePrefix("logs/");
        SetBucketLoggingConfigurationRequest setBucketLoggingConfigurationRequest = new SetBucketLoggingConfigurationRequest(string, bucketLoggingConfiguration);
        cOSClient.setBucketLoggingConfiguration(setBucketLoggingConfigurationRequest);
    }

    public static void SetGetDeleteBucketTagging() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        LinkedList<TagSet> linkedList = new LinkedList<TagSet>();
        TagSet tagSet = new TagSet();
        tagSet.setTag("age", "18");
        tagSet.setTag("name", "xiaoming");
        linkedList.add(tagSet);
        BucketTaggingConfiguration bucketTaggingConfiguration = new BucketTaggingConfiguration();
        bucketTaggingConfiguration.setTagSets(linkedList);
        SetBucketTaggingConfigurationRequest setBucketTaggingConfigurationRequest = new SetBucketTaggingConfigurationRequest(string, bucketTaggingConfiguration);
        cOSClient.setBucketTaggingConfiguration(setBucketTaggingConfigurationRequest);
        cOSClient.getBucketTaggingConfiguration(string);
        cOSClient.deleteBucketTaggingConfiguration(string);
    }

    public static void DeleteBucketDemo() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "publicreadbucket-1251668577";
        cOSClient.deleteBucket(string);
        cOSClient.shutdown();
    }

    public static void JudgeBucketExistDemo() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "publicreadbucket-1251668577";
        cOSClient.doesBucketExist(string);
        cOSClient.shutdown();
    }

    public static void ListBuckets() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "****************************");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        List<Bucket> list = cOSClient.listBuckets();
        for (Bucket bucket : list) {
            System.out.println(bucket.getName());
            System.out.println(bucket.getLocation());
            System.out.println(bucket.getOwner());
            System.out.println(bucket.getType());
            System.out.println(bucket.getBucketType());
        }
    }

    public static void main(String[] stringArray) {
        BucketDemo.ListBuckets();
    }
}

