/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;

public class ConnectionUtils {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 10000;
    private static final String DEFAULT_HTTP_METHOD = "GET";
    private static ConnectionUtils instance;

    public static ConnectionUtils getInstance() {
        if (null == instance) {
            instance = new ConnectionUtils();
        }
        return instance;
    }

    private ConnectionUtils() {
    }

    public HttpURLConnection connectToEndpoint(URI uRI, Map<String, String> map) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection(Proxy.NO_PROXY);
        httpURLConnection.setConnectTimeout(5000);
        httpURLConnection.setReadTimeout(10000);
        httpURLConnection.setRequestMethod(DEFAULT_HTTP_METHOD);
        httpURLConnection.setDoOutput(true);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            httpURLConnection.addRequestProperty(entry.getKey(), entry.getValue());
        }
        httpURLConnection.connect();
        return httpURLConnection;
    }
}

