/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractCatchingFuture;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractTransformFuture;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CollectionFuture;
import com.google.common.util.concurrent.CombinedFuture;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.FuturesGetChecked;
import com.google.common.util.concurrent.GwtFuturesCatchingSpecialization;
import com.google.common.util.concurrent.ImmediateFuture;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.Partially;
import com.google.common.util.concurrent.TimeoutFuture;
import com.google.common.util.concurrent.TrustedListenableFutureTask;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import com.google.common.util.concurrent.internal.InternalFutures;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Futures
extends GwtFuturesCatchingSpecialization {
    private Futures() {
    }

    public static <V> ListenableFuture<V> immediateFuture(@ParametricNullness V v) {
        if (v == null) {
            ListenableFuture<?> listenableFuture = ImmediateFuture.NULL;
            return listenableFuture;
        }
        return new ImmediateFuture<V>(v);
    }

    public static ListenableFuture<@Nullable Void> immediateVoidFuture() {
        return ImmediateFuture.NULL;
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFuture.ImmediateFailedFuture(throwable);
    }

    public static <V> ListenableFuture<V> immediateCancelledFuture() {
        ImmediateFuture.ImmediateCancelledFuture<Object> immediateCancelledFuture = ImmediateFuture.ImmediateCancelledFuture.INSTANCE;
        if (immediateCancelledFuture != null) {
            return immediateCancelledFuture;
        }
        return new ImmediateFuture.ImmediateCancelledFuture();
    }

    public static <O> ListenableFuture<O> submit(Callable<O> callable, Executor executor) {
        TrustedListenableFutureTask<O> trustedListenableFutureTask = TrustedListenableFutureTask.create(callable);
        executor.execute(trustedListenableFutureTask);
        return trustedListenableFutureTask;
    }

    public static ListenableFuture<@Nullable Void> submit(Runnable runnable2, Executor executor) {
        TrustedListenableFutureTask<@Nullable Object> trustedListenableFutureTask = TrustedListenableFutureTask.create(runnable2, null);
        executor.execute(trustedListenableFutureTask);
        return trustedListenableFutureTask;
    }

    public static <O> ListenableFuture<O> submitAsync(AsyncCallable<O> asyncCallable, Executor executor) {
        TrustedListenableFutureTask<O> trustedListenableFutureTask = TrustedListenableFutureTask.create(asyncCallable);
        executor.execute(trustedListenableFutureTask);
        return trustedListenableFutureTask;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <O> ListenableFuture<O> scheduleAsync(AsyncCallable<O> asyncCallable, Duration duration, ScheduledExecutorService scheduledExecutorService) {
        return Futures.scheduleAsync(asyncCallable, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS, scheduledExecutorService);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <O> ListenableFuture<O> scheduleAsync(AsyncCallable<O> asyncCallable, long l, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        TrustedListenableFutureTask<O> trustedListenableFutureTask = TrustedListenableFutureTask.create(asyncCallable);
        ScheduledFuture<?> scheduledFuture = scheduledExecutorService.schedule(trustedListenableFutureTask, l, timeUnit);
        trustedListenableFutureTask.addListener(() -> scheduledFuture.cancel(false), MoreExecutors.directExecutor());
        return trustedListenableFutureTask;
    }

    @J2ktIncompatible
    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function, Executor executor) {
        return AbstractCatchingFuture.create(listenableFuture, clazz, function, executor);
    }

    @J2ktIncompatible
    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        return AbstractCatchingFuture.create(listenableFuture, clazz, asyncFunction, executor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> listenableFuture, Duration duration, ScheduledExecutorService scheduledExecutorService) {
        return Futures.withTimeout(listenableFuture, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS, scheduledExecutorService);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> listenableFuture, long l, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        if (listenableFuture.isDone()) {
            return listenableFuture;
        }
        return TimeoutFuture.create(listenableFuture, l, timeUnit, scheduledExecutorService);
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction, Executor executor) {
        return AbstractTransformFuture.create(listenableFuture, asyncFunction, executor);
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function, Executor executor) {
        return AbstractTransformFuture.create(listenableFuture, function, executor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <I, O> Future<O> lazyTransform(final Future<I> future, final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(function);
        return new Future<O>(){

            @Override
            public boolean cancel(boolean bl) {
                return future.cancel(bl);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.applyTransformation(future.get());
            }

            @Override
            public O get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.applyTransformation(future.get(l, timeUnit));
            }

            private O applyTransformation(I i) throws ExecutionException {
                try {
                    return function.apply(i);
                }
                catch (Throwable throwable) {
                    throw new ExecutionException(throwable);
                }
            }
        };
    }

    @SafeVarargs
    public static <V> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... listenableFutureArray) {
        CollectionFuture.ListFuture<? extends V> listFuture;
        CollectionFuture.ListFuture<? extends V> listFuture2 = listFuture = new CollectionFuture.ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), true);
        return listFuture2;
    }

    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        CollectionFuture.ListFuture listFuture;
        CollectionFuture.ListFuture listFuture2 = listFuture = new CollectionFuture.ListFuture(ImmutableList.copyOf(iterable), true);
        return listFuture2;
    }

    @SafeVarargs
    public static <V> FutureCombiner<V> whenAllComplete(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new FutureCombiner(false, ImmutableList.copyOf(listenableFutureArray));
    }

    public static <V> FutureCombiner<V> whenAllComplete(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new FutureCombiner(false, ImmutableList.copyOf(iterable));
    }

    @SafeVarargs
    public static <V> FutureCombiner<V> whenAllSucceed(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new FutureCombiner(true, ImmutableList.copyOf(listenableFutureArray));
    }

    public static <V> FutureCombiner<V> whenAllSucceed(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new FutureCombiner(true, ImmutableList.copyOf(iterable));
    }

    public static <V> ListenableFuture<V> nonCancellationPropagating(ListenableFuture<V> listenableFuture) {
        if (listenableFuture.isDone()) {
            return listenableFuture;
        }
        NonCancellationPropagatingFuture<V> nonCancellationPropagatingFuture = new NonCancellationPropagatingFuture<V>(listenableFuture);
        listenableFuture.addListener(nonCancellationPropagatingFuture, MoreExecutors.directExecutor());
        return nonCancellationPropagatingFuture;
    }

    @SafeVarargs
    public static <V> ListenableFuture<List<@Nullable V>> successfulAsList(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new CollectionFuture.ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), false);
    }

    public static <V> ListenableFuture<List<@Nullable V>> successfulAsList(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new CollectionFuture.ListFuture(ImmutableList.copyOf(iterable), false);
    }

    public static <T> ImmutableList<ListenableFuture<T>> inCompletionOrder(Iterable<? extends ListenableFuture<? extends T>> iterable) {
        ListenableFuture[] listenableFutureArray = Futures.gwtCompatibleToArray(iterable);
        InCompletionOrderState inCompletionOrderState = new InCompletionOrderState(listenableFutureArray);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(listenableFutureArray.length);
        for (int i = 0; i < listenableFutureArray.length; ++i) {
            builder.add(new InCompletionOrderFuture(inCompletionOrderState));
        }
        ImmutableCollection immutableCollection = builder.build();
        for (int i = 0; i < listenableFutureArray.length; ++i) {
            int n = i;
            listenableFutureArray[i].addListener(() -> Futures.lambda$inCompletionOrder$1(inCompletionOrderState, (ImmutableList)immutableCollection, n), MoreExecutors.directExecutor());
        }
        ImmutableCollection immutableCollection2 = immutableCollection;
        return immutableCollection2;
    }

    private static <T> ListenableFuture<? extends T>[] gwtCompatibleToArray(Iterable<? extends ListenableFuture<? extends T>> iterable) {
        ImmutableList<ListenableFuture<ListenableFuture>> immutableList = iterable instanceof Collection ? (ImmutableList<ListenableFuture<ListenableFuture>>)iterable : ImmutableList.copyOf(iterable);
        return immutableList.toArray(new ListenableFuture[0]);
    }

    public static <V> void addCallback(ListenableFuture<V> listenableFuture, FutureCallback<? super V> futureCallback, Executor executor) {
        Preconditions.checkNotNull(futureCallback);
        listenableFuture.addListener(new CallbackListener<V>(listenableFuture, futureCallback), executor);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public static <V> V getDone(Future<V> future) throws ExecutionException {
        Preconditions.checkState(future.isDone(), "Future was expected to be done: %s", future);
        return Uninterruptibles.getUninterruptibly(future);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz) throws X {
        return FuturesGetChecked.getChecked(future, clazz);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz, Duration duration) throws X {
        return Futures.getChecked(future, clazz, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz, long l, TimeUnit timeUnit) throws X {
        return FuturesGetChecked.getChecked(future, clazz, l, timeUnit);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public static <V> V getUnchecked(Future<V> future) {
        Preconditions.checkNotNull(future);
        try {
            return Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException executionException) {
            Futures.wrapAndThrowUnchecked(executionException.getCause());
            throw new AssertionError();
        }
    }

    private static void wrapAndThrowUnchecked(Throwable throwable) {
        if (throwable instanceof Error) {
            throw new ExecutionError((Error)throwable);
        }
        throw new UncheckedExecutionException(throwable);
    }

    private static /* synthetic */ void lambda$inCompletionOrder$1(InCompletionOrderState inCompletionOrderState, ImmutableList immutableList, int n) {
        inCompletionOrderState.recordInputCompletion(immutableList, n);
    }

    private static final class CallbackListener<V>
    implements Runnable {
        final Future<V> future;
        final FutureCallback<? super V> callback;

        CallbackListener(Future<V> future, FutureCallback<? super V> futureCallback) {
            this.future = future;
            this.callback = futureCallback;
        }

        @Override
        public void run() {
            Throwable throwable;
            if (this.future instanceof InternalFutureFailureAccess && (throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((Object)this.future))) != null) {
                this.callback.onFailure(throwable);
                return;
            }
            try {
                throwable = Futures.getDone(this.future);
            }
            catch (ExecutionException executionException) {
                this.callback.onFailure(executionException.getCause());
                return;
            }
            catch (Throwable throwable2) {
                this.callback.onFailure(throwable2);
                return;
            }
            this.callback.onSuccess(throwable);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.callback).toString();
        }
    }

    private static final class InCompletionOrderState<T> {
        private boolean wasCancelled = false;
        private boolean shouldInterrupt = true;
        private final AtomicInteger incompleteOutputCount;
        private final @Nullable ListenableFuture<? extends T>[] inputFutures;
        private volatile int delegateIndex = 0;

        private InCompletionOrderState(ListenableFuture<? extends T>[] listenableFutureArray) {
            this.inputFutures = listenableFutureArray;
            this.incompleteOutputCount = new AtomicInteger(listenableFutureArray.length);
        }

        private void recordOutputCancellation(boolean bl) {
            this.wasCancelled = true;
            if (!bl) {
                this.shouldInterrupt = false;
            }
            this.recordCompletion();
        }

        private void recordInputCompletion(ImmutableList<AbstractFuture<T>> immutableList, int n) {
            ListenableFuture<? extends T> listenableFuture = Objects.requireNonNull(this.inputFutures[n]);
            this.inputFutures[n] = null;
            for (int i = this.delegateIndex; i < immutableList.size(); ++i) {
                if (!((AbstractFuture)immutableList.get(i)).setFuture(listenableFuture)) continue;
                this.recordCompletion();
                this.delegateIndex = i + 1;
                return;
            }
            this.delegateIndex = immutableList.size();
        }

        private void recordCompletion() {
            if (this.incompleteOutputCount.decrementAndGet() == 0 && this.wasCancelled) {
                for (ListenableFuture<T> listenableFuture : this.inputFutures) {
                    if (listenableFuture == null) continue;
                    listenableFuture.cancel(this.shouldInterrupt);
                }
            }
        }
    }

    private static final class InCompletionOrderFuture<T>
    extends AbstractFuture<T> {
        @CheckForNull
        private InCompletionOrderState<T> state;

        private InCompletionOrderFuture(InCompletionOrderState<T> inCompletionOrderState) {
            this.state = inCompletionOrderState;
        }

        @Override
        public boolean cancel(boolean bl) {
            InCompletionOrderState<T> inCompletionOrderState = this.state;
            if (super.cancel(bl)) {
                ((InCompletionOrderState)Objects.requireNonNull(inCompletionOrderState)).recordOutputCancellation(bl);
                return true;
            }
            return false;
        }

        @Override
        protected void afterDone() {
            this.state = null;
        }

        @Override
        @CheckForNull
        protected String pendingToString() {
            InCompletionOrderState<T> inCompletionOrderState = this.state;
            if (inCompletionOrderState != null) {
                return "inputCount=[" + ((InCompletionOrderState)inCompletionOrderState).inputFutures.length + "], remaining=[" + ((InCompletionOrderState)inCompletionOrderState).incompleteOutputCount.get() + "]";
            }
            return null;
        }
    }

    private static final class NonCancellationPropagatingFuture<V>
    extends AbstractFuture.TrustedFuture<V>
    implements Runnable {
        @CheckForNull
        @LazyInit
        private ListenableFuture<V> delegate;

        NonCancellationPropagatingFuture(ListenableFuture<V> listenableFuture) {
            this.delegate = listenableFuture;
        }

        @Override
        public void run() {
            ListenableFuture<V> listenableFuture = this.delegate;
            if (listenableFuture != null) {
                this.setFuture(listenableFuture);
            }
        }

        @Override
        @CheckForNull
        protected String pendingToString() {
            ListenableFuture<V> listenableFuture = this.delegate;
            if (listenableFuture != null) {
                return "delegate=[" + listenableFuture + "]";
            }
            return null;
        }

        @Override
        protected void afterDone() {
            this.delegate = null;
        }
    }

    @GwtCompatible
    public static final class FutureCombiner<V> {
        private final boolean allMustSucceed;
        private final ImmutableList<ListenableFuture<? extends V>> futures;

        private FutureCombiner(boolean bl, ImmutableList<ListenableFuture<? extends V>> immutableList) {
            this.allMustSucceed = bl;
            this.futures = immutableList;
        }

        public <C> ListenableFuture<C> callAsync(AsyncCallable<C> asyncCallable, Executor executor) {
            return new CombinedFuture<C>(this.futures, this.allMustSucceed, executor, asyncCallable);
        }

        public <C> ListenableFuture<C> call(Callable<C> callable, Executor executor) {
            return new CombinedFuture<C>(this.futures, this.allMustSucceed, executor, callable);
        }

        public ListenableFuture<?> run(final Runnable runnable2, Executor executor) {
            return this.call(new Callable<Void>(this){

                @Override
                @CheckForNull
                public Void call() throws Exception {
                    runnable2.run();
                    return null;
                }
            }, executor);
        }
    }
}

