/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.TrustedListenableFutureTask;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
public final class ExecutionSequencer {
    private final AtomicReference<ListenableFuture<@Nullable Void>> ref = new AtomicReference<ListenableFuture<Void>>(Futures.immediateVoidFuture());
    @LazyInit
    private ThreadConfinedTaskQueue latestTaskQueue = new ThreadConfinedTaskQueue();

    private ExecutionSequencer() {
    }

    public static ExecutionSequencer create() {
        return new ExecutionSequencer();
    }

    public <T> ListenableFuture<T> submit(final Callable<T> callable, Executor executor) {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(executor);
        return this.submitAsync(new AsyncCallable<T>(this){

            @Override
            public ListenableFuture<T> call() throws Exception {
                return Futures.immediateFuture(callable.call());
            }

            public String toString() {
                return callable.toString();
            }
        }, executor);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public <T> ListenableFuture<T> submitAsync(final AsyncCallable<T> asyncCallable, Executor executor) {
        Preconditions.checkNotNull(asyncCallable);
        Preconditions.checkNotNull(executor);
        final TaskNonReentrantExecutor taskNonReentrantExecutor = new TaskNonReentrantExecutor(executor, this);
        AsyncCallable asyncCallable2 = new AsyncCallable<T>(this){

            @Override
            public ListenableFuture<T> call() throws Exception {
                if (!taskNonReentrantExecutor.trySetStarted()) {
                    return Futures.immediateCancelledFuture();
                }
                return asyncCallable.call();
            }

            public String toString() {
                return asyncCallable.toString();
            }
        };
        SettableFuture<@Nullable V> settableFuture = SettableFuture.create();
        @Nullable ListenableFuture listenableFuture = this.ref.getAndSet(settableFuture);
        TrustedListenableFutureTask trustedListenableFutureTask = TrustedListenableFutureTask.create(asyncCallable2);
        listenableFuture.addListener(trustedListenableFutureTask, taskNonReentrantExecutor);
        ListenableFuture listenableFuture2 = Futures.nonCancellationPropagating(trustedListenableFutureTask);
        Runnable runnable2 = () -> {
            if (trustedListenableFutureTask.isDone()) {
                settableFuture.setFuture(listenableFuture);
            } else if (listenableFuture2.isCancelled() && taskNonReentrantExecutor.trySetCancelled()) {
                trustedListenableFutureTask.cancel(false);
            }
        };
        listenableFuture2.addListener(runnable2, MoreExecutors.directExecutor());
        trustedListenableFutureTask.addListener(runnable2, MoreExecutors.directExecutor());
        return listenableFuture2;
    }

    private static final class TaskNonReentrantExecutor
    extends AtomicReference<RunningState>
    implements Runnable,
    Executor {
        @CheckForNull
        ExecutionSequencer sequencer;
        @CheckForNull
        Executor delegate;
        @CheckForNull
        Runnable task;
        @CheckForNull
        @LazyInit
        Thread submitting;

        private TaskNonReentrantExecutor(Executor executor, ExecutionSequencer executionSequencer) {
            super(RunningState.NOT_RUN);
            this.delegate = executor;
            this.sequencer = executionSequencer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable runnable2) {
            if (this.get() == RunningState.CANCELLED) {
                this.delegate = null;
                this.sequencer = null;
                return;
            }
            this.submitting = Thread.currentThread();
            try {
                ThreadConfinedTaskQueue threadConfinedTaskQueue = Objects.requireNonNull(this.sequencer).latestTaskQueue;
                if (threadConfinedTaskQueue.thread == this.submitting) {
                    this.sequencer = null;
                    Preconditions.checkState(threadConfinedTaskQueue.nextTask == null);
                    threadConfinedTaskQueue.nextTask = runnable2;
                    threadConfinedTaskQueue.nextExecutor = Objects.requireNonNull(this.delegate);
                    this.delegate = null;
                } else {
                    Executor executor = Objects.requireNonNull(this.delegate);
                    this.delegate = null;
                    this.task = runnable2;
                    executor.execute(this);
                }
            }
            finally {
                this.submitting = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread2 = Thread.currentThread();
            if (thread2 != this.submitting) {
                Runnable runnable2 = Objects.requireNonNull(this.task);
                this.task = null;
                runnable2.run();
                return;
            }
            ThreadConfinedTaskQueue threadConfinedTaskQueue = new ThreadConfinedTaskQueue();
            threadConfinedTaskQueue.thread = thread2;
            Objects.requireNonNull(this.sequencer).latestTaskQueue = threadConfinedTaskQueue;
            this.sequencer = null;
            try {
                Executor executor;
                Runnable runnable3;
                Runnable runnable4 = Objects.requireNonNull(this.task);
                this.task = null;
                runnable4.run();
                while ((runnable3 = threadConfinedTaskQueue.nextTask) != null && (executor = threadConfinedTaskQueue.nextExecutor) != null) {
                    threadConfinedTaskQueue.nextTask = null;
                    threadConfinedTaskQueue.nextExecutor = null;
                    executor.execute(runnable3);
                }
            }
            finally {
                threadConfinedTaskQueue.thread = null;
            }
        }

        private boolean trySetStarted() {
            return this.compareAndSet(RunningState.NOT_RUN, RunningState.STARTED);
        }

        private boolean trySetCancelled() {
            return this.compareAndSet(RunningState.NOT_RUN, RunningState.CANCELLED);
        }
    }

    static enum RunningState {
        NOT_RUN,
        CANCELLED,
        STARTED;

    }

    private static final class ThreadConfinedTaskQueue {
        @CheckForNull
        @LazyInit
        Thread thread;
        @CheckForNull
        Runnable nextTask;
        @CheckForNull
        Executor nextExecutor;

        private ThreadConfinedTaskQueue() {
        }
    }
}

