/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AggregateFuture;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    @CheckForNull
    @LazyInit
    private List<@Nullable Present<V>> values;

    CollectionFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl) {
        super(immutableCollection, bl, true);
        List<@Nullable T> list = immutableCollection.isEmpty() ? Collections.emptyList() : Lists.newArrayListWithCapacity(immutableCollection.size());
        for (int i = 0; i < immutableCollection.size(); ++i) {
            list.add(null);
        }
        this.values = list;
    }

    @Override
    final void collectOneValue(int n, @ParametricNullness V v) {
        List<@Nullable Present<V>> list = this.values;
        if (list != null) {
            list.set(n, new Present<V>(v));
        }
    }

    @Override
    final void handleAllCompleted() {
        List<@Nullable Present<V>> list = this.values;
        if (list != null) {
            this.set(this.combine(list));
        }
    }

    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason releaseResourcesReason) {
        super.releaseResources(releaseResourcesReason);
        this.values = null;
    }

    abstract C combine(List<@Nullable Present<V>> var1);

    private static final class Present<V> {
        @ParametricNullness
        final V value;

        Present(@ParametricNullness V v) {
            this.value = v;
        }
    }

    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl) {
            super(immutableCollection, bl);
            this.init();
        }

        @Override
        public List<@Nullable V> combine(List<@Nullable Present<V>> list) {
            ArrayList<@Nullable Object> arrayList = Lists.newArrayListWithCapacity(list.size());
            for (Present<V> present : list) {
                arrayList.add(present != null ? (Object)present.value : null);
            }
            return Collections.unmodifiableList(arrayList);
        }
    }
}

