/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.j2objc.annotations.ReflectionSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
@ReflectionSupport(value=ReflectionSupport.Level.FULL)
public class AtomicDouble
extends Number
implements Serializable {
    private static final long serialVersionUID = 0L;
    private volatile transient long value;
    private static final AtomicLongFieldUpdater<AtomicDouble> updater = AtomicLongFieldUpdater.newUpdater(AtomicDouble.class, "value");

    public AtomicDouble(double d) {
        this.value = Double.doubleToRawLongBits(d);
    }

    public AtomicDouble() {
    }

    public final double get() {
        return Double.longBitsToDouble(this.value);
    }

    public final void set(double d) {
        long l;
        this.value = l = Double.doubleToRawLongBits(d);
    }

    public final void lazySet(double d) {
        long l = Double.doubleToRawLongBits(d);
        updater.lazySet(this, l);
    }

    public final double getAndSet(double d) {
        long l = Double.doubleToRawLongBits(d);
        return Double.longBitsToDouble(updater.getAndSet(this, l));
    }

    public final boolean compareAndSet(double d, double d2) {
        return updater.compareAndSet(this, Double.doubleToRawLongBits(d), Double.doubleToRawLongBits(d2));
    }

    public final boolean weakCompareAndSet(double d, double d2) {
        return updater.weakCompareAndSet(this, Double.doubleToRawLongBits(d), Double.doubleToRawLongBits(d2));
    }

    @CanIgnoreReturnValue
    public final double getAndAdd(double d) {
        return this.getAndAccumulate(d, Double::sum);
    }

    @CanIgnoreReturnValue
    public final double addAndGet(double d) {
        return this.accumulateAndGet(d, Double::sum);
    }

    @CanIgnoreReturnValue
    public final double getAndAccumulate(double d, DoubleBinaryOperator doubleBinaryOperator) {
        Preconditions.checkNotNull(doubleBinaryOperator);
        return this.getAndUpdate(d2 -> doubleBinaryOperator.applyAsDouble(d2, d));
    }

    @CanIgnoreReturnValue
    public final double accumulateAndGet(double d, DoubleBinaryOperator doubleBinaryOperator) {
        Preconditions.checkNotNull(doubleBinaryOperator);
        return this.updateAndGet(d2 -> doubleBinaryOperator.applyAsDouble(d2, d));
    }

    @CanIgnoreReturnValue
    public final double getAndUpdate(DoubleUnaryOperator doubleUnaryOperator) {
        double d;
        double d2;
        long l;
        long l2;
        while (!updater.compareAndSet(this, l2 = this.value, l = Double.doubleToRawLongBits(d2 = doubleUnaryOperator.applyAsDouble(d = Double.longBitsToDouble(l2))))) {
        }
        return d;
    }

    @CanIgnoreReturnValue
    public final double updateAndGet(DoubleUnaryOperator doubleUnaryOperator) {
        double d;
        double d2;
        long l;
        long l2;
        while (!updater.compareAndSet(this, l2 = this.value, l = Double.doubleToRawLongBits(d2 = doubleUnaryOperator.applyAsDouble(d = Double.longBitsToDouble(l2))))) {
        }
        return d2;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeDouble(this.get());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.set(objectInputStream.readDouble());
    }
}

