/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.ShortsMethodsForWeb;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Shorts
extends ShortsMethodsForWeb {
    public static final int BYTES = 2;
    public static final short MAX_POWER_OF_TWO = 16384;

    private Shorts() {
    }

    public static int hashCode(short s2) {
        return s2;
    }

    public static short checkedCast(long l) {
        short s2 = (short)l;
        Preconditions.checkArgument((long)s2 == l, "Out of range: %s", l);
        return s2;
    }

    public static short saturatedCast(long l) {
        if (l > 32767L) {
            return Short.MAX_VALUE;
        }
        if (l < -32768L) {
            return Short.MIN_VALUE;
        }
        return (short)l;
    }

    public static int compare(short s2, short s3) {
        return s2 - s3;
    }

    public static boolean contains(short[] sArray, short s2) {
        for (short s3 : sArray) {
            if (s3 != s2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(short[] sArray, short s2) {
        return Shorts.indexOf(sArray, s2, 0, sArray.length);
    }

    private static int indexOf(short[] sArray, short s2, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (sArray[i] != s2) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] sArray, short[] sArray2) {
        Preconditions.checkNotNull(sArray, "array");
        Preconditions.checkNotNull(sArray2, "target");
        if (sArray2.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < sArray.length - sArray2.length + 1; ++i) {
            for (int j = 0; j < sArray2.length; ++j) {
                if (sArray[i + j] != sArray2[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] sArray, short s2) {
        return Shorts.lastIndexOf(sArray, s2, 0, sArray.length);
    }

    private static int lastIndexOf(short[] sArray, short s2, int n, int n2) {
        for (int i = n2 - 1; i >= n; --i) {
            if (sArray[i] != s2) continue;
            return i;
        }
        return -1;
    }

    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static short min(short ... sArray) {
        Preconditions.checkArgument(sArray.length > 0);
        short s2 = sArray[0];
        for (int i = 1; i < sArray.length; ++i) {
            if (sArray[i] >= s2) continue;
            s2 = sArray[i];
        }
        return s2;
    }

    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static short max(short ... sArray) {
        Preconditions.checkArgument(sArray.length > 0);
        short s2 = sArray[0];
        for (int i = 1; i < sArray.length; ++i) {
            if (sArray[i] <= s2) continue;
            s2 = sArray[i];
        }
        return s2;
    }

    public static short constrainToRange(short s2, short s3, short s4) {
        Preconditions.checkArgument(s3 <= s4, "min (%s) must be less than or equal to max (%s)", (int)s3, (int)s4);
        return s2 < s3 ? s3 : (s2 < s4 ? s2 : s4);
    }

    public static short[] concat(short[] ... sArray) {
        int n = 0;
        for (short[] sArray2 : sArray) {
            n += sArray2.length;
        }
        short[] sArray3 = new short[n];
        int n2 = 0;
        for (short[] sArray4 : sArray) {
            System.arraycopy(sArray4, 0, sArray3, n2, sArray4.length);
            n2 += sArray4.length;
        }
        return sArray3;
    }

    @GwtIncompatible
    public static byte[] toByteArray(short s2) {
        return new byte[]{(byte)(s2 >> 8), (byte)s2};
    }

    @GwtIncompatible
    public static short fromByteArray(byte[] byArray) {
        Preconditions.checkArgument(byArray.length >= 2, "array too small: %s < %s", byArray.length, 2);
        return Shorts.fromBytes(byArray[0], byArray[1]);
    }

    @GwtIncompatible
    public static short fromBytes(byte by, byte by2) {
        return (short)(by << 8 | by2 & 0xFF);
    }

    public static Converter<String, Short> stringConverter() {
        return ShortConverter.INSTANCE;
    }

    public static short[] ensureCapacity(short[] sArray, int n, int n2) {
        Preconditions.checkArgument(n >= 0, "Invalid minLength: %s", n);
        Preconditions.checkArgument(n2 >= 0, "Invalid padding: %s", n2);
        return sArray.length < n ? Arrays.copyOf(sArray, n + n2) : sArray;
    }

    public static String join(String string, short ... sArray) {
        Preconditions.checkNotNull(string);
        if (sArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(sArray.length * 6);
        stringBuilder.append(sArray[0]);
        for (int i = 1; i < sArray.length; ++i) {
            stringBuilder.append(string).append(sArray[i]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<short[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(short[] sArray) {
        Preconditions.checkNotNull(sArray);
        Shorts.sortDescending(sArray, 0, sArray.length);
    }

    public static void sortDescending(short[] sArray, int n, int n2) {
        Preconditions.checkNotNull(sArray);
        Preconditions.checkPositionIndexes(n, n2, sArray.length);
        Arrays.sort(sArray, n, n2);
        Shorts.reverse(sArray, n, n2);
    }

    public static void reverse(short[] sArray) {
        Preconditions.checkNotNull(sArray);
        Shorts.reverse(sArray, 0, sArray.length);
    }

    public static void reverse(short[] sArray, int n, int n2) {
        Preconditions.checkNotNull(sArray);
        Preconditions.checkPositionIndexes(n, n2, sArray.length);
        int n3 = n;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            short s2 = sArray[n3];
            sArray[n3] = sArray[i];
            sArray[i] = s2;
        }
    }

    public static void rotate(short[] sArray, int n) {
        Shorts.rotate(sArray, n, 0, sArray.length);
    }

    public static void rotate(short[] sArray, int n, int n2, int n3) {
        Preconditions.checkNotNull(sArray);
        Preconditions.checkPositionIndexes(n2, n3, sArray.length);
        if (sArray.length <= 1) {
            return;
        }
        int n4 = n3 - n2;
        int n5 = -n % n4;
        n5 = n5 < 0 ? n5 + n4 : n5;
        int n6 = n5 + n2;
        if (n6 == n2) {
            return;
        }
        Shorts.reverse(sArray, n2, n6);
        Shorts.reverse(sArray, n6, n3);
        Shorts.reverse(sArray, n2, n3);
    }

    public static short[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof ShortArrayAsList) {
            return ((ShortArrayAsList)collection).toShortArray();
        }
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = ((Number)Preconditions.checkNotNull(objectArray[i])).shortValue();
        }
        return sArray;
    }

    public static List<Short> asList(short ... sArray) {
        if (sArray.length == 0) {
            return Collections.emptyList();
        }
        return new ShortArrayAsList(sArray);
    }

    @GwtCompatible
    private static class ShortArrayAsList
    extends AbstractList<Short>
    implements Serializable,
    RandomAccess {
        final short[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        ShortArrayAsList(short[] sArray) {
            this(sArray, 0, sArray.length);
        }

        ShortArrayAsList(short[] sArray, int n, int n2) {
            this.array = sArray;
            this.start = n;
            this.end = n2;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Short get(int n) {
            Preconditions.checkElementIndex(n, this.size());
            return this.array[this.start + n];
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            return object instanceof Short && Shorts.indexOf(this.array, (Short)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@CheckForNull Object object) {
            int n;
            if (object instanceof Short && (n = Shorts.indexOf(this.array, (Short)object, this.start, this.end)) >= 0) {
                return n - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object object) {
            int n;
            if (object instanceof Short && (n = Shorts.lastIndexOf(this.array, (Short)object, this.start, this.end)) >= 0) {
                return n - this.start;
            }
            return -1;
        }

        @Override
        public Short set(int n, Short s2) {
            Preconditions.checkElementIndex(n, this.size());
            short s3 = this.array[this.start + n];
            this.array[this.start + n] = Preconditions.checkNotNull(s2);
            return s3;
        }

        @Override
        public List<Short> subList(int n, int n2) {
            int n3 = this.size();
            Preconditions.checkPositionIndexes(n, n2, n3);
            if (n == n2) {
                return Collections.emptyList();
            }
            return new ShortArrayAsList(this.array, this.start + n, this.start + n2);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayAsList) {
                ShortArrayAsList shortArrayAsList = (ShortArrayAsList)object;
                int n = this.size();
                if (shortArrayAsList.size() != n) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (this.array[this.start + i] == shortArrayAsList.array[shortArrayAsList.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n = 1;
            for (int i = this.start; i < this.end; ++i) {
                n = 31 * n + Shorts.hashCode(this.array[i]);
            }
            return n;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 6);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                stringBuilder.append(", ").append(this.array[i]);
            }
            return stringBuilder.append(']').toString();
        }

        short[] toShortArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<short[]>
    {
        INSTANCE;


        @Override
        public int compare(short[] sArray, short[] sArray2) {
            int n = Math.min(sArray.length, sArray2.length);
            for (int i = 0; i < n; ++i) {
                int n2 = Shorts.compare(sArray[i], sArray2[i]);
                if (n2 == 0) continue;
                return n2;
            }
            return sArray.length - sArray2.length;
        }

        public String toString() {
            return "Shorts.lexicographicalComparator()";
        }
    }

    private static final class ShortConverter
    extends Converter<String, Short>
    implements Serializable {
        static final Converter<String, Short> INSTANCE = new ShortConverter();
        private static final long serialVersionUID = 1L;

        private ShortConverter() {
        }

        @Override
        protected Short doForward(String string) {
            return Short.decode(string);
        }

        @Override
        protected String doBackward(Short s2) {
            return s2.toString();
        }

        public String toString() {
            return "Shorts.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

