/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;

@Immutable
@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class ImmutableIntArray
implements Serializable {
    private static final ImmutableIntArray EMPTY = new ImmutableIntArray(new int[0]);
    private final int[] array;
    private final transient int start;
    private final int end;

    public static ImmutableIntArray of() {
        return EMPTY;
    }

    public static ImmutableIntArray of(int n) {
        return new ImmutableIntArray(new int[]{n});
    }

    public static ImmutableIntArray of(int n, int n2) {
        return new ImmutableIntArray(new int[]{n, n2});
    }

    public static ImmutableIntArray of(int n, int n2, int n3) {
        return new ImmutableIntArray(new int[]{n, n2, n3});
    }

    public static ImmutableIntArray of(int n, int n2, int n3, int n4) {
        return new ImmutableIntArray(new int[]{n, n2, n3, n4});
    }

    public static ImmutableIntArray of(int n, int n2, int n3, int n4, int n5) {
        return new ImmutableIntArray(new int[]{n, n2, n3, n4, n5});
    }

    public static ImmutableIntArray of(int n, int n2, int n3, int n4, int n5, int n6) {
        return new ImmutableIntArray(new int[]{n, n2, n3, n4, n5, n6});
    }

    public static ImmutableIntArray of(int n, int ... nArray) {
        Preconditions.checkArgument(nArray.length <= 0x7FFFFFFE, "the total number of elements must fit in an int");
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = n;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        return new ImmutableIntArray(nArray2);
    }

    public static ImmutableIntArray copyOf(int[] nArray) {
        return nArray.length == 0 ? EMPTY : new ImmutableIntArray(Arrays.copyOf(nArray, nArray.length));
    }

    public static ImmutableIntArray copyOf(Collection<Integer> collection) {
        return collection.isEmpty() ? EMPTY : new ImmutableIntArray(Ints.toArray(collection));
    }

    public static ImmutableIntArray copyOf(Iterable<Integer> iterable) {
        if (iterable instanceof Collection) {
            return ImmutableIntArray.copyOf((Collection)iterable);
        }
        return ImmutableIntArray.builder().addAll(iterable).build();
    }

    public static ImmutableIntArray copyOf(IntStream intStream) {
        int[] nArray = intStream.toArray();
        return nArray.length == 0 ? EMPTY : new ImmutableIntArray(nArray);
    }

    public static Builder builder(int n) {
        Preconditions.checkArgument(n >= 0, "Invalid initialCapacity: %s", n);
        return new Builder(n);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    private ImmutableIntArray(int[] nArray) {
        this(nArray, 0, nArray.length);
    }

    private ImmutableIntArray(int[] nArray, int n, int n2) {
        this.array = nArray;
        this.start = n;
        this.end = n2;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }

    public int get(int n) {
        Preconditions.checkElementIndex(n, this.length());
        return this.array[this.start + n];
    }

    public int indexOf(int n) {
        for (int i = this.start; i < this.end; ++i) {
            if (this.array[i] != n) continue;
            return i - this.start;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        for (int i = this.end - 1; i >= this.start; --i) {
            if (this.array[i] != n) continue;
            return i - this.start;
        }
        return -1;
    }

    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    public void forEach(IntConsumer intConsumer) {
        Preconditions.checkNotNull(intConsumer);
        for (int i = this.start; i < this.end; ++i) {
            intConsumer.accept(this.array[i]);
        }
    }

    public IntStream stream() {
        return Arrays.stream(this.array, this.start, this.end);
    }

    public int[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public ImmutableIntArray subArray(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.length());
        return n == n2 ? EMPTY : new ImmutableIntArray(this.array, this.start + n, this.start + n2);
    }

    private Spliterator.OfInt spliterator() {
        return Spliterators.spliterator(this.array, this.start, this.end, 1040);
    }

    public List<Integer> asList() {
        return new AsList(this);
    }

    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableIntArray)) {
            return false;
        }
        ImmutableIntArray immutableIntArray = (ImmutableIntArray)object;
        if (this.length() != immutableIntArray.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.get(i) == immutableIntArray.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = this.start; i < this.end; ++i) {
            n *= 31;
            n += Ints.hashCode(this.array[i]);
        }
        return n;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(this.length() * 5);
        stringBuilder.append('[').append(this.array[this.start]);
        for (int i = this.start + 1; i < this.end; ++i) {
            stringBuilder.append(", ").append(this.array[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public ImmutableIntArray trimmed() {
        return this.isPartialView() ? new ImmutableIntArray(this.toArray()) : this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    static class AsList
    extends AbstractList<Integer>
    implements Serializable,
    RandomAccess {
        private final ImmutableIntArray parent;

        private AsList(ImmutableIntArray immutableIntArray) {
            this.parent = immutableIntArray;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public Integer get(int n) {
            return this.parent.get(n);
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            return this.indexOf(object) >= 0;
        }

        @Override
        public int indexOf(@CheckForNull Object object) {
            return object instanceof Integer ? this.parent.indexOf((Integer)object) : -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object object) {
            return object instanceof Integer ? this.parent.lastIndexOf((Integer)object) : -1;
        }

        @Override
        public List<Integer> subList(int n, int n2) {
            return this.parent.subArray(n, n2).asList();
        }

        @Override
        public Spliterator<Integer> spliterator() {
            return this.parent.spliterator();
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object instanceof AsList) {
                AsList asList2 = (AsList)object;
                return this.parent.equals(asList2.parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            int n = this.parent.start;
            for (Object e : list) {
                if (e instanceof Integer && this.parent.array[n++] == (Integer)e) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder {
        private int[] array;
        private int count = 0;

        Builder(int n) {
            this.array = new int[n];
        }

        @CanIgnoreReturnValue
        public Builder add(int n) {
            this.ensureRoomFor(1);
            this.array[this.count] = n;
            ++this.count;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(int[] nArray) {
            this.ensureRoomFor(nArray.length);
            System.arraycopy(nArray, 0, this.array, this.count, nArray.length);
            this.count += nArray.length;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(Iterable<Integer> iterable) {
            if (iterable instanceof Collection) {
                return this.addAll((Collection)iterable);
            }
            for (Integer n : iterable) {
                this.add(n);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(Collection<Integer> collection) {
            this.ensureRoomFor(collection.size());
            for (Integer n : collection) {
                this.array[this.count++] = n;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(IntStream intStream) {
            Spliterator.OfInt ofInt = intStream.spliterator();
            long l = ofInt.getExactSizeIfKnown();
            if (l > 0L) {
                this.ensureRoomFor(Ints.saturatedCast(l));
            }
            ofInt.forEachRemaining(this::add);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(ImmutableIntArray immutableIntArray) {
            this.ensureRoomFor(immutableIntArray.length());
            System.arraycopy(immutableIntArray.array, immutableIntArray.start, this.array, this.count, immutableIntArray.length());
            this.count += immutableIntArray.length();
            return this;
        }

        private void ensureRoomFor(int n) {
            int n2 = this.count + n;
            if (n2 > this.array.length) {
                this.array = Arrays.copyOf(this.array, Builder.expandedCapacity(this.array.length, n2));
            }
        }

        private static int expandedCapacity(int n, int n2) {
            if (n2 < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n3 = n + (n >> 1) + 1;
            if (n3 < n2) {
                n3 = Integer.highestOneBit(n2 - 1) << 1;
            }
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
            return n3;
        }

        public ImmutableIntArray build() {
            return this.count == 0 ? EMPTY : new ImmutableIntArray(this.array, 0, this.count);
        }
    }
}

